/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.component;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public final class InventoryComponent {
    public static final Codec<InventoryComponent> CODEC = ItemStack.OPTIONAL_CODEC.listOf().xmap(InventoryComponent::new, component -> component.stacks);
    public static final StreamCodec<RegistryFriendlyByteBuf, InventoryComponent> STREAM_CODEC = ItemStack.OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.list()).map(InventoryComponent::new, component -> component.stacks);
    private final List<ItemStack> stacks;

    public InventoryComponent(List<ItemStack> stacks) {
        this.stacks = stacks.stream().map(ItemStack::copy).toList();
    }

    public ItemStack get(int index) {
        return this.stacks.get(index).copy();
    }

    public Stream<ItemStack> stream() {
        return this.stacks.stream().map(ItemStack::copy);
    }

    public Iterable<ItemStack> iterate() {
        return Lists.transform(this.stacks, ItemStack::copy);
    }

    public int size() {
        return this.stacks.size();
    }

    public boolean isEmpty() {
        return this.stacks.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InventoryComponent that = (InventoryComponent)o;
        if (this.stacks.size() != that.stacks.size()) {
            return false;
        }
        for (int i = 0; i < this.stacks.size(); ++i) {
            if (ItemStack.matches((ItemStack)this.stacks.get(i), (ItemStack)that.stacks.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int i = 0;
        for (ItemStack itemStack : this.stacks) {
            i = i * 31 + ItemStack.hashItemAndComponents((ItemStack)itemStack);
        }
        return i;
    }

    public String toString() {
        return "InventoryComponent{stacks=" + String.valueOf(this.stacks) + "}";
    }
}

