/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity.base;

import java.util.Optional;
import me.jddev0.ep.block.entity.base.FluidStorageMethods;
import me.jddev0.ep.block.entity.base.UpgradableMenuProvider;
import me.jddev0.ep.block.entity.base.WorkerFluidMachineBlockEntity;
import me.jddev0.ep.inventory.CombinedContainerData;
import me.jddev0.ep.inventory.data.BooleanValueContainerData;
import me.jddev0.ep.inventory.data.ComparatorModeValueContainerData;
import me.jddev0.ep.inventory.data.EnergyValueContainerData;
import me.jddev0.ep.inventory.data.ProgressValueContainerData;
import me.jddev0.ep.inventory.data.RedstoneModeValueContainerData;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public abstract class SimpleRecipeFluidMachineBlockEntity<F extends IFluidHandler, C extends RecipeInput, R extends Recipe<C>>
extends WorkerFluidMachineBlockEntity<F, RecipeHolder<R>> {
    protected final UpgradableMenuProvider menuProvider;
    protected final RecipeType<R> recipeType;

    public SimpleRecipeFluidMachineBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState, String machineName, UpgradableMenuProvider menuProvider, int slotCount, RecipeType<R> recipeType, int baseRecipeDuration, int baseEnergyCapacity, int baseEnergyTransferRate, int baseEnergyConsumptionPerTick, FluidStorageMethods<F> fluidStorageMethods, int baseTankCapacity, UpgradeModuleModifier ... upgradeModifierSlots) {
        super(type, blockPos, blockState, machineName, slotCount, baseRecipeDuration, baseEnergyCapacity, baseEnergyTransferRate, baseEnergyConsumptionPerTick, fluidStorageMethods, baseTankCapacity, upgradeModifierSlots);
        this.menuProvider = menuProvider;
        this.recipeType = recipeType;
    }

    @Override
    protected ContainerData initContainerData() {
        return new CombinedContainerData(new ProgressValueContainerData(() -> this.progress, value -> {
            this.progress = value;
        }), new ProgressValueContainerData(() -> this.maxProgress, value -> {
            this.maxProgress = value;
        }), new EnergyValueContainerData(() -> this.hasWork() ? this.getCurrentWorkData().map(this::getEnergyConsumptionFor).orElse(-1) : -1, value -> {}), new EnergyValueContainerData(() -> this.energyConsumptionLeft, value -> {}), new BooleanValueContainerData(() -> this.hasEnoughEnergy, value -> {}), new RedstoneModeValueContainerData(() -> this.redstoneMode, value -> {
            this.redstoneMode = value;
        }), new ComparatorModeValueContainerData(() -> this.comparatorMode, value -> {
            this.comparatorMode = value;
        }));
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        this.syncEnergyToPlayer(player);
        this.syncFluidToPlayer(player);
        return this.menuProvider.createMenu(id, inventory, this, this.upgradeModuleInventory, this.data);
    }

    protected abstract C getRecipeInput(Container var1);

    protected Optional<RecipeHolder<R>> getRecipeFor(Container inventory) {
        return this.level.getRecipeManager().getRecipeFor(this.recipeType, this.getRecipeInput(inventory), this.level);
    }

    @Override
    protected final Optional<RecipeHolder<R>> getCurrentWorkData() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        return this.getRecipeFor((Container)inventory);
    }

    @Override
    protected final double getWorkDataDependentWorkDuration(RecipeHolder<R> workData) {
        return this.getRecipeDependentRecipeDuration(workData);
    }

    protected double getRecipeDependentRecipeDuration(RecipeHolder<R> recipe) {
        return 1.0;
    }

    @Override
    protected final double getWorkDataDependentEnergyConsumption(RecipeHolder<R> workData) {
        return this.getRecipeDependentEnergyConsumption(workData);
    }

    protected double getRecipeDependentEnergyConsumption(RecipeHolder<R> recipe) {
        return 1.0;
    }

    @Override
    protected final boolean hasWork() {
        return this.hasRecipe();
    }

    protected boolean hasRecipe() {
        if (this.level == null) {
            return false;
        }
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Optional<RecipeHolder<R>> recipe = this.getRecipeFor((Container)inventory);
        return recipe.isPresent() && this.canCraftRecipe(inventory, recipe.get());
    }

    @Override
    protected final void onWorkStarted(RecipeHolder<R> workData) {
        this.onStartCrafting(workData);
    }

    protected void onStartCrafting(RecipeHolder<R> recipe) {
    }

    @Override
    protected final void onWorkCompleted(RecipeHolder<R> workData) {
        this.craftItem(workData);
    }

    protected abstract void craftItem(RecipeHolder<R> var1);

    protected abstract boolean canCraftRecipe(SimpleContainer var1, RecipeHolder<R> var2);
}

