/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity.base;

import me.jddev0.ep.block.entity.base.EnergyStorageBlockEntity;
import me.jddev0.ep.block.entity.base.FluidStorageMethods;
import me.jddev0.ep.energy.IEnergizedPowerEnergyStorage;
import me.jddev0.ep.fluid.FluidStoragePacketUpdate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public abstract class FluidEnergyStorageBlockEntity<E extends IEnergizedPowerEnergyStorage, F extends IFluidHandler>
extends EnergyStorageBlockEntity<E>
implements FluidStoragePacketUpdate {
    protected final FluidStorageMethods<F> fluidStorageMethods;
    protected final F fluidStorage;
    protected final int baseTankCapacity;

    public FluidEnergyStorageBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState, int baseEnergyCapacity, int baseEnergyTransferRate, FluidStorageMethods<F> fluidStorageMethods, int baseTankCapacity) {
        super(type, blockPos, blockState, baseEnergyCapacity, baseEnergyTransferRate);
        this.fluidStorageMethods = fluidStorageMethods;
        this.baseTankCapacity = baseTankCapacity;
        this.fluidStorage = this.initFluidStorage();
    }

    protected abstract F initFluidStorage();

    @Override
    protected void saveAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        this.fluidStorageMethods.saveFluidStorage(this.fluidStorage, nbt, registries);
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.fluidStorageMethods.loadFluidStorage(this.fluidStorage, nbt, registries);
    }

    protected final void syncFluidToPlayer(Player player) {
        this.fluidStorageMethods.syncFluidToPlayer(this.fluidStorage, player, this.worldPosition);
    }

    protected final void syncFluidToPlayers(int distance) {
        if (this.level != null && !this.level.isClientSide()) {
            this.fluidStorageMethods.syncFluidToPlayers(this.fluidStorage, this.level, this.worldPosition, distance);
        }
    }

    public FluidStack getFluid(int tank) {
        return this.fluidStorageMethods.getFluid(this.fluidStorage, tank);
    }

    public int getTankCapacity(int tank) {
        return this.fluidStorageMethods.getTankCapacity(this.fluidStorage, tank);
    }

    @Override
    public void setFluid(int tank, FluidStack fluidStack) {
        this.fluidStorageMethods.setFluid(this.fluidStorage, tank, fluidStack);
    }

    @Override
    public void setTankCapacity(int tank, int capacity) {
        this.fluidStorageMethods.setTankCapacity(this.fluidStorage, tank, capacity);
    }
}

