/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity.base;

import me.jddev0.ep.block.entity.base.FluidStorageMethods;
import me.jddev0.ep.block.entity.base.UpgradableFluidEnergyStorageBlockEntity;
import me.jddev0.ep.energy.IEnergizedPowerEnergyStorage;
import me.jddev0.ep.machine.configuration.ComparatorMode;
import me.jddev0.ep.machine.configuration.ComparatorModeUpdate;
import me.jddev0.ep.machine.configuration.IComparatorModeHandler;
import me.jddev0.ep.machine.configuration.IRedstoneModeHandler;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.configuration.RedstoneModeUpdate;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.util.EnergyUtils;
import me.jddev0.ep.util.FluidUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public abstract class ConfigurableUpgradableFluidEnergyStorageBlockEntity<E extends IEnergizedPowerEnergyStorage, F extends IFluidHandler>
extends UpgradableFluidEnergyStorageBlockEntity<E, F>
implements RedstoneModeUpdate,
IRedstoneModeHandler,
ComparatorModeUpdate,
IComparatorModeHandler {
    @NotNull
    protected RedstoneMode redstoneMode = RedstoneMode.IGNORE;
    @NotNull
    protected ComparatorMode comparatorMode = ComparatorMode.FLUID;

    public ConfigurableUpgradableFluidEnergyStorageBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState, String machineName, int baseEnergyCapacity, int baseEnergyTransferRate, FluidStorageMethods<F> fluidStorageMethods, int baseTankCapacity, UpgradeModuleModifier ... upgradeModifierSlots) {
        super(type, blockPos, blockState, machineName, baseEnergyCapacity, baseEnergyTransferRate, fluidStorageMethods, baseTankCapacity, upgradeModifierSlots);
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.putInt("configuration.redstone_mode", this.redstoneMode.ordinal());
        nbt.putInt("configuration.comparator_mode", this.comparatorMode.ordinal());
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.redstoneMode = RedstoneMode.fromIndex(nbt.getInt("configuration.redstone_mode"));
        this.comparatorMode = nbt.contains("configuration.comparator_mode") ? ComparatorMode.fromIndex(nbt.getInt("configuration.comparator_mode")) : ComparatorMode.FLUID;
    }

    public int getRedstoneOutput() {
        return switch (this.comparatorMode) {
            default -> throw new MatchException(null, null);
            case ComparatorMode.ITEM -> 0;
            case ComparatorMode.FLUID -> FluidUtils.getRedstoneSignalFromFluidHandler(this.fluidStorage);
            case ComparatorMode.ENERGY -> EnergyUtils.getRedstoneSignalFromEnergyStorage(this.energyStorage);
        };
    }

    @Override
    public void setNextRedstoneMode() {
        this.redstoneMode = RedstoneMode.fromIndex(this.redstoneMode.ordinal() + 1);
        this.setChanged();
    }

    @Override
    @NotNull
    public @NotNull RedstoneMode @NotNull [] getAvailableRedstoneModes() {
        return RedstoneMode.values();
    }

    @Override
    @NotNull
    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public boolean setRedstoneMode(@NotNull RedstoneMode redstoneMode) {
        this.redstoneMode = redstoneMode;
        this.setChanged();
        return true;
    }

    @Override
    public void setNextComparatorMode() {
        do {
            this.comparatorMode = ComparatorMode.fromIndex(this.comparatorMode.ordinal() + 1);
        } while (this.comparatorMode == ComparatorMode.ITEM);
        this.setChanged();
    }

    @Override
    @NotNull
    public @NotNull ComparatorMode @NotNull [] getAvailableComparatorModes() {
        return new ComparatorMode[]{ComparatorMode.ENERGY, ComparatorMode.FLUID};
    }

    @Override
    @NotNull
    public ComparatorMode getComparatorMode() {
        return this.comparatorMode;
    }

    @Override
    public boolean setComparatorMode(@NotNull ComparatorMode comparatorMode) {
        if (comparatorMode == ComparatorMode.ITEM) {
            return false;
        }
        this.comparatorMode = comparatorMode;
        this.setChanged();
        return true;
    }
}

