/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.UpgradableEnergyStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.ReceiveOnlyEnergyStorage;
import me.jddev0.ep.inventory.CombinedContainerData;
import me.jddev0.ep.inventory.data.BooleanValueContainerData;
import me.jddev0.ep.inventory.data.EnergyValueContainerData;
import me.jddev0.ep.inventory.data.ShortValueContainerData;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.screen.WeatherControllerMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WeatherControllerBlockEntity
extends UpgradableEnergyStorageBlockEntity<ReceiveOnlyEnergyStorage> {
    private static final int WEATHER_CHANGED_TICKS = ModConfigs.COMMON_WEATHER_CONTROLLER_CONTROL_DURATION.getValue();
    private int selectedWeatherType = -1;

    public WeatherControllerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(EPBlockEntities.WEATHER_CONTROLLER_ENTITY.get(), blockPos, blockState, "weather_controller", ModConfigs.COMMON_WEATHER_CONTROLLER_CAPACITY.getValue(), ModConfigs.COMMON_WEATHER_CONTROLLER_TRANSFER_RATE.getValue(), UpgradeModuleModifier.DURATION);
    }

    @Override
    protected ContainerData initContainerData() {
        return new CombinedContainerData(new ShortValueContainerData(() -> (short)this.selectedWeatherType, value -> {
            this.selectedWeatherType = value.shortValue();
        }), new EnergyValueContainerData(() -> !this.hasInfiniteWeatherChangedDuration() || this.selectedWeatherType == -1 ? -1 : (int)this.upgradeModuleInventory.getModifierEffectSum(UpgradeModuleModifier.ENERGY_CONSUMPTION), value -> {}), new BooleanValueContainerData(this::hasEnoughEnergy, value -> {}));
    }

    @Override
    protected ReceiveOnlyEnergyStorage initEnergyStorage() {
        return new ReceiveOnlyEnergyStorage(0, this.baseEnergyCapacity, this.baseEnergyTransferRate){

            @Override
            public int getMaxReceive() {
                return Math.max(1, (int)Math.ceil((double)this.maxReceive * WeatherControllerBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_TRANSFER_RATE)));
            }

            @Override
            protected void onChange() {
                WeatherControllerBlockEntity.this.setChanged();
                WeatherControllerBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        this.syncEnergyToPlayer(player);
        return new WeatherControllerMenu(id, inventory, this, this.upgradeModuleInventory, this.data);
    }

    @Nullable
    public IEnergyStorage getEnergyStorageCapability(@Nullable Direction side) {
        return this.energyStorage;
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.put("selected_weather_type", (Tag)IntTag.valueOf((int)this.selectedWeatherType));
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.selectedWeatherType = nbt.contains("selected_weather_type") ? nbt.getInt("selected_weather_type") : -1;
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, WeatherControllerBlockEntity blockEntity) {
        if (level.isClientSide || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!blockEntity.hasInfiniteWeatherChangedDuration() || blockEntity.selectedWeatherType == -1) {
            return;
        }
        double energyConsumptionPerTick = blockEntity.upgradeModuleInventory.getModifierEffectSum(UpgradeModuleModifier.ENERGY_CONSUMPTION);
        if ((double)((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() >= energyConsumptionPerTick) {
            ((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).setEnergy((int)((double)((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() - energyConsumptionPerTick));
            if (level.getGameTime() % 100L == 0L) {
                int duration = blockEntity.getWeatherChangedDuration();
                switch (blockEntity.selectedWeatherType) {
                    case 0: {
                        serverLevel.setWeatherParameters(duration, 0, false, false);
                        break;
                    }
                    case 1: {
                        serverLevel.setWeatherParameters(0, duration, true, false);
                        break;
                    }
                    case 2: {
                        serverLevel.setWeatherParameters(0, duration, true, true);
                    }
                }
            }
        } else {
            blockEntity.setSelectedWeatherType(-1);
        }
    }

    public void clearEnergy() {
        ((ReceiveOnlyEnergyStorage)this.energyStorage).setEnergy(0);
    }

    public boolean hasEnoughEnergy() {
        if (this.hasInfiniteWeatherChangedDuration()) {
            double energyConsumptionPerTick = this.upgradeModuleInventory.getModifierEffectSum(UpgradeModuleModifier.ENERGY_CONSUMPTION);
            return (double)((ReceiveOnlyEnergyStorage)this.energyStorage).getEnergy() >= energyConsumptionPerTick;
        }
        return ((ReceiveOnlyEnergyStorage)this.energyStorage).getEnergy() >= ((ReceiveOnlyEnergyStorage)this.energyStorage).getCapacity();
    }

    public boolean hasInfiniteWeatherChangedDuration() {
        return this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.DURATION) == Double.POSITIVE_INFINITY;
    }

    public int getWeatherChangedDuration() {
        if (this.hasInfiniteWeatherChangedDuration()) {
            return 300;
        }
        return (int)Math.max(1.0, (double)WEATHER_CHANGED_TICKS * this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.DURATION));
    }

    public int getSelectedWeatherType() {
        return this.selectedWeatherType;
    }

    public void setSelectedWeatherType(int selectedWeatherType) {
        this.selectedWeatherType = selectedWeatherType;
        this.setChanged();
    }

    @Override
    protected void updateUpgradeModules() {
        if (!this.hasInfiniteWeatherChangedDuration()) {
            this.selectedWeatherType = -1;
        }
        super.updateUpgradeModules();
    }
}

