/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.jddev0.ep.block.ThermalGeneratorBlock;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.ConfigurableUpgradableFluidEnergyStorageBlockEntity;
import me.jddev0.ep.block.entity.base.FluidStorageSingleTankMethods;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.ExtractOnlyEnergyStorage;
import me.jddev0.ep.inventory.CombinedContainerData;
import me.jddev0.ep.inventory.data.ComparatorModeValueContainerData;
import me.jddev0.ep.inventory.data.EnergyValueContainerData;
import me.jddev0.ep.inventory.data.RedstoneModeValueContainerData;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.recipe.ThermalGeneratorRecipe;
import me.jddev0.ep.screen.ThermalGeneratorMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.Nullable;

public class ThermalGeneratorBlockEntity
extends ConfigurableUpgradableFluidEnergyStorageBlockEntity<ExtractOnlyEnergyStorage, FluidTank> {
    public static final float ENERGY_PRODUCTION_MULTIPLIER = ModConfigs.COMMON_THERMAL_GENERATOR_ENERGY_PRODUCTION_MULTIPLIER.getValue().floatValue();

    public ThermalGeneratorBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(EPBlockEntities.THERMAL_GENERATOR_ENTITY.get(), blockPos, blockState, "thermal_generator", ModConfigs.COMMON_THERMAL_GENERATOR_CAPACITY.getValue(), ModConfigs.COMMON_THERMAL_GENERATOR_TRANSFER_RATE.getValue(), FluidStorageSingleTankMethods.INSTANCE, ModConfigs.COMMON_THERMAL_GENERATOR_FLUID_TANK_CAPACITY.getValue() * 1000, UpgradeModuleModifier.ENERGY_CAPACITY);
    }

    @Override
    protected ExtractOnlyEnergyStorage initEnergyStorage() {
        return new ExtractOnlyEnergyStorage(0, this.baseEnergyCapacity, this.baseEnergyTransferRate){

            @Override
            public int getCapacity() {
                return Math.max(1, (int)Math.ceil((double)this.capacity * ThermalGeneratorBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CAPACITY)));
            }

            @Override
            public int getMaxExtract() {
                return Math.max(1, (int)Math.ceil((double)this.maxExtract * ThermalGeneratorBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_TRANSFER_RATE)));
            }

            @Override
            protected void onChange() {
                ThermalGeneratorBlockEntity.this.setChanged();
                ThermalGeneratorBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Override
    protected FluidTank initFluidStorage() {
        return new FluidTank(this.baseTankCapacity){

            protected void onContentsChanged() {
                ThermalGeneratorBlockEntity.this.setChanged();
                ThermalGeneratorBlockEntity.this.syncFluidToPlayers(32);
            }

            public boolean isFluidValid(FluidStack stack) {
                if (!super.isFluidValid(stack) || ThermalGeneratorBlockEntity.this.level == null) {
                    return false;
                }
                List recipes = ThermalGeneratorBlockEntity.this.level.getRecipeManager().getAllRecipesFor((RecipeType)ThermalGeneratorRecipe.Type.INSTANCE);
                return recipes.stream().map(RecipeHolder::value).map(ThermalGeneratorRecipe::getInput).anyMatch(inputs -> Arrays.stream(inputs).anyMatch(input -> stack.getFluid() == input));
            }
        };
    }

    @Override
    protected ContainerData initContainerData() {
        return new CombinedContainerData(new EnergyValueContainerData(() -> {
            if (this.level == null) {
                return 0;
            }
            List recipes = this.level.getRecipeManager().getAllRecipesFor((RecipeType)ThermalGeneratorRecipe.Type.INSTANCE);
            int rawProduction = 0;
            block0: for (RecipeHolder recipe : recipes) {
                for (Fluid fluid : ((ThermalGeneratorRecipe)recipe.value()).getInput()) {
                    if (((FluidTank)this.fluidStorage).getFluid().getFluid() != fluid) continue;
                    rawProduction = ((ThermalGeneratorRecipe)recipe.value()).getEnergyProduction();
                    rawProduction = (int)((float)rawProduction * ENERGY_PRODUCTION_MULTIPLIER);
                    break block0;
                }
            }
            int production = (int)((float)rawProduction * ((float)Math.min(((FluidTank)this.fluidStorage).getFluidAmount(), 50) / 1000.0f));
            production = Math.max(0, Math.min(production, ((ExtractOnlyEnergyStorage)this.energyStorage).getCapacity() - ((ExtractOnlyEnergyStorage)this.energyStorage).getEnergy()));
            int fluidAmount = (int)((float)production / (float)rawProduction * 1000.0f);
            return (int)((float)(rawProduction * fluidAmount) / 1000.0f);
        }, value -> {}), new EnergyValueContainerData(() -> {
            if (this.level == null) {
                return 0;
            }
            List recipes = this.level.getRecipeManager().getAllRecipesFor((RecipeType)ThermalGeneratorRecipe.Type.INSTANCE);
            int rawProduction = 0;
            block0: for (RecipeHolder recipe : recipes) {
                for (Fluid fluid : ((ThermalGeneratorRecipe)recipe.value()).getInput()) {
                    if (((FluidTank)this.fluidStorage).getFluid().getFluid() != fluid) continue;
                    rawProduction = ((ThermalGeneratorRecipe)recipe.value()).getEnergyProduction();
                    rawProduction = (int)((float)rawProduction * ENERGY_PRODUCTION_MULTIPLIER);
                    break block0;
                }
            }
            return (int)((float)(rawProduction * ((FluidTank)this.fluidStorage).getFluidAmount()) / 1000.0f);
        }, value -> {}), new RedstoneModeValueContainerData(() -> this.redstoneMode, value -> {
            this.redstoneMode = value;
        }), new ComparatorModeValueContainerData(() -> this.comparatorMode, value -> {
            this.comparatorMode = value;
        }));
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        this.syncEnergyToPlayer(player);
        this.syncFluidToPlayer(player);
        return new ThermalGeneratorMenu(id, inventory, this, this.upgradeModuleInventory, this.data);
    }

    @Nullable
    public IFluidHandler getFluidHandlerCapability(@Nullable Direction side) {
        return this.fluidStorage;
    }

    @Nullable
    public IEnergyStorage getEnergyStorageCapability(@Nullable Direction side) {
        return this.energyStorage;
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, ThermalGeneratorBlockEntity blockEntity) {
        if (level.isClientSide) {
            return;
        }
        if (blockEntity.redstoneMode.isActive((Boolean)state.getValue((Property)ThermalGeneratorBlock.POWERED))) {
            ThermalGeneratorBlockEntity.tickRecipe(level, blockPos, state, blockEntity);
        }
        ThermalGeneratorBlockEntity.transferEnergy(level, blockPos, state, blockEntity);
    }

    private static void tickRecipe(Level level, BlockPos blockPos, BlockState state, ThermalGeneratorBlockEntity blockEntity) {
        if (level.isClientSide) {
            return;
        }
        List recipes = level.getRecipeManager().getAllRecipesFor((RecipeType)ThermalGeneratorRecipe.Type.INSTANCE);
        int rawProduction = 0;
        block0: for (RecipeHolder recipe : recipes) {
            for (Fluid fluid : ((ThermalGeneratorRecipe)recipe.value()).getInput()) {
                if (((FluidTank)blockEntity.fluidStorage).getFluid().getFluid() != fluid) continue;
                rawProduction = ((ThermalGeneratorRecipe)recipe.value()).getEnergyProduction();
                rawProduction = (int)((float)rawProduction * ENERGY_PRODUCTION_MULTIPLIER);
                break block0;
            }
        }
        if (rawProduction > 0 && ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() < ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getCapacity()) {
            int production = (int)((float)rawProduction * ((float)Math.min(((FluidTank)blockEntity.fluidStorage).getFluidAmount(), 50) / 1000.0f));
            production = Math.max(0, Math.min(production, ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getCapacity() - ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getEnergy()));
            int fluidAmount = (int)((float)production / (float)rawProduction * 1000.0f);
            production = (int)((float)(rawProduction * fluidAmount) / 1000.0f);
            ((FluidTank)blockEntity.fluidStorage).drain(fluidAmount, IFluidHandler.FluidAction.EXECUTE);
            ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).setEnergy(Math.min(((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getCapacity(), ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() + production));
        }
    }

    private static void transferEnergy(Level level, BlockPos blockPos, BlockState state, ThermalGeneratorBlockEntity blockEntity) {
        if (level.isClientSide) {
            return;
        }
        ArrayList<IEnergyStorage> consumerItems = new ArrayList<IEnergyStorage>();
        ArrayList<Integer> consumerEnergyValues = new ArrayList<Integer>();
        int consumptionSum = 0;
        for (Direction direction : Direction.values()) {
            int received;
            BlockPos testPos = blockPos.relative(direction);
            BlockEntity testBlockEntity = level.getBlockEntity(testPos);
            IEnergyStorage energyStorage = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, testPos, level.getBlockState(testPos), testBlockEntity, (Object)direction.getOpposite());
            if (energyStorage == null || !energyStorage.canReceive() || (received = energyStorage.receiveEnergy(Math.min(((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getMaxExtract(), ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getEnergy()), true)) <= 0) continue;
            consumptionSum += received;
            consumerItems.add(energyStorage);
            consumerEnergyValues.add(received);
        }
        ArrayList<Integer> consumerEnergyDistributed = new ArrayList<Integer>();
        for (int i = 0; i < consumerItems.size(); ++i) {
            consumerEnergyDistributed.add(0);
        }
        int consumptionLeft = Math.min(((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getMaxExtract(), Math.min(((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getEnergy(), consumptionSum));
        ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).extractEnergy(consumptionLeft, false);
        int divisor = consumerItems.size();
        block2: while (consumptionLeft > 0) {
            int consumptionPerConsumer = consumptionLeft / divisor;
            if (consumptionPerConsumer == 0) {
                divisor = Math.max(1, divisor - 1);
                consumptionPerConsumer = consumptionLeft / divisor;
            }
            for (int i = 0; i < consumerEnergyValues.size(); ++i) {
                int consumptionDistributed = (Integer)consumerEnergyDistributed.get(i);
                int consumptionOfConsumerLeft = (Integer)consumerEnergyValues.get(i) - consumptionDistributed;
                int consumptionDistributedNew = Math.min(consumptionOfConsumerLeft, Math.min(consumptionPerConsumer, consumptionLeft));
                consumerEnergyDistributed.set(i, consumptionDistributed + consumptionDistributedNew);
                if ((consumptionLeft -= consumptionDistributedNew) == 0) break block2;
            }
        }
        for (int i = 0; i < consumerItems.size(); ++i) {
            int energy = (Integer)consumerEnergyDistributed.get(i);
            if (energy <= 0) continue;
            ((IEnergyStorage)consumerItems.get(i)).receiveEnergy(energy, false);
        }
    }
}

