/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import me.jddev0.ep.block.TeleporterBlock;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.MenuInventoryEnergyStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.ReceiveOnlyEnergyStorage;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.item.EPItems;
import me.jddev0.ep.item.TeleporterMatrixItem;
import me.jddev0.ep.screen.TeleporterMenu;
import me.jddev0.ep.util.InventoryUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TeleporterBlockEntity
extends MenuInventoryEnergyStorageBlockEntity<ReceiveOnlyEnergyStorage, ItemStackHandler> {
    public static final boolean INTRA_DIMENSIONAL_ENABLED = ModConfigs.COMMON_TELEPORTER_INTRA_DIMENSIONAL_ENABLED.getValue();
    public static final boolean INTER_DIMENSIONAL_ENABLED = ModConfigs.COMMON_TELEPORTER_INTER_DIMENSIONAL_ENABLED.getValue();
    public static final List<@NotNull ResourceLocation> DIMENSION_BLACKLIST = ModConfigs.COMMON_TELEPORTER_DIMENSION_BLACKLIST.getValue();
    public static final List<@NotNull ResourceLocation> INTRA_DIMENSIONAL_BLACKLIST = ModConfigs.COMMON_TELEPORTER_INTRA_DIMENSIONAL_BLACKLIST.getValue();
    public static final List<@NotNull ResourceLocation> INTER_DIMENSIONAL_FROM_BLACKLIST = ModConfigs.COMMON_TELEPORTER_INTER_DIMENSIONAL_FROM_BLACKLIST.getValue();
    public static final List<@NotNull ResourceLocation> INTER_DIMENSIONAL_TO_BLACKLIST = ModConfigs.COMMON_TELEPORTER_INTER_DIMENSIONAL_TO_BLACKLIST.getValue();
    public static final List<@NotNull ResourceLocation> DIMENSION_TYPE_BLACKLIST = ModConfigs.COMMON_TELEPORTER_DIMENSION_TYPE_BLACKLIST.getValue();
    public static final List<@NotNull ResourceLocation> INTRA_DIMENSIONAL_TYPE_BLACKLIST = ModConfigs.COMMON_TELEPORTER_INTRA_DIMENSIONAL_TYPE_BLACKLIST.getValue();
    public static final List<@NotNull ResourceLocation> INTER_DIMENSIONAL_FROM_TYPE_BLACKLIST = ModConfigs.COMMON_TELEPORTER_INTER_DIMENSIONAL_FROM_TYPE_BLACKLIST.getValue();
    public static final List<@NotNull ResourceLocation> INTER_DIMENSIONAL_TO_TYPE_BLACKLIST = ModConfigs.COMMON_TELEPORTER_INTER_DIMENSIONAL_TO_TYPE_BLACKLIST.getValue();
    private final IItemHandler itemHandlerSided;

    public TeleporterBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(EPBlockEntities.TELEPORTER_ENTITY.get(), blockPos, blockState, "teleporter", ModConfigs.COMMON_TELEPORTER_CAPACITY.getValue(), ModConfigs.COMMON_TELEPORTER_TRANSFER_RATE.getValue(), 1);
        this.itemHandlerSided = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> true, i -> true);
    }

    @Override
    protected ReceiveOnlyEnergyStorage initEnergyStorage() {
        return new ReceiveOnlyEnergyStorage(0, this.baseEnergyCapacity, this.baseEnergyTransferRate){

            @Override
            protected void onChange() {
                TeleporterBlockEntity.this.setChangedAndUpdateReadyState();
                TeleporterBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                TeleporterBlockEntity.this.setChangedAndUpdateReadyState();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                if (slot == 0) {
                    return stack.is((Item)EPItems.TELEPORTER_MATRIX.get());
                }
                return super.isItemValid(slot, stack);
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        this.syncEnergyToPlayer(player);
        return new TeleporterMenu(id, inventory, this);
    }

    public int getRedstoneOutput() {
        return InventoryUtils.getRedstoneSignalFromItemStackHandler(this.itemHandler);
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        return this.itemHandlerSided;
    }

    @Nullable
    public IEnergyStorage getEnergyStorageCapability(@Nullable Direction side) {
        return this.energyStorage;
    }

    public void setChangedAndUpdateReadyState() {
        boolean powered;
        boolean oldPowered = this.level.getBlockState(this.worldPosition).hasProperty((Property)TeleporterBlock.POWERED) && (Boolean)this.level.getBlockState(this.worldPosition).getValue((Property)TeleporterBlock.POWERED) != false;
        ItemStack teleporterMatrixItemStack = this.itemHandler.getStackInSlot(0);
        boolean bl = powered = ((ReceiveOnlyEnergyStorage)this.energyStorage).getEnergy() == ((ReceiveOnlyEnergyStorage)this.energyStorage).getCapacity() && teleporterMatrixItemStack.is((Item)EPItems.TELEPORTER_MATRIX.get()) && TeleporterMatrixItem.isLinked(teleporterMatrixItemStack);
        if (oldPowered ^ powered) {
            this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)TeleporterBlock.POWERED, (Comparable)Boolean.valueOf(powered)), 3);
        }
        this.setChanged();
    }

    public void onRedstoneTriggered() {
        ServerPlayer serverPlayer;
        Player player;
        block5: {
            block4: {
                Optional<Player> player2 = this.level.getEntities(EntityTypeTest.forClass(Player.class), AABB.of((BoundingBox)BoundingBox.fromCorners((Vec3i)new Vec3i(this.worldPosition.getX() - 2, this.worldPosition.getY() - 2, this.worldPosition.getZ() - 2), (Vec3i)new Vec3i(this.worldPosition.getX() + 2, this.worldPosition.getY() + 2, this.worldPosition.getZ() + 2))), EntitySelector.NO_SPECTATORS.and(entity -> entity.distanceToSqr(this.worldPosition.getCenter()) <= 4.0)).stream().min(Comparator.comparing(entity -> entity.distanceToSqr(this.worldPosition.getCenter())));
                if (player2.isEmpty()) {
                    return;
                }
                player = player2.get();
                if (!(player instanceof ServerPlayer)) break block4;
                serverPlayer = (ServerPlayer)player;
                player = this.level;
                if (player instanceof ServerLevel) break block5;
            }
            return;
        }
        ServerLevel serverLevel = (ServerLevel)player;
        serverLevel.getServer().submitAsync(() -> this.teleportPlayer(serverPlayer));
    }

    public void teleportPlayer(ServerPlayer player) {
        IEnergyStorage energyStorage = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, this.getBlockPos(), this.getBlockState(), (BlockEntity)this, null);
        if (energyStorage == null) {
            return;
        }
        TeleporterBlockEntity.teleportPlayer(player, energyStorage, () -> ((ReceiveOnlyEnergyStorage)this.energyStorage).setEnergy(0), this.getStack(0), this.level, this.worldPosition);
    }

    public static void teleportPlayer(ServerPlayer player, IEnergyStorage energyStorage, Runnable clearEnergyCallback, ItemStack teleporterMatrixItemStack, Level level, @Nullable BlockPos pos) {
        ResourceLocation toDimensionId;
        if (player.isSpectator()) {
            return;
        }
        if (energyStorage.getEnergyStored() < energyStorage.getMaxEnergyStored()) {
            player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"tooltip.energizedpower.teleporter.use.not_enough_energy").withStyle(ChatFormatting.RED)));
            return;
        }
        if (!teleporterMatrixItemStack.is((Item)EPItems.TELEPORTER_MATRIX.get())) {
            player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"tooltip.energizedpower.teleporter.use.no_teleporter_matrix").withStyle(ChatFormatting.RED)));
            return;
        }
        if (!TeleporterMatrixItem.isLinked(teleporterMatrixItemStack)) {
            player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"tooltip.energizedpower.teleporter.use.teleporter_matrix_not_bound").withStyle(ChatFormatting.RED)));
            return;
        }
        BlockPos toPos = TeleporterMatrixItem.getBlockPos(level, teleporterMatrixItemStack);
        if (toPos == null) {
            player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"tooltip.energizedpower.teleporter.use.teleporter_matrix_invalid_position").withStyle(ChatFormatting.RED)));
            return;
        }
        Level toDimension = TeleporterMatrixItem.getDimension(level, teleporterMatrixItemStack);
        if (!(toDimension instanceof ServerLevel)) {
            player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"tooltip.energizedpower.teleporter.use.teleporter_matrix_invalid_dimension").withStyle(ChatFormatting.RED)));
            return;
        }
        if (pos != null && pos.equals((Object)toPos) && level.dimension().equals(toDimension.dimension())) {
            player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"tooltip.energizedpower.teleporter.use.teleporter_self_position").withStyle(ChatFormatting.RED)));
            return;
        }
        ResourceLocation fromDimensionId = level.dimension().location();
        boolean intraDimensional = fromDimensionId.equals((Object)(toDimensionId = toDimension.dimension().location()));
        if (intraDimensional && !INTRA_DIMENSIONAL_ENABLED) {
            player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"tooltip.energizedpower.teleporter.use.intra_dimensional_disabled", (Object[])new Object[]{fromDimensionId.toString()}).withStyle(ChatFormatting.RED)));
            return;
        }
        if (!intraDimensional && !INTER_DIMENSIONAL_ENABLED) {
            player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"tooltip.energizedpower.teleporter.use.inter_dimensional_disabled", (Object[])new Object[]{fromDimensionId.toString()}).withStyle(ChatFormatting.RED)));
            return;
        }
        if (DIMENSION_BLACKLIST.contains(fromDimensionId)) {
            player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"tooltip.energizedpower.teleporter.use.blacklist.dimension", (Object[])new Object[]{fromDimensionId.toString()}).withStyle(ChatFormatting.RED)));
            return;
        }
        if (DIMENSION_BLACKLIST.contains(toDimensionId)) {
            player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"tooltip.energizedpower.teleporter.use.blacklist.dimension", (Object[])new Object[]{toDimensionId.toString()}).withStyle(ChatFormatting.RED)));
            return;
        }
        if (intraDimensional && INTRA_DIMENSIONAL_BLACKLIST.contains(fromDimensionId)) {
            player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"tooltip.energizedpower.teleporter.use.blacklist.intra_dimensional", (Object[])new Object[]{fromDimensionId.toString()}).withStyle(ChatFormatting.RED)));
            return;
        }
        if (!intraDimensional && INTER_DIMENSIONAL_FROM_BLACKLIST.contains(fromDimensionId)) {
            player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"tooltip.energizedpower.teleporter.use.blacklist.inter_dimensional_from", (Object[])new Object[]{fromDimensionId.toString()}).withStyle(ChatFormatting.RED)));
            return;
        }
        if (!intraDimensional && INTER_DIMENSIONAL_TO_BLACKLIST.contains(toDimensionId)) {
            player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"tooltip.energizedpower.teleporter.use.blacklist.inter_dimensional_to", (Object[])new Object[]{toDimensionId.toString()}).withStyle(ChatFormatting.RED)));
            return;
        }
        ResourceLocation fromDimensionTypeId = level.dimensionTypeRegistration().unwrapKey().map(ResourceKey::location).orElse(ResourceLocation.withDefaultNamespace((String)"empty"));
        ResourceLocation toDimensionTypeId = toDimension.dimensionTypeRegistration().unwrapKey().map(ResourceKey::location).orElse(ResourceLocation.withDefaultNamespace((String)"empty"));
        if (DIMENSION_TYPE_BLACKLIST.contains(fromDimensionTypeId)) {
            player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"tooltip.energizedpower.teleporter.use.blacklist.dimension_type", (Object[])new Object[]{fromDimensionTypeId.toString()}).withStyle(ChatFormatting.RED)));
            return;
        }
        if (DIMENSION_TYPE_BLACKLIST.contains(toDimensionTypeId)) {
            player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"tooltip.energizedpower.teleporter.use.blacklist.dimension_type", (Object[])new Object[]{toDimensionTypeId.toString()}).withStyle(ChatFormatting.RED)));
            return;
        }
        if (intraDimensional && INTRA_DIMENSIONAL_TYPE_BLACKLIST.contains(fromDimensionTypeId)) {
            player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"tooltip.energizedpower.teleporter.use.blacklist.intra_dimensional_type", (Object[])new Object[]{fromDimensionTypeId.toString()}).withStyle(ChatFormatting.RED)));
            return;
        }
        if (!intraDimensional && INTER_DIMENSIONAL_FROM_TYPE_BLACKLIST.contains(fromDimensionTypeId)) {
            player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"tooltip.energizedpower.teleporter.use.blacklist.inter_dimensional_from_type", (Object[])new Object[]{fromDimensionTypeId.toString()}).withStyle(ChatFormatting.RED)));
            return;
        }
        if (!intraDimensional && INTER_DIMENSIONAL_TO_TYPE_BLACKLIST.contains(toDimensionTypeId)) {
            player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"tooltip.energizedpower.teleporter.use.blacklist.inter_dimensional_to_type", (Object[])new Object[]{toDimensionTypeId.toString()}).withStyle(ChatFormatting.RED)));
            return;
        }
        BlockEntity toBlockEntity = toDimension.getBlockEntity(toPos);
        if (!(toBlockEntity instanceof TeleporterBlockEntity)) {
            player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"tooltip.energizedpower.teleporter.use.teleporter_matrix_no_teleporter").withStyle(ChatFormatting.RED)));
            return;
        }
        clearEnergyCallback.run();
        Vec3 toPosCenter = toPos.getCenter();
        player.teleportTo((ServerLevel)toDimension, toPosCenter.x(), (double)(toPos.getY() + 1), toPosCenter.z(), new HashSet(), 0.0f, 0.0f);
        player.connection.send((Packet)new ClientboundSoundPacket(Holder.direct((Object)SoundEvents.ENDERMAN_TELEPORT), SoundSource.BLOCKS, toPosCenter.x(), (double)toPos.getY(), toPosCenter.z(), 1.0f, 1.0f, toDimension.getRandom().nextLong()));
    }

    public int getSlotCount() {
        return this.itemHandler.getSlots();
    }

    public ItemStack getStack(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }
}

