/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.SimpleRecipeMachineBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.recipe.ContainerRecipeInputWrapper;
import me.jddev0.ep.recipe.EPRecipes;
import me.jddev0.ep.recipe.PulverizerRecipe;
import me.jddev0.ep.screen.PulverizerMenu;
import me.jddev0.ep.util.InventoryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

public class PulverizerBlockEntity
extends SimpleRecipeMachineBlockEntity<RecipeInput, PulverizerRecipe> {
    private final IItemHandler itemHandlerSided;

    public PulverizerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(EPBlockEntities.PULVERIZER_ENTITY.get(), blockPos, blockState, "pulverizer", PulverizerMenu::new, 3, EPRecipes.PULVERIZER_TYPE.get(), (int)ModConfigs.COMMON_PULVERIZER_RECIPE_DURATION.getValue(), (int)ModConfigs.COMMON_PULVERIZER_CAPACITY.getValue(), ModConfigs.COMMON_PULVERIZER_TRANSFER_RATE.getValue(), ModConfigs.COMMON_PULVERIZER_ENERGY_CONSUMPTION_PER_TICK.getValue(), UpgradeModuleModifier.SPEED, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY);
        this.itemHandlerSided = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0, i -> i == 1 || i == 2);
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        return this.itemHandlerSided;
    }

    @Nullable
    public IEnergyStorage getEnergyStorageCapability(@Nullable Direction side) {
        return this.energyStorage;
    }

    @Override
    protected RecipeInput getRecipeInput(Container inventory) {
        return new ContainerRecipeInputWrapper(inventory);
    }

    @Override
    protected void craftItem(RecipeHolder<PulverizerRecipe> recipe) {
        if (this.level == null || !this.hasRecipe()) {
            return;
        }
        ItemStack[] outputs = ((PulverizerRecipe)recipe.value()).generateOutputs(this.level.random, false);
        this.itemHandler.extractItem(0, 1, false);
        this.itemHandler.setStackInSlot(1, outputs[0].copyWithCount(this.itemHandler.getStackInSlot(1).getCount() + outputs[0].getCount()));
        if (!outputs[1].isEmpty()) {
            this.itemHandler.setStackInSlot(2, outputs[1].copyWithCount(this.itemHandler.getStackInSlot(2).getCount() + outputs[1].getCount()));
        }
        this.resetProgress();
    }

    @Override
    protected boolean canCraftRecipe(SimpleContainer inventory, RecipeHolder<PulverizerRecipe> recipe) {
        ItemStack[] maxOutputs = ((PulverizerRecipe)recipe.value()).getMaxOutputCounts(false);
        return this.level != null && InventoryUtils.canInsertItemIntoSlot((Container)inventory, 1, maxOutputs[0]) && (maxOutputs[1].isEmpty() || InventoryUtils.canInsertItemIntoSlot((Container)inventory, 2, maxOutputs[1]));
    }
}

