/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.SimpleRecipeMachineBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.recipe.ContainerRecipeInputWrapper;
import me.jddev0.ep.recipe.EPRecipes;
import me.jddev0.ep.recipe.PlantGrowthChamberFertilizerRecipe;
import me.jddev0.ep.recipe.PlantGrowthChamberRecipe;
import me.jddev0.ep.screen.PlantGrowthChamberMenu;
import me.jddev0.ep.util.RecipeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlantGrowthChamberBlockEntity
extends SimpleRecipeMachineBlockEntity<RecipeInput, PlantGrowthChamberRecipe> {
    public static final float RECIPE_DURATION_MULTIPLIER = ModConfigs.COMMON_PLANT_GROWTH_CHAMBER_RECIPE_DURATION_MULTIPLIER.getValue().floatValue();
    private final IItemHandler itemHandlerSidesSided;
    private final IItemHandler itemHandlerTopBottomSided;
    private double fertilizerSpeedMultiplier;
    private double fertilizerEnergyConsumptionMultiplier;

    public PlantGrowthChamberBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(EPBlockEntities.PLANT_GROWTH_CHAMBER_ENTITY.get(), blockPos, blockState, "plant_growth_chamber", PlantGrowthChamberMenu::new, 6, EPRecipes.PLANT_GROWTH_CHAMBER_TYPE.get(), 1, (int)ModConfigs.COMMON_PLANT_GROWTH_CHAMBER_CAPACITY.getValue(), ModConfigs.COMMON_PLANT_GROWTH_CHAMBER_TRANSFER_RATE.getValue(), ModConfigs.COMMON_PLANT_GROWTH_CHAMBER_ENERGY_CONSUMPTION_PER_TICK.getValue(), UpgradeModuleModifier.SPEED, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY);
        this.itemHandlerSidesSided = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0, i -> i > 1 && i < 6);
        this.itemHandlerTopBottomSided = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 1, i -> i > 1 && i < 6);
        this.fertilizerSpeedMultiplier = 1.0;
        this.fertilizerEnergyConsumptionMultiplier = 1.0;
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                PlantGrowthChamberBlockEntity.this.setChanged();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return switch (slot) {
                    case 0 -> {
                        if (PlantGrowthChamberBlockEntity.this.level == null || RecipeUtils.isIngredientOfAny(PlantGrowthChamberBlockEntity.this.level, PlantGrowthChamberRecipe.Type.INSTANCE, stack)) {
                            yield true;
                        }
                        yield false;
                    }
                    case 1 -> {
                        if (PlantGrowthChamberBlockEntity.this.level == null || RecipeUtils.isIngredientOfAny(PlantGrowthChamberBlockEntity.this.level, PlantGrowthChamberFertilizerRecipe.Type.INSTANCE, stack)) {
                            yield true;
                        }
                        yield false;
                    }
                    case 2, 3, 4, 5 -> false;
                    default -> super.isItemValid(slot, stack);
                };
            }

            public void setStackInSlot(int slot, @NotNull ItemStack stack) {
                if (slot == 0) {
                    ItemStack itemStack = this.getStackInSlot(slot);
                    if (!(PlantGrowthChamberBlockEntity.this.level == null || stack.isEmpty() || itemStack.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemStack))) {
                        PlantGrowthChamberBlockEntity.this.resetProgress();
                    }
                }
                super.setStackInSlot(slot, stack);
            }
        };
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        if (side == Direction.UP || side == Direction.DOWN) {
            return this.itemHandlerTopBottomSided;
        }
        return this.itemHandlerSidesSided;
    }

    @Nullable
    public IEnergyStorage getEnergyStorageCapability(@Nullable Direction side) {
        return this.energyStorage;
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.put("recipe.speed_multiplier", (Tag)DoubleTag.valueOf((double)this.fertilizerSpeedMultiplier));
        nbt.put("recipe.energy_consumption_multiplier", (Tag)DoubleTag.valueOf((double)this.fertilizerEnergyConsumptionMultiplier));
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.fertilizerSpeedMultiplier = nbt.getDouble("recipe.speed_multiplier");
        this.fertilizerEnergyConsumptionMultiplier = nbt.getDouble("recipe.energy_consumption_multiplier");
    }

    @Override
    protected double getRecipeDependentRecipeDuration(RecipeHolder<PlantGrowthChamberRecipe> recipe) {
        return (double)((float)((PlantGrowthChamberRecipe)recipe.value()).getTicks() * RECIPE_DURATION_MULTIPLIER) / this.fertilizerSpeedMultiplier;
    }

    @Override
    protected double getRecipeDependentEnergyConsumption(RecipeHolder<PlantGrowthChamberRecipe> recipe) {
        return this.fertilizerEnergyConsumptionMultiplier;
    }

    @Override
    protected void resetProgress() {
        super.resetProgress();
        this.fertilizerSpeedMultiplier = 1.0;
        this.fertilizerEnergyConsumptionMultiplier = 1.0;
    }

    @Override
    protected void onStartCrafting(RecipeHolder<PlantGrowthChamberRecipe> recipe) {
        if (this.level == null) {
            return;
        }
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Optional fertilizerRecipe = this.level.getRecipeManager().getRecipeFor((RecipeType)PlantGrowthChamberFertilizerRecipe.Type.INSTANCE, (RecipeInput)new ContainerRecipeInputWrapper((Container)inventory), this.level);
        if (fertilizerRecipe.isPresent()) {
            this.fertilizerSpeedMultiplier = ((PlantGrowthChamberFertilizerRecipe)((RecipeHolder)fertilizerRecipe.get()).value()).getSpeedMultiplier();
            this.fertilizerEnergyConsumptionMultiplier = ((PlantGrowthChamberFertilizerRecipe)((RecipeHolder)fertilizerRecipe.get()).value()).getEnergyConsumptionMultiplier();
            this.itemHandler.extractItem(1, 1, false);
        }
    }

    @Override
    protected RecipeInput getRecipeInput(Container inventory) {
        return new ContainerRecipeInputWrapper(inventory);
    }

    @Override
    protected void craftItem(RecipeHolder<PlantGrowthChamberRecipe> recipe) {
        if (this.level == null || !this.hasRecipe()) {
            return;
        }
        this.itemHandler.extractItem(0, 1, false);
        ArrayList<ItemStack> itemStacksInsert = new ArrayList<ItemStack>(Arrays.asList(((PlantGrowthChamberRecipe)recipe.value()).generateOutputs(this.level.random)));
        ArrayList<Integer> emptyIndices = new ArrayList<Integer>(4);
        block0: for (ItemStack itemStack : itemStacksInsert) {
            if (itemStack.isEmpty()) continue;
            for (int i = 2; i < this.itemHandler.getSlots(); ++i) {
                int amount;
                ItemStack testItemStack = this.itemHandler.getStackInSlot(i);
                if (emptyIndices.contains(i)) continue;
                if (testItemStack.isEmpty()) {
                    emptyIndices.add(i);
                    continue;
                }
                if (!ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)testItemStack) || (amount = Math.min(itemStack.getCount(), testItemStack.getMaxStackSize() - testItemStack.getCount())) <= 0) continue;
                this.itemHandler.setStackInSlot(i, this.itemHandler.getStackInSlot(i).copyWithCount(testItemStack.getCount() + amount));
                itemStack.setCount(itemStack.getCount() - amount);
                if (itemStack.isEmpty()) continue block0;
            }
            if (emptyIndices.isEmpty()) continue;
            this.itemHandler.setStackInSlot(((Integer)emptyIndices.remove(0)).intValue(), itemStack);
        }
        this.resetProgress();
    }

    @Override
    protected boolean canCraftRecipe(SimpleContainer inventory, RecipeHolder<PlantGrowthChamberRecipe> recipe) {
        return this.level != null && PlantGrowthChamberBlockEntity.canInsertItemsIntoOutputSlots(inventory, new ArrayList<ItemStack>(Arrays.asList(((PlantGrowthChamberRecipe)recipe.value()).getMaxOutputCounts())));
    }

    private static boolean canInsertItemsIntoOutputSlots(SimpleContainer inventory, List<ItemStack> itemsStacks) {
        ArrayList<Integer> checkedIndices = new ArrayList<Integer>(4);
        ArrayList<Integer> emptyIndices = new ArrayList<Integer>(4);
        block0: for (int i = Math.min(4, itemsStacks.size()) - 1; i >= 0; --i) {
            ItemStack itemStack = itemsStacks.get(i);
            for (int j = 2; j < inventory.getContainerSize(); ++j) {
                if (checkedIndices.contains(j) || emptyIndices.contains(j)) continue;
                ItemStack testItemStack = inventory.getItem(j);
                if (testItemStack.isEmpty()) {
                    emptyIndices.add(j);
                    continue;
                }
                if (!ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)testItemStack)) continue;
                int amount = Math.min(itemStack.getCount(), testItemStack.getMaxStackSize() - testItemStack.getCount());
                if (amount + testItemStack.getCount() == testItemStack.getMaxStackSize()) {
                    checkedIndices.add(j);
                }
                if (amount == itemStack.getCount()) {
                    itemsStacks.remove(i);
                    continue block0;
                }
                itemStack.shrink(amount);
            }
            if (emptyIndices.isEmpty()) {
                return false;
            }
            int index = (Integer)emptyIndices.remove(0);
            if (itemStack.getCount() == itemStack.getMaxStackSize()) {
                checkedIndices.add(index);
            }
            itemsStacks.remove(i);
        }
        return itemsStacks.isEmpty();
    }
}

