/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.List;
import me.jddev0.ep.block.MinecartChargerBlock;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.MenuEnergyStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.ReceiveOnlyEnergyStorage;
import me.jddev0.ep.entity.AbstractMinecartBatteryBox;
import me.jddev0.ep.screen.MinecartChargerMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class MinecartChargerBlockEntity
extends MenuEnergyStorageBlockEntity<ReceiveOnlyEnergyStorage> {
    public static final int MAX_TRANSFER = ModConfigs.COMMON_MINECART_CHARGER_TRANSFER_RATE.getValue();
    private boolean hasMinecartOld = true;
    private boolean hasMinecart = false;

    public MinecartChargerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(EPBlockEntities.MINECART_CHARGER_ENTITY.get(), blockPos, blockState, "minecart_charger", ModConfigs.COMMON_MINECART_CHARGER_CAPACITY.getValue(), MAX_TRANSFER);
    }

    @Override
    protected ReceiveOnlyEnergyStorage initEnergyStorage() {
        return new ReceiveOnlyEnergyStorage(0, this.baseEnergyCapacity, this.baseEnergyTransferRate){

            @Override
            protected void onChange() {
                MinecartChargerBlockEntity.this.setChanged();
                MinecartChargerBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        this.syncEnergyToPlayer(player);
        return new MinecartChargerMenu(id, inventory, this);
    }

    public int getRedstoneOutput() {
        BlockPos blockPosFacing = this.getBlockPos().relative((Direction)this.getBlockState().getValue((Property)MinecartChargerBlock.FACING));
        List minecarts = this.level.getEntities(EntityTypeTest.forClass(AbstractMinecartBatteryBox.class), new AABB((double)blockPosFacing.getX(), (double)blockPosFacing.getY(), (double)blockPosFacing.getZ(), (double)(blockPosFacing.getX() + 1), (double)(blockPosFacing.getY() + 1), (double)(blockPosFacing.getZ() + 1)), EntitySelector.ENTITY_STILL_ALIVE);
        if (minecarts.isEmpty()) {
            return 0;
        }
        AbstractMinecartBatteryBox minecart = (AbstractMinecartBatteryBox)((Object)minecarts.get(0));
        int minecartEnergy = minecart.getEnergy();
        boolean isEmptyFlag = minecartEnergy == 0;
        return Math.min(Mth.floor((float)((float)minecartEnergy / (float)minecart.getCapacity() * 14.0f)) + (isEmptyFlag ? 0 : 1), 15);
    }

    @Nullable
    public IEnergyStorage getEnergyStorageCapability(@Nullable Direction side) {
        return this.energyStorage;
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, MinecartChargerBlockEntity blockEntity) {
        if (level.isClientSide) {
            return;
        }
        if (blockEntity.hasMinecartOld != blockEntity.hasMinecart) {
            MinecartChargerBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
        }
        blockEntity.hasMinecartOld = blockEntity.hasMinecart;
        BlockPos blockPosFacing = blockEntity.getBlockPos().relative((Direction)blockEntity.getBlockState().getValue((Property)MinecartChargerBlock.FACING));
        List minecarts = level.getEntities(EntityTypeTest.forClass(AbstractMinecartBatteryBox.class), new AABB((double)blockPosFacing.getX(), (double)blockPosFacing.getY(), (double)blockPosFacing.getZ(), (double)(blockPosFacing.getX() + 1), (double)(blockPosFacing.getY() + 1), (double)(blockPosFacing.getZ() + 1)), EntitySelector.ENTITY_STILL_ALIVE);
        boolean bl = blockEntity.hasMinecart = !minecarts.isEmpty();
        if (!blockEntity.hasMinecart) {
            return;
        }
        AbstractMinecartBatteryBox minecart = (AbstractMinecartBatteryBox)((Object)minecarts.get(0));
        int transferred = Math.max(0, Math.min(Math.min(((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy(), ((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getMaxReceive()), Math.min(minecart.getTransferRate(), minecart.getCapacity() - minecart.getEnergy())));
        minecart.setEnergy(minecart.getEnergy() + transferred);
        ((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).setEnergy(((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() - transferred);
    }
}

