/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.SimpleRecipeMachineBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.recipe.ContainerRecipeInputWrapper;
import me.jddev0.ep.recipe.EPRecipes;
import me.jddev0.ep.recipe.MetalPressRecipe;
import me.jddev0.ep.registry.tags.EnergizedPowerItemTags;
import me.jddev0.ep.screen.MetalPressMenu;
import me.jddev0.ep.util.InventoryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetalPressBlockEntity
extends SimpleRecipeMachineBlockEntity<RecipeInput, MetalPressRecipe> {
    private final IItemHandler itemHandlerTopSided;
    private final IItemHandler itemHandlerOthersSided;

    public MetalPressBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(EPBlockEntities.METAL_PRESS_ENTITY.get(), blockPos, blockState, "metal_press", MetalPressMenu::new, 3, EPRecipes.METAL_PRESS_TYPE.get(), (int)ModConfigs.COMMON_METAL_PRESS_RECIPE_DURATION.getValue(), (int)ModConfigs.COMMON_METAL_PRESS_CAPACITY.getValue(), ModConfigs.COMMON_METAL_PRESS_TRANSFER_RATE.getValue(), ModConfigs.COMMON_METAL_PRESS_ENERGY_CONSUMPTION_PER_TICK.getValue(), UpgradeModuleModifier.SPEED, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY);
        this.itemHandlerTopSided = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 1, i -> i == 1);
        this.itemHandlerOthersSided = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0, i -> i == 2);
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                MetalPressBlockEntity.this.setChanged();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return switch (slot) {
                    case 0 -> {
                        if (MetalPressBlockEntity.this.level == null || MetalPressBlockEntity.this.level.getRecipeManager().getAllRecipesFor((RecipeType)MetalPressRecipe.Type.INSTANCE).stream().map(RecipeHolder::value).map(MetalPressRecipe::getInput).anyMatch(ingredient -> ingredient.test(stack))) {
                            yield true;
                        }
                        yield false;
                    }
                    case 1 -> {
                        if (MetalPressBlockEntity.this.level == null || stack.is(EnergizedPowerItemTags.METAL_PRESS_MOLDS)) {
                            yield true;
                        }
                        yield false;
                    }
                    case 2 -> false;
                    default -> super.isItemValid(slot, stack);
                };
            }

            public void setStackInSlot(int slot, @NotNull ItemStack stack) {
                if (slot == 0 || slot == 1) {
                    ItemStack itemStack = this.getStackInSlot(slot);
                    if (!(MetalPressBlockEntity.this.level == null || stack.isEmpty() || itemStack.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemStack))) {
                        MetalPressBlockEntity.this.resetProgress();
                    }
                }
                super.setStackInSlot(slot, stack);
            }

            public int getSlotLimit(int slot) {
                if (slot == 1) {
                    return 1;
                }
                return super.getSlotLimit(slot);
            }
        };
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        if (side == Direction.UP) {
            return this.itemHandlerTopSided;
        }
        return this.itemHandlerOthersSided;
    }

    @Nullable
    public IEnergyStorage getEnergyStorageCapability(@Nullable Direction side) {
        return this.energyStorage;
    }

    @Override
    protected RecipeInput getRecipeInput(Container inventory) {
        return new ContainerRecipeInputWrapper(inventory);
    }

    @Override
    protected void craftItem(RecipeHolder<MetalPressRecipe> recipe) {
        Level level;
        if (this.level == null || !this.hasRecipe() || !((level = this.level) instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ItemStack pressMold = this.itemHandler.getStackInSlot(1).copy();
        if (pressMold.isEmpty() && !pressMold.is(EnergizedPowerItemTags.METAL_PRESS_MOLDS)) {
            return;
        }
        pressMold.hurtAndBreak(1, serverLevel, null, item -> pressMold.setCount(0));
        this.itemHandler.setStackInSlot(1, pressMold);
        this.itemHandler.extractItem(0, ((MetalPressRecipe)recipe.value()).getInputCount(), false);
        this.itemHandler.setStackInSlot(2, ((MetalPressRecipe)recipe.value()).getResultItem((HolderLookup.Provider)this.level.registryAccess()).copyWithCount(this.itemHandler.getStackInSlot(2).getCount() + ((MetalPressRecipe)recipe.value()).getResultItem((HolderLookup.Provider)this.level.registryAccess()).getCount()));
        this.resetProgress();
    }

    @Override
    protected boolean canCraftRecipe(SimpleContainer inventory, RecipeHolder<MetalPressRecipe> recipe) {
        return this.level != null && InventoryUtils.canInsertItemIntoSlot((Container)inventory, 2, ((MetalPressRecipe)recipe.value()).getResultItem((HolderLookup.Provider)this.level.registryAccess()));
    }
}

