/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.EPBlockStateProperties;
import me.jddev0.ep.block.ItemConveyorBeltBlock;
import me.jddev0.ep.block.ItemConveyorBeltSorterBlock;
import me.jddev0.ep.block.entity.ItemConveyorBeltBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.inventory.CombinedContainerData;
import me.jddev0.ep.inventory.data.BooleanValueContainerData;
import me.jddev0.ep.machine.CheckboxUpdate;
import me.jddev0.ep.machine.tier.ConveyorBeltTier;
import me.jddev0.ep.screen.ItemConveyorBeltSorterMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemConveyorBeltSorterBlockEntity
extends BlockEntity
implements MenuProvider,
CheckboxUpdate {
    private final int ticksPerItem;
    private static final int PATTERN_SLOTS_PER_OUTPUT = 5;
    private final SimpleContainer patternSlots = new SimpleContainer(this, 15){

        public int getMaxStackSize() {
            return 1;
        }
    };
    private final ContainerListener updatePatternListener = container -> this.setChanged();
    protected final ContainerData data;
    private boolean[] outputBeltConnected = new boolean[]{false, false, false};
    private boolean[] whitelist = new boolean[]{true, true, true};
    private boolean[] ignoreNBT = new boolean[]{false, false, false};
    private boolean loaded;
    private final ConveyorBeltTier tier;

    public ItemConveyorBeltSorterBlockEntity(BlockPos blockPos, BlockState blockState, ConveyorBeltTier tier) {
        super(tier.getItemConveyorBeltSorterBlockEntityFromTier(), blockPos, blockState);
        this.tier = tier;
        this.patternSlots.addListener(this.updatePatternListener);
        this.data = new CombinedContainerData(new BooleanValueContainerData(() -> this.outputBeltConnected[0], value -> {
            this.outputBeltConnected[0] = value;
        }), new BooleanValueContainerData(() -> this.outputBeltConnected[1], value -> {
            this.outputBeltConnected[1] = value;
        }), new BooleanValueContainerData(() -> this.outputBeltConnected[2], value -> {
            this.outputBeltConnected[2] = value;
        }), new BooleanValueContainerData(() -> this.whitelist[0], value -> {
            this.whitelist[0] = value;
        }), new BooleanValueContainerData(() -> this.whitelist[1], value -> {
            this.whitelist[1] = value;
        }), new BooleanValueContainerData(() -> this.whitelist[2], value -> {
            this.whitelist[2] = value;
        }), new BooleanValueContainerData(() -> this.ignoreNBT[0], value -> {
            this.ignoreNBT[0] = value;
        }), new BooleanValueContainerData(() -> this.ignoreNBT[1], value -> {
            this.ignoreNBT[1] = value;
        }), new BooleanValueContainerData(() -> this.ignoreNBT[2], value -> {
            this.ignoreNBT[2] = value;
        }));
        this.ticksPerItem = switch (tier) {
            default -> throw new MatchException(null, null);
            case ConveyorBeltTier.BASIC -> ModConfigs.COMMON_BASIC_ITEM_CONVEYOR_BELT_SORTER_TICKS_PER_ITEM.getValue();
            case ConveyorBeltTier.FAST -> ModConfigs.COMMON_FAST_ITEM_CONVEYOR_BELT_SORTER_TICKS_PER_ITEM.getValue();
            case ConveyorBeltTier.EXPRESS -> ModConfigs.COMMON_EXPRESS_ITEM_CONVEYOR_BELT_SORTER_TICKS_PER_ITEM.getValue();
        };
    }

    public ConveyorBeltTier getTier() {
        return this.tier;
    }

    public Component getDisplayName() {
        return Component.translatable((String)("container.energizedpower." + (switch (this.tier) {
            default -> throw new MatchException(null, null);
            case ConveyorBeltTier.BASIC -> "item_conveyor_belt_sorter";
            case ConveyorBeltTier.FAST -> "fast_item_conveyor_belt_sorter";
            case ConveyorBeltTier.EXPRESS -> "express_item_conveyor_belt_sorter";
        })));
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new ItemConveyorBeltSorterMenu(id, inventory, this, (Container)this.patternSlots, this.data);
    }

    protected void saveAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        int i;
        super.saveAdditional(nbt, registries);
        nbt.put("pattern", this.savePatternContainer(registries));
        for (i = 0; i < 3; ++i) {
            nbt.putBoolean("recipe.whitelist." + i, this.whitelist[i]);
        }
        for (i = 0; i < 3; ++i) {
            nbt.putBoolean("recipe.ignore_nbt." + i, this.ignoreNBT[i]);
        }
    }

    private Tag savePatternContainer(HolderLookup.Provider registries) {
        NonNullList items = NonNullList.withSize((int)this.patternSlots.getContainerSize(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < this.patternSlots.getContainerSize(); ++i) {
            items.set(i, (Object)this.patternSlots.getItem(i));
        }
        return ContainerHelper.saveAllItems((CompoundTag)new CompoundTag(), (NonNullList)items, (HolderLookup.Provider)registries);
    }

    protected void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        int i;
        super.loadAdditional(nbt, registries);
        this.loadPatternContainer(nbt.getCompound("pattern"), registries);
        for (i = 0; i < 3; ++i) {
            this.whitelist[i] = nbt.getBoolean("recipe.whitelist." + i);
        }
        for (i = 0; i < 3; ++i) {
            this.ignoreNBT[i] = nbt.getBoolean("recipe.ignore_nbt." + i);
        }
    }

    private void loadPatternContainer(CompoundTag tag, HolderLookup.Provider registries) {
        this.patternSlots.removeListener(this.updatePatternListener);
        NonNullList items = NonNullList.withSize((int)this.patternSlots.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, (NonNullList)items, (HolderLookup.Provider)registries);
        for (int i = 0; i < this.patternSlots.getContainerSize(); ++i) {
            this.patternSlots.setItem(i, (ItemStack)items.get(i));
        }
        this.patternSlots.addListener(this.updatePatternListener);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, ItemConveyorBeltSorterBlockEntity blockEntity) {
        if (level.isClientSide) {
            return;
        }
        if (!blockEntity.loaded) {
            for (int i = 0; i < 3; ++i) {
                Direction facing = (Direction)state.getValue((Property)ItemConveyorBeltSorterBlock.FACING);
                Direction outputBeltDirection = switch (i) {
                    case 0 -> facing.getClockWise();
                    case 1 -> facing.getOpposite();
                    case 2 -> facing.getCounterClockWise();
                    default -> null;
                };
                BlockState outputBeltState = level.getBlockState(blockPos.relative(outputBeltDirection));
                blockEntity.setOutputBeltConnected(i, outputBeltState.getBlock() instanceof ItemConveyorBeltBlock);
            }
            blockEntity.loaded = true;
        }
        if (level.getGameTime() % (long)blockEntity.ticksPerItem == 0L) {
            Direction facing = (Direction)state.getValue((Property)ItemConveyorBeltSorterBlock.FACING);
            BlockPos inputPos = blockPos.relative(facing);
            BlockState inputBlockState = level.getBlockState(inputPos);
            if (!(inputBlockState.getBlock() instanceof ItemConveyorBeltBlock)) {
                ItemConveyorBeltSorterBlockEntity.updatePoweredState(level, blockPos, state, blockEntity, false);
                return;
            }
            EPBlockStateProperties.ConveyorBeltDirection inputBeltFacing = (EPBlockStateProperties.ConveyorBeltDirection)((Object)inputBlockState.getValue(ItemConveyorBeltBlock.FACING));
            if (inputBeltFacing.isAscending() || inputBeltFacing.getDirection().getOpposite() != facing) {
                ItemConveyorBeltSorterBlockEntity.updatePoweredState(level, blockPos, state, blockEntity, false);
                return;
            }
            BlockEntity inputBlockEntity = level.getBlockEntity(inputPos);
            if (!(inputBlockEntity instanceof ItemConveyorBeltBlockEntity)) {
                ItemConveyorBeltSorterBlockEntity.updatePoweredState(level, blockPos, state, blockEntity, false);
                return;
            }
            IItemHandler inputBeltItemStackStorage = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, inputPos, level.getBlockState(inputPos), inputBlockEntity, (Object)facing.getOpposite());
            if (inputBeltItemStackStorage == null) {
                ItemConveyorBeltSorterBlockEntity.updatePoweredState(level, blockPos, state, blockEntity, false);
                return;
            }
            ItemStack itemStackToSort = inputBeltItemStackStorage.getStackInSlot(inputBeltItemStackStorage.getSlots() - 1);
            if (itemStackToSort.isEmpty()) {
                ItemConveyorBeltSorterBlockEntity.updatePoweredState(level, blockPos, state, blockEntity, false);
                return;
            }
            for (int i = 0; i < 3; ++i) {
                if (!ItemConveyorBeltSorterBlockEntity.filterMatches(blockEntity, i, itemStackToSort)) continue;
                IItemHandler outputBeltItemStackStorage = ItemConveyorBeltSorterBlockEntity.getOutputBeltItemStackStorage(level, blockPos, state, blockEntity, i);
                if (outputBeltItemStackStorage == null) {
                    ItemConveyorBeltSorterBlockEntity.updatePoweredState(level, blockPos, state, blockEntity, false);
                    return;
                }
                ItemConveyorBeltSorterBlockEntity.tryInsertItemStackIntoOutputBelt(itemStackToSort, inputBeltItemStackStorage, outputBeltItemStackStorage);
                ItemConveyorBeltSorterBlockEntity.updatePoweredState(level, blockPos, state, blockEntity, false);
                return;
            }
            ItemConveyorBeltSorterBlockEntity.updatePoweredState(level, blockPos, state, blockEntity, true);
        }
    }

    private static void updatePoweredState(Level level, BlockPos blockPos, BlockState state, ItemConveyorBeltSorterBlockEntity blockEntity, boolean powered) {
        if (powered != (Boolean)state.getValue((Property)ItemConveyorBeltSorterBlock.POWERED)) {
            level.setBlock(blockPos, (BlockState)state.setValue((Property)ItemConveyorBeltSorterBlock.POWERED, (Comparable)Boolean.valueOf(powered)), 3);
            ItemConveyorBeltSorterBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
        }
    }

    private static boolean filterMatches(ItemConveyorBeltSorterBlockEntity blockEntity, int index, ItemStack itemStackToSort) {
        for (int i = 0; i < 5; ++i) {
            ItemStack patternItemStack = blockEntity.patternSlots.getItem(5 * index + i);
            if (patternItemStack.isEmpty() || !(blockEntity.ignoreNBT[index] ? ItemStack.isSameItem((ItemStack)itemStackToSort, (ItemStack)patternItemStack) : ItemStack.isSameItemSameComponents((ItemStack)itemStackToSort, (ItemStack)patternItemStack))) continue;
            return blockEntity.whitelist[index];
        }
        return !blockEntity.whitelist[index];
    }

    private static IItemHandler getOutputBeltItemStackStorage(Level level, BlockPos blockPos, BlockState state, ItemConveyorBeltSorterBlockEntity blockEntity, int index) {
        Direction direction = (Direction)state.getValue((Property)ItemConveyorBeltSorterBlock.FACING);
        switch (index) {
            case 0: {
                Direction direction2 = direction.getClockWise();
                break;
            }
            case 1: {
                Direction direction2 = direction.getOpposite();
                break;
            }
            case 2: {
                Direction direction2 = direction.getCounterClockWise();
                break;
            }
            default: {
                Direction direction2 = direction = null;
            }
        }
        if (direction == null) {
            return null;
        }
        BlockPos outputPos = blockPos.relative(direction);
        BlockState outputBlockState = level.getBlockState(outputPos);
        if (!(outputBlockState.getBlock() instanceof ItemConveyorBeltBlock)) {
            return null;
        }
        BlockEntity outputBlockEntity = level.getBlockEntity(outputPos);
        if (!(outputBlockEntity instanceof ItemConveyorBeltBlockEntity)) {
            return null;
        }
        return (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, outputPos, level.getBlockState(outputPos), outputBlockEntity, (Object)direction.getOpposite());
    }

    private static boolean tryInsertItemStackIntoOutputBelt(ItemStack itemStackToSort, IItemHandler inputBeltItemStackStorage, IItemHandler outputBeltItemStackStorage) {
        for (int i = 0; i < outputBeltItemStackStorage.getSlots(); ++i) {
            if (!outputBeltItemStackStorage.insertItem(i, itemStackToSort, false).isEmpty()) continue;
            inputBeltItemStackStorage.extractItem(inputBeltItemStackStorage.getSlots() - 1, 1, false);
            return true;
        }
        return false;
    }

    public void setOutputBeltConnected(int index, boolean outputBeltConnected) {
        this.outputBeltConnected[index] = outputBeltConnected;
        ItemConveyorBeltSorterBlockEntity.setChanged((Level)this.level, (BlockPos)this.getBlockPos(), (BlockState)this.getBlockState());
    }

    public void setWhitelist(int index, boolean whitelist) {
        this.whitelist[index] = whitelist;
        ItemConveyorBeltSorterBlockEntity.setChanged((Level)this.level, (BlockPos)this.getBlockPos(), (BlockState)this.getBlockState());
    }

    public void setIgnoreNBT(int index, boolean ignoreNBT) {
        this.ignoreNBT[index] = ignoreNBT;
        ItemConveyorBeltSorterBlockEntity.setChanged((Level)this.level, (BlockPos)this.getBlockPos(), (BlockState)this.getBlockState());
    }

    @Override
    public void setCheckbox(int checkboxId, boolean checked) {
        switch (checkboxId) {
            case 0: 
            case 1: 
            case 2: {
                this.setWhitelist(checkboxId, checked);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                this.setIgnoreNBT(checkboxId - 3, checked);
            }
        }
    }
}

