/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.EPBlockStateProperties;
import me.jddev0.ep.block.ItemConveyorBeltBlock;
import me.jddev0.ep.block.ItemConveyorBeltMergerBlock;
import me.jddev0.ep.block.entity.ItemConveyorBeltBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.machine.tier.ConveyorBeltTier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class ItemConveyorBeltMergerBlockEntity
extends BlockEntity {
    private final int ticksPerItem;
    private int currentInputIndex;
    private final ConveyorBeltTier tier;

    public ItemConveyorBeltMergerBlockEntity(BlockPos blockPos, BlockState blockState, ConveyorBeltTier tier) {
        super(tier.getItemConveyorBeltMergerBlockEntityFromTier(), blockPos, blockState);
        this.tier = tier;
        this.ticksPerItem = switch (tier) {
            default -> throw new MatchException(null, null);
            case ConveyorBeltTier.BASIC -> ModConfigs.COMMON_BASIC_ITEM_CONVEYOR_BELT_MERGER_TICKS_PER_ITEM.getValue();
            case ConveyorBeltTier.FAST -> ModConfigs.COMMON_FAST_ITEM_CONVEYOR_BELT_MERGER_TICKS_PER_ITEM.getValue();
            case ConveyorBeltTier.EXPRESS -> ModConfigs.COMMON_EXPRESS_ITEM_CONVEYOR_BELT_MERGER_TICKS_PER_ITEM.getValue();
        };
    }

    public ConveyorBeltTier getTier() {
        return this.tier;
    }

    protected void saveAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.putInt("current_input_index", this.currentInputIndex);
    }

    protected void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.currentInputIndex = nbt.getInt("current_input_index");
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, ItemConveyorBeltMergerBlockEntity blockEntity) {
        if (level.isClientSide) {
            return;
        }
        if (level.getGameTime() % (long)blockEntity.ticksPerItem == 0L) {
            Direction facing = (Direction)state.getValue((Property)ItemConveyorBeltMergerBlock.FACING);
            BlockPos outputPos = blockPos.relative(facing);
            BlockState outputBlockState = level.getBlockState(outputPos);
            if (!(outputBlockState.getBlock() instanceof ItemConveyorBeltBlock)) {
                return;
            }
            BlockEntity outputBlockEntity = level.getBlockEntity(outputPos);
            if (!(outputBlockEntity instanceof ItemConveyorBeltBlockEntity)) {
                return;
            }
            IItemHandler outputBeltItemStackStorage = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, outputPos, outputBlockState, outputBlockEntity, (Object)facing.getOpposite());
            if (outputBeltItemStackStorage == null) {
                return;
            }
            for (int j = 0; j < 3; ++j) {
                ItemStack itemStackToSwitch;
                IItemHandler inputBeltItemStackStorage;
                BlockEntity inputBlockEntity;
                EPBlockStateProperties.ConveyorBeltDirection inputBeltFacing;
                Direction inputDirection;
                int index = (blockEntity.currentInputIndex + j) % 3;
                switch (index) {
                    case 0: {
                        Direction direction = facing.getClockWise();
                        break;
                    }
                    case 1: {
                        Direction direction = facing.getOpposite();
                        break;
                    }
                    case 2: {
                        Direction direction = facing.getCounterClockWise();
                        break;
                    }
                    default: {
                        Direction direction = inputDirection = null;
                    }
                }
                if (inputDirection == null) {
                    return;
                }
                BlockPos inputPos = blockPos.relative(inputDirection);
                BlockState inputBlockState = level.getBlockState(inputPos);
                if (!(inputBlockState.getBlock() instanceof ItemConveyorBeltBlock) || (inputBeltFacing = (EPBlockStateProperties.ConveyorBeltDirection)((Object)inputBlockState.getValue(ItemConveyorBeltBlock.FACING))).isAscending() || inputBeltFacing.getDirection().getOpposite() != inputDirection || !((inputBlockEntity = level.getBlockEntity(inputPos)) instanceof ItemConveyorBeltBlockEntity) || (inputBeltItemStackStorage = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, inputPos, inputBlockState, inputBlockEntity, (Object)inputDirection.getOpposite())) == null || (itemStackToSwitch = inputBeltItemStackStorage.getStackInSlot(inputBeltItemStackStorage.getSlots() - 1)).isEmpty()) continue;
                for (int i = 0; i < outputBeltItemStackStorage.getSlots(); ++i) {
                    if (!outputBeltItemStackStorage.insertItem(i, itemStackToSwitch, false).isEmpty()) continue;
                    inputBeltItemStackStorage.extractItem(inputBeltItemStackStorage.getSlots() - 1, 1, false);
                    blockEntity.currentInputIndex = (index + 1) % 3;
                    ItemConveyorBeltMergerBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
                    return;
                }
            }
        }
    }
}

