/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.EPBlockStateProperties;
import me.jddev0.ep.block.ItemConveyorBeltBlock;
import me.jddev0.ep.block.entity.base.InventoryStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.inventory.ItemStackPacketUpdate;
import me.jddev0.ep.machine.tier.ConveyorBeltTier;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.ItemStackSyncS2CPacket;
import me.jddev0.ep.util.InventoryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemConveyorBeltBlockEntity
extends InventoryStorageBlockEntity<ItemStackHandler>
implements ItemStackPacketUpdate {
    private final int ticksPerStep;
    private final IItemHandler itemHandlerFrontSided;
    private final IItemHandler itemHandlerOthersSided;
    private final ConveyorBeltTier tier;

    public ItemConveyorBeltBlockEntity(BlockPos blockPos, BlockState blockState, ConveyorBeltTier tier) {
        super(tier.getItemConveyorBeltBlockEntityFromTier(), blockPos, blockState, 4);
        this.itemHandlerFrontSided = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0, i -> i == 3);
        this.itemHandlerOthersSided = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 1, i -> i == 3);
        this.tier = tier;
        this.ticksPerStep = switch (tier) {
            default -> throw new MatchException(null, null);
            case ConveyorBeltTier.BASIC -> ModConfigs.COMMON_BASIC_ITEM_CONVEYOR_BELT_TICKS_PER_STEP.getValue();
            case ConveyorBeltTier.FAST -> ModConfigs.COMMON_FAST_ITEM_CONVEYOR_BELT_TICKS_PER_STEP.getValue();
            case ConveyorBeltTier.EXPRESS -> ModConfigs.COMMON_EXPRESS_ITEM_CONVEYOR_BELT_TICKS_PER_STEP.getValue();
        };
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                ItemConveyorBeltBlockEntity.this.setChanged();
                for (int i = 0; i < this.getSlots(); ++i) {
                    if (ItemConveyorBeltBlockEntity.this.level == null || ItemConveyorBeltBlockEntity.this.level.isClientSide()) continue;
                    ModMessages.sendToPlayersWithinXBlocks(new ItemStackSyncS2CPacket(i, this.getStackInSlot(i), ItemConveyorBeltBlockEntity.this.getBlockPos()), ItemConveyorBeltBlockEntity.this.getBlockPos(), (ServerLevel)ItemConveyorBeltBlockEntity.this.level, 64);
                }
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return switch (slot) {
                    case 0, 1 -> true;
                    case 2, 3 -> false;
                    default -> super.isItemValid(slot, stack);
                };
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }

    public ConveyorBeltTier getTier() {
        return this.tier;
    }

    public int getRedstoneOutput() {
        return InventoryUtils.getRedstoneSignalFromItemStackHandler(this.itemHandler);
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        Direction facing = ((EPBlockStateProperties.ConveyorBeltDirection)((Object)this.getBlockState().getValue(ItemConveyorBeltBlock.FACING))).getDirection();
        if (side.getOpposite() == facing) {
            return this.itemHandlerFrontSided;
        }
        return this.itemHandlerOthersSided;
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, ItemConveyorBeltBlockEntity blockEntity) {
        if (level.isClientSide) {
            return;
        }
        if (level.getGameTime() % 100L == 0L) {
            for (int i = 0; i < blockEntity.itemHandler.getSlots(); ++i) {
                if (level.isClientSide()) continue;
                ModMessages.sendToPlayersWithinXBlocks(new ItemStackSyncS2CPacket(i, blockEntity.itemHandler.getStackInSlot(i), blockPos), blockPos, (ServerLevel)level, 64);
            }
        }
        if (level.getGameTime() % (long)blockEntity.ticksPerStep == 0L) {
            int slotCount = blockEntity.itemHandler.getSlots();
            if (!blockEntity.itemHandler.getStackInSlot(slotCount - 1).isEmpty()) {
                ItemConveyorBeltBlockEntity.insertItemStackIntoBlockEntity(level, blockPos, state, blockEntity, blockEntity.itemHandler.getStackInSlot(slotCount - 1).copy());
            }
            for (int i = slotCount - 2; i >= 0; --i) {
                ItemStack toItemStack;
                ItemStack fromItemStack = blockEntity.itemHandler.getStackInSlot(i);
                if (fromItemStack.isEmpty() || !(toItemStack = blockEntity.itemHandler.getStackInSlot(i + 1)).isEmpty()) continue;
                blockEntity.itemHandler.setStackInSlot(i, ItemStack.EMPTY);
                blockEntity.itemHandler.setStackInSlot(i + 1, fromItemStack);
            }
        }
    }

    private static void insertItemStackIntoBlockEntity(Level level, BlockPos blockPos, BlockState state, ItemConveyorBeltBlockEntity blockEntity, ItemStack itemStackToInsert) {
        EPBlockStateProperties.ConveyorBeltDirection facing = (EPBlockStateProperties.ConveyorBeltDirection)((Object)blockEntity.getBlockState().getValue(ItemConveyorBeltBlock.FACING));
        Direction facingDirection = facing.getDirection();
        BlockPos testPos = blockPos.relative(facingDirection);
        if (facing.isAscending()) {
            testPos = testPos.relative(Direction.UP);
        }
        BlockEntity testBlockEntity = level.getBlockEntity(testPos);
        IItemHandler itemStackStorage = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, testPos, level.getBlockState(testPos), testBlockEntity, (Object)facingDirection.getOpposite());
        if (itemStackStorage == null) {
            BlockState testBlockState = level.getBlockState(testPos = testPos.relative(Direction.DOWN));
            if (!(testBlockState.getBlock() instanceof ItemConveyorBeltBlock)) {
                return;
            }
            EPBlockStateProperties.ConveyorBeltDirection testFacing = (EPBlockStateProperties.ConveyorBeltDirection)((Object)testBlockState.getValue(ItemConveyorBeltBlock.FACING));
            if (!testFacing.isDescending() || testFacing.getDirection() != facingDirection) {
                return;
            }
            testBlockEntity = level.getBlockEntity(testPos);
            if (!(testBlockEntity instanceof ItemConveyorBeltBlockEntity)) {
                return;
            }
            itemStackStorage = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, testPos, testBlockState, testBlockEntity, (Object)facingDirection.getOpposite());
            if (itemStackStorage == null) {
                return;
            }
        }
        for (int i = 0; i < itemStackStorage.getSlots(); ++i) {
            if (!itemStackStorage.insertItem(i, itemStackToInsert, false).isEmpty()) continue;
            blockEntity.itemHandler.setStackInSlot(blockEntity.itemHandler.getSlots() - 1, ItemStack.EMPTY);
            break;
        }
    }

    public int getSlotCount() {
        return this.itemHandler.getSlots();
    }

    public ItemStack getStack(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }

    @Override
    public void setItemStack(int slot, ItemStack itemStack) {
        this.itemHandler.setStackInSlot(slot, itemStack);
    }
}

