/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.ArrayList;
import java.util.List;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.UpgradableEnergyStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.ExtractOnlyEnergyStorage;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.recipe.HeatGeneratorRecipe;
import me.jddev0.ep.screen.HeatGeneratorMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class HeatGeneratorBlockEntity
extends UpgradableEnergyStorageBlockEntity<ExtractOnlyEnergyStorage> {
    public static final float ENERGY_PRODUCTION_MULTIPLIER = ModConfigs.COMMON_HEAT_GENERATOR_ENERGY_PRODUCTION_MULTIPLIER.getValue().floatValue();

    public HeatGeneratorBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(EPBlockEntities.HEAT_GENERATOR_ENTITY.get(), blockPos, blockState, "heat_generator", ModConfigs.COMMON_HEAT_GENERATOR_CAPACITY.getValue(), ModConfigs.COMMON_HEAT_GENERATOR_TRANSFER_RATE.getValue(), UpgradeModuleModifier.ENERGY_CAPACITY);
    }

    @Override
    protected ExtractOnlyEnergyStorage initEnergyStorage() {
        return new ExtractOnlyEnergyStorage(0, this.baseEnergyCapacity, this.baseEnergyTransferRate){

            @Override
            public int getCapacity() {
                return Math.max(1, (int)Math.ceil((double)this.capacity * HeatGeneratorBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CAPACITY)));
            }

            @Override
            public int getMaxExtract() {
                return Math.max(1, (int)Math.ceil((double)this.maxExtract * HeatGeneratorBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_TRANSFER_RATE)));
            }

            @Override
            protected void onChange() {
                HeatGeneratorBlockEntity.this.setChanged();
                HeatGeneratorBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        this.syncEnergyToPlayer(player);
        return new HeatGeneratorMenu(id, inventory, this, this.upgradeModuleInventory);
    }

    @Nullable
    public IEnergyStorage getEnergyStorageCapability(@Nullable Direction side) {
        return this.energyStorage;
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, HeatGeneratorBlockEntity blockEntity) {
        if (level.isClientSide) {
            return;
        }
        List recipes = level.getRecipeManager().getAllRecipesFor((RecipeType)HeatGeneratorRecipe.Type.INSTANCE);
        int productionSum = 0;
        block0: for (Direction direction : Direction.values()) {
            BlockPos checkPos = blockPos.relative(direction);
            FluidState fluidState = level.getFluidState(checkPos);
            for (RecipeHolder recipe : recipes) {
                for (Fluid fluid : ((HeatGeneratorRecipe)recipe.value()).getInput()) {
                    if (!fluidState.is(fluid)) continue;
                    productionSum += ((HeatGeneratorRecipe)recipe.value()).getEnergyProduction();
                    continue block0;
                }
            }
        }
        if (productionSum > 0) {
            productionSum = (int)((float)productionSum * ENERGY_PRODUCTION_MULTIPLIER);
            ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).setEnergy(Math.min(((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getCapacity(), ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() + productionSum));
        }
        HeatGeneratorBlockEntity.transferEnergy(level, blockPos, state, blockEntity);
    }

    private static void transferEnergy(Level level, BlockPos blockPos, BlockState state, HeatGeneratorBlockEntity blockEntity) {
        if (level.isClientSide) {
            return;
        }
        ArrayList<IEnergyStorage> consumerItems = new ArrayList<IEnergyStorage>();
        ArrayList<Integer> consumerEnergyValues = new ArrayList<Integer>();
        int consumptionSum = 0;
        for (Direction direction : Direction.values()) {
            int received;
            BlockPos testPos = blockPos.relative(direction);
            BlockEntity testBlockEntity = level.getBlockEntity(testPos);
            IEnergyStorage energyStorage = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, testPos, level.getBlockState(testPos), testBlockEntity, (Object)direction.getOpposite());
            if (energyStorage == null || !energyStorage.canReceive() || (received = energyStorage.receiveEnergy(Math.min(((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getMaxExtract(), ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getEnergy()), true)) <= 0) continue;
            consumptionSum += received;
            consumerItems.add(energyStorage);
            consumerEnergyValues.add(received);
        }
        ArrayList<Integer> consumerEnergyDistributed = new ArrayList<Integer>();
        for (int i = 0; i < consumerItems.size(); ++i) {
            consumerEnergyDistributed.add(0);
        }
        int consumptionLeft = Math.min(((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getMaxExtract(), Math.min(((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getEnergy(), consumptionSum));
        ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).extractEnergy(consumptionLeft, false);
        int divisor = consumerItems.size();
        block2: while (consumptionLeft > 0) {
            int consumptionPerConsumer = consumptionLeft / divisor;
            if (consumptionPerConsumer == 0) {
                divisor = Math.max(1, divisor - 1);
                consumptionPerConsumer = consumptionLeft / divisor;
            }
            for (int i = 0; i < consumerEnergyValues.size(); ++i) {
                int consumptionDistributed = (Integer)consumerEnergyDistributed.get(i);
                int consumptionOfConsumerLeft = (Integer)consumerEnergyValues.get(i) - consumptionDistributed;
                int consumptionDistributedNew = Math.min(consumptionOfConsumerLeft, Math.min(consumptionPerConsumer, consumptionLeft));
                consumerEnergyDistributed.set(i, consumptionDistributed + consumptionDistributedNew);
                if ((consumptionLeft -= consumptionDistributedNew) == 0) break block2;
            }
        }
        for (int i = 0; i < consumerItems.size(); ++i) {
            int energy = (Integer)consumerEnergyDistributed.get(i);
            if (energy <= 0) continue;
            ((IEnergyStorage)consumerItems.get(i)).receiveEnergy(energy, false);
        }
    }
}

