/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.FluidStorageMultiTankMethods;
import me.jddev0.ep.block.entity.base.SelectableRecipeFluidMachineBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.fluid.EPFluids;
import me.jddev0.ep.fluid.EnergizedPowerFluidStorage;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.item.EPItems;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.recipe.EPRecipes;
import me.jddev0.ep.recipe.FiltrationPlantRecipe;
import me.jddev0.ep.screen.FiltrationPlantMenu;
import me.jddev0.ep.util.InventoryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FiltrationPlantBlockEntity
extends SelectableRecipeFluidMachineBlockEntity<EnergizedPowerFluidStorage, RecipeInput, FiltrationPlantRecipe> {
    public static final int TANK_CAPACITY = 1000 * ModConfigs.COMMON_FILTRATION_PLANT_TANK_CAPACITY.getValue();
    public static final int DIRTY_WATER_CONSUMPTION_PER_RECIPE = ModConfigs.COMMON_FILTRATION_PLANT_DIRTY_WATER_USAGE_PER_RECIPE.getValue();
    private final IItemHandler itemHandlerSided;

    public FiltrationPlantBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(EPBlockEntities.FILTRATION_PLANT_ENTITY.get(), blockPos, blockState, "filtration_plant", FiltrationPlantMenu::new, 4, EPRecipes.FILTRATION_PLANT_TYPE.get(), EPRecipes.FILTRATION_PLANT_SERIALIZER.get(), (int)ModConfigs.COMMON_FILTRATION_PLANT_RECIPE_DURATION.getValue(), ModConfigs.COMMON_FILTRATION_PLANT_CAPACITY.getValue(), (int)ModConfigs.COMMON_FILTRATION_PLANT_TRANSFER_RATE.getValue(), ModConfigs.COMMON_FILTRATION_PLANT_CONSUMPTION_PER_TICK.getValue(), FluidStorageMultiTankMethods.INSTANCE, TANK_CAPACITY, UpgradeModuleModifier.SPEED, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY);
        this.itemHandlerSided = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0 || i == 1, i -> i == 2 || i == 3);
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                FiltrationPlantBlockEntity.this.setChanged();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return switch (slot) {
                    case 0, 1 -> stack.is((Item)EPItems.CHARCOAL_FILTER.get());
                    case 2, 3 -> false;
                    default -> super.isItemValid(slot, stack);
                };
            }
        };
    }

    @Override
    protected EnergizedPowerFluidStorage initFluidStorage() {
        return new EnergizedPowerFluidStorage(new int[]{this.baseTankCapacity, this.baseTankCapacity}){

            @Override
            protected void onContentsChanged() {
                FiltrationPlantBlockEntity.this.setChanged();
                FiltrationPlantBlockEntity.this.syncFluidToPlayers(32);
            }

            @Override
            public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
                if (!super.isFluidValid(tank, stack)) {
                    return false;
                }
                return switch (tank) {
                    case 0 -> FluidStack.isSameFluid((FluidStack)stack, (FluidStack)new FluidStack((Fluid)EPFluids.DIRTY_WATER.get(), 1));
                    case 1 -> FluidStack.isSameFluid((FluidStack)stack, (FluidStack)new FluidStack((Fluid)Fluids.WATER, 1));
                    default -> false;
                };
            }
        };
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        return this.itemHandlerSided;
    }

    @Nullable
    public IFluidHandler getFluidHandlerCapability(@Nullable Direction side) {
        return this.fluidStorage;
    }

    @Nullable
    public IEnergyStorage getEnergyStorageCapability(@Nullable Direction side) {
        return this.energyStorage;
    }

    @Override
    protected void craftItem(RecipeHolder<FiltrationPlantRecipe> recipe) {
        Level level;
        if (this.level == null || !this.hasRecipe() || !((level = this.level) instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ((EnergizedPowerFluidStorage)this.fluidStorage).drain(new FluidStack((Fluid)EPFluids.DIRTY_WATER.get(), DIRTY_WATER_CONSUMPTION_PER_RECIPE), IFluidHandler.FluidAction.EXECUTE);
        ((EnergizedPowerFluidStorage)this.fluidStorage).fill(new FluidStack((Fluid)Fluids.WATER, DIRTY_WATER_CONSUMPTION_PER_RECIPE), IFluidHandler.FluidAction.EXECUTE);
        for (int i = 0; i < 2; ++i) {
            ItemStack charcoalFilter = this.itemHandler.getStackInSlot(i).copy();
            if (charcoalFilter.isEmpty() && !charcoalFilter.is((Item)EPItems.CHARCOAL_FILTER.get())) continue;
            charcoalFilter.hurtAndBreak(1, serverLevel, null, item -> charcoalFilter.setCount(0));
            this.itemHandler.setStackInSlot(i, charcoalFilter);
        }
        ItemStack[] outputs = ((FiltrationPlantRecipe)recipe.value()).generateOutputs(this.level.random);
        if (!outputs[0].isEmpty()) {
            this.itemHandler.setStackInSlot(2, outputs[0].copyWithCount(this.itemHandler.getStackInSlot(2).getCount() + outputs[0].getCount()));
        }
        if (!outputs[1].isEmpty()) {
            this.itemHandler.setStackInSlot(3, outputs[1].copyWithCount(this.itemHandler.getStackInSlot(3).getCount() + outputs[1].getCount()));
        }
        this.resetProgress();
    }

    @Override
    protected boolean canCraftRecipe(SimpleContainer inventory, RecipeHolder<FiltrationPlantRecipe> recipe) {
        ItemStack[] maxOutputs = ((FiltrationPlantRecipe)recipe.value()).getMaxOutputCounts();
        return !(this.level == null || ((EnergizedPowerFluidStorage)this.fluidStorage).getFluid(0).getAmount() < DIRTY_WATER_CONSUMPTION_PER_RECIPE || ((EnergizedPowerFluidStorage)this.fluidStorage).getCapacity(1) - ((EnergizedPowerFluidStorage)this.fluidStorage).getFluid(1).getAmount() < DIRTY_WATER_CONSUMPTION_PER_RECIPE || !this.itemHandler.getStackInSlot(0).is((Item)EPItems.CHARCOAL_FILTER.get()) || !this.itemHandler.getStackInSlot(1).is((Item)EPItems.CHARCOAL_FILTER.get()) || !maxOutputs[0].isEmpty() && !InventoryUtils.canInsertItemIntoSlot((Container)inventory, 2, maxOutputs[0]) || !maxOutputs[1].isEmpty() && !InventoryUtils.canInsertItemIntoSlot((Container)inventory, 3, maxOutputs[1]));
    }
}

