/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.MenuEnergyStorageBlockEntity;
import me.jddev0.ep.energy.InfinityEnergyStorage;
import me.jddev0.ep.inventory.CombinedContainerData;
import me.jddev0.ep.inventory.data.BooleanValueContainerData;
import me.jddev0.ep.machine.CheckboxUpdate;
import me.jddev0.ep.screen.CreativeBatteryBoxMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreativeBatteryBoxBlockEntity
extends MenuEnergyStorageBlockEntity<InfinityEnergyStorage>
implements CheckboxUpdate {
    private boolean energyProduction = true;
    private boolean energyConsumption;

    public CreativeBatteryBoxBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(EPBlockEntities.CREATIVE_BATTERY_BOX_ENTITY.get(), blockPos, blockState, "creative_battery_box", Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    protected InfinityEnergyStorage initEnergyStorage() {
        return new InfinityEnergyStorage(){

            @Override
            public int extractEnergy(int maxExtract, boolean simulate) {
                return CreativeBatteryBoxBlockEntity.this.energyProduction ? super.extractEnergy(maxExtract, simulate) : 0;
            }

            @Override
            public int receiveEnergy(int maxReceive, boolean simulate) {
                return CreativeBatteryBoxBlockEntity.this.energyConsumption ? super.receiveEnergy(maxReceive, simulate) : 0;
            }

            @Override
            protected void onChange() {
                CreativeBatteryBoxBlockEntity.this.setChanged();
            }
        };
    }

    @Override
    protected ContainerData initContainerData() {
        return new CombinedContainerData(new BooleanValueContainerData(() -> this.energyProduction, value -> {
            this.energyProduction = value;
        }), new BooleanValueContainerData(() -> this.energyConsumption, value -> {
            this.energyConsumption = value;
        }));
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new CreativeBatteryBoxMenu(id, inventory, this, this.data);
    }

    @Nullable
    public IEnergyStorage getEnergyStorageCapability(@Nullable Direction side) {
        return this.energyStorage;
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.putBoolean("energy_production", this.energyProduction);
        nbt.putBoolean("energy_consumption", this.energyConsumption);
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.energyProduction = !nbt.contains("energy_production") || nbt.getBoolean("energy_production");
        this.energyConsumption = nbt.getBoolean("energy_consumption");
    }

    public void setEnergyProduction(boolean energyProduction) {
        this.energyProduction = energyProduction;
        CreativeBatteryBoxBlockEntity.setChanged((Level)this.level, (BlockPos)this.getBlockPos(), (BlockState)this.getBlockState());
    }

    public void setEnergyConsumption(boolean energyConsumption) {
        this.energyConsumption = energyConsumption;
        CreativeBatteryBoxBlockEntity.setChanged((Level)this.level, (BlockPos)this.getBlockPos(), (BlockState)this.getBlockState());
    }

    @Override
    public void setCheckbox(int checkboxId, boolean checked) {
        switch (checkboxId) {
            case 0: {
                this.setEnergyProduction(checked);
                break;
            }
            case 1: {
                this.setEnergyConsumption(checked);
            }
        }
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, CreativeBatteryBoxBlockEntity blockEntity) {
        if (level.isClientSide) {
            return;
        }
        CreativeBatteryBoxBlockEntity.transferInfiniteEnergy(level, blockPos, state, blockEntity);
    }

    private static void transferInfiniteEnergy(Level level, BlockPos blockPos, BlockState state, CreativeBatteryBoxBlockEntity blockEntity) {
        if (level.isClientSide) {
            return;
        }
        if (!blockEntity.energyProduction) {
            return;
        }
        for (Direction direction : Direction.values()) {
            BlockPos testPos = blockPos.relative(direction);
            BlockEntity testBlockEntity = level.getBlockEntity(testPos);
            IEnergyStorage energyStorage = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, testPos, level.getBlockState(testPos), testBlockEntity, (Object)direction.getOpposite());
            if (energyStorage == null || !energyStorage.canReceive()) continue;
            int received = energyStorage.receiveEnergy(energyStorage.getMaxEnergyStored(), true);
            energyStorage.receiveEnergy(received, false);
        }
    }
}

