/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.ArrayList;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.ConfigurableUpgradableInventoryEnergyStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.ExtractOnlyEnergyStorage;
import me.jddev0.ep.inventory.CombinedContainerData;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.inventory.data.BooleanValueContainerData;
import me.jddev0.ep.inventory.data.ComparatorModeValueContainerData;
import me.jddev0.ep.inventory.data.EnergyValueContainerData;
import me.jddev0.ep.inventory.data.ProgressValueContainerData;
import me.jddev0.ep.inventory.data.RedstoneModeValueContainerData;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.screen.CoalEngineMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoalEngineBlockEntity
extends ConfigurableUpgradableInventoryEnergyStorageBlockEntity<ExtractOnlyEnergyStorage, ItemStackHandler> {
    public static final float ENERGY_PRODUCTION_MULTIPLIER = ModConfigs.COMMON_COAL_ENGINE_ENERGY_PRODUCTION_MULTIPLIER.getValue().floatValue();
    private final IItemHandler itemHandlerSided;
    private int progress;
    private int maxProgress;
    private int energyProductionLeft;
    private boolean hasEnoughCapacityForProduction;
    private int timeoutOffState;

    public CoalEngineBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(EPBlockEntities.COAL_ENGINE_ENTITY.get(), blockPos, blockState, "coal_engine", ModConfigs.COMMON_COAL_ENGINE_CAPACITY.getValue(), ModConfigs.COMMON_COAL_ENGINE_TRANSFER_RATE.getValue(), 1, UpgradeModuleModifier.ENERGY_CAPACITY);
        this.itemHandlerSided = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> true, i -> {
            if (i != 0) {
                return false;
            }
            ItemStack item = this.itemHandler.getStackInSlot(i.intValue());
            return item.getBurnTime(null) <= 0;
        });
        this.energyProductionLeft = -1;
    }

    @Override
    protected ExtractOnlyEnergyStorage initEnergyStorage() {
        return new ExtractOnlyEnergyStorage(0, this.baseEnergyCapacity, this.baseEnergyTransferRate){

            @Override
            public int getCapacity() {
                return Math.max(1, (int)Math.ceil((double)this.capacity * CoalEngineBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CAPACITY)));
            }

            @Override
            public int getMaxExtract() {
                return Math.max(1, (int)Math.ceil((double)this.maxExtract * CoalEngineBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_TRANSFER_RATE)));
            }

            @Override
            protected void onChange() {
                CoalEngineBlockEntity.this.setChanged();
                CoalEngineBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                CoalEngineBlockEntity.this.setChanged();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                if (slot == 0) {
                    return stack.getBurnTime(null) > 0;
                }
                return super.isItemValid(slot, stack);
            }
        };
    }

    @Override
    protected ContainerData initContainerData() {
        return new CombinedContainerData(new ProgressValueContainerData(() -> this.progress, value -> {
            this.progress = value;
        }), new ProgressValueContainerData(() -> this.maxProgress, value -> {
            this.maxProgress = value;
        }), new EnergyValueContainerData(() -> this.maxProgress > 0 || CoalEngineBlockEntity.hasRecipe(this) ? this.getEnergyProductionPerTick() : -1, value -> {}), new EnergyValueContainerData(() -> this.energyProductionLeft, value -> {}), new BooleanValueContainerData(() -> this.hasEnoughCapacityForProduction, value -> {}), new RedstoneModeValueContainerData(() -> this.redstoneMode, value -> {
            this.redstoneMode = value;
        }), new ComparatorModeValueContainerData(() -> this.comparatorMode, value -> {
            this.comparatorMode = value;
        }));
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        this.syncEnergyToPlayer(player);
        return new CoalEngineMenu(id, inventory, this, this.upgradeModuleInventory, this.data);
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        return this.itemHandlerSided;
    }

    @Nullable
    public IEnergyStorage getEnergyStorageCapability(@Nullable Direction side) {
        return this.energyStorage;
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.put("recipe.progress", (Tag)IntTag.valueOf((int)this.progress));
        nbt.put("recipe.max_progress", (Tag)IntTag.valueOf((int)this.maxProgress));
        nbt.put("recipe.energy_production_left", (Tag)IntTag.valueOf((int)this.energyProductionLeft));
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.progress = nbt.getInt("recipe.progress");
        this.maxProgress = nbt.getInt("recipe.max_progress");
        this.energyProductionLeft = nbt.getInt("recipe.energy_production_left");
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, CoalEngineBlockEntity blockEntity) {
        if (level.isClientSide) {
            return;
        }
        if (blockEntity.redstoneMode.isActive((Boolean)state.getValue((Property)BlockStateProperties.POWERED))) {
            CoalEngineBlockEntity.tickRecipe(level, blockPos, state, blockEntity);
        }
        CoalEngineBlockEntity.transferEnergy(level, blockPos, state, blockEntity);
    }

    protected final int getEnergyProductionPerTick() {
        int energyProductionPerTick = (int)Math.ceil((float)this.energyProductionLeft / (float)(this.maxProgress - this.progress));
        if (this.progress == this.maxProgress - 1) {
            energyProductionPerTick = this.energyProductionLeft;
        }
        return energyProductionPerTick;
    }

    private static void tickRecipe(Level level, BlockPos blockPos, BlockState state, CoalEngineBlockEntity blockEntity) {
        if (level.isClientSide) {
            return;
        }
        if (blockEntity.timeoutOffState > 0) {
            --blockEntity.timeoutOffState;
            if (blockEntity.timeoutOffState == 0 && level.getBlockState(blockPos).hasProperty((Property)BlockStateProperties.LIT) && ((Boolean)level.getBlockState(blockPos).getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
                level.setBlock(blockPos, (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false)), 3);
            }
        }
        if (blockEntity.maxProgress > 0 || CoalEngineBlockEntity.hasRecipe(blockEntity)) {
            int energyProductionPerTick;
            SimpleContainer inventory = new SimpleContainer(blockEntity.itemHandler.getSlots());
            for (int i = 0; i < blockEntity.itemHandler.getSlots(); ++i) {
                inventory.setItem(i, blockEntity.itemHandler.getStackInSlot(i));
            }
            ItemStack item = inventory.getItem(0);
            int energyProduction = item.getBurnTime(null);
            energyProduction = (int)((float)energyProduction * ENERGY_PRODUCTION_MULTIPLIER);
            if (blockEntity.progress == 0) {
                blockEntity.energyProductionLeft = energyProduction;
            }
            if (blockEntity.maxProgress == 0) {
                blockEntity.maxProgress = energyProduction / 100 <= ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getMaxExtract() ? 100 : (int)Math.ceil((float)energyProduction / (float)((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getMaxExtract());
            }
            if ((energyProductionPerTick = blockEntity.getEnergyProductionPerTick()) <= ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getCapacity() - ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getEnergy()) {
                if (blockEntity.progress == 0) {
                    if (item.hasCraftingRemainingItem()) {
                        blockEntity.itemHandler.setStackInSlot(0, item.getCraftingRemainingItem());
                    } else {
                        blockEntity.itemHandler.extractItem(0, 1, false);
                    }
                }
                blockEntity.hasEnoughCapacityForProduction = true;
                blockEntity.timeoutOffState = 0;
                if (level.getBlockState(blockPos).hasProperty((Property)BlockStateProperties.LIT) && !((Boolean)level.getBlockState(blockPos).getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
                    level.setBlock(blockPos, (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true)), 3);
                }
                if (blockEntity.progress < 0 || blockEntity.maxProgress < 0 || blockEntity.energyProductionLeft < 0 || energyProductionPerTick < 0) {
                    blockEntity.resetProgress(blockPos, state);
                    CoalEngineBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
                    return;
                }
                ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).setEnergy(((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() + energyProductionPerTick);
                blockEntity.energyProductionLeft -= energyProductionPerTick;
                ++blockEntity.progress;
                if (blockEntity.progress >= blockEntity.maxProgress) {
                    blockEntity.resetProgress(blockPos, state);
                }
                CoalEngineBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
            } else {
                blockEntity.hasEnoughCapacityForProduction = false;
                if (blockEntity.timeoutOffState == 0) {
                    blockEntity.timeoutOffState = ModConfigs.COMMON_OFF_STATE_TIMEOUT.getValue();
                }
                CoalEngineBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
            }
        } else {
            blockEntity.resetProgress(blockPos, state);
            if (blockEntity.timeoutOffState == 0) {
                blockEntity.timeoutOffState = ModConfigs.COMMON_OFF_STATE_TIMEOUT.getValue();
            }
            CoalEngineBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
        }
    }

    private static void transferEnergy(Level level, BlockPos blockPos, BlockState state, CoalEngineBlockEntity blockEntity) {
        if (level.isClientSide) {
            return;
        }
        ArrayList<IEnergyStorage> consumerItems = new ArrayList<IEnergyStorage>();
        ArrayList<Integer> consumerEnergyValues = new ArrayList<Integer>();
        int consumptionSum = 0;
        for (Direction direction : Direction.values()) {
            int received;
            BlockPos testPos = blockPos.relative(direction);
            BlockEntity testBlockEntity = level.getBlockEntity(testPos);
            IEnergyStorage energyStorage = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, testPos, level.getBlockState(testPos), testBlockEntity, (Object)direction.getOpposite());
            if (energyStorage == null || !energyStorage.canReceive() || (received = energyStorage.receiveEnergy(Math.min(((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getMaxExtract(), ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getEnergy()), true)) <= 0) continue;
            consumptionSum += received;
            consumerItems.add(energyStorage);
            consumerEnergyValues.add(received);
        }
        ArrayList<Integer> consumerEnergyDistributed = new ArrayList<Integer>();
        for (int i = 0; i < consumerItems.size(); ++i) {
            consumerEnergyDistributed.add(0);
        }
        int consumptionLeft = Math.min(((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getMaxExtract(), Math.min(((ExtractOnlyEnergyStorage)blockEntity.energyStorage).getEnergy(), consumptionSum));
        ((ExtractOnlyEnergyStorage)blockEntity.energyStorage).extractEnergy(consumptionLeft, false);
        int divisor = consumerItems.size();
        block2: while (consumptionLeft > 0) {
            int consumptionPerConsumer = consumptionLeft / divisor;
            if (consumptionPerConsumer == 0) {
                divisor = Math.max(1, divisor - 1);
                consumptionPerConsumer = consumptionLeft / divisor;
            }
            for (int i = 0; i < consumerEnergyValues.size(); ++i) {
                int consumptionDistributed = (Integer)consumerEnergyDistributed.get(i);
                int consumptionOfConsumerLeft = (Integer)consumerEnergyValues.get(i) - consumptionDistributed;
                int consumptionDistributedNew = Math.min(consumptionOfConsumerLeft, Math.min(consumptionPerConsumer, consumptionLeft));
                consumerEnergyDistributed.set(i, consumptionDistributed + consumptionDistributedNew);
                if ((consumptionLeft -= consumptionDistributedNew) == 0) break block2;
            }
        }
        for (int i = 0; i < consumerItems.size(); ++i) {
            int energy = (Integer)consumerEnergyDistributed.get(i);
            if (energy <= 0) continue;
            ((IEnergyStorage)consumerItems.get(i)).receiveEnergy(energy, false);
        }
    }

    private void resetProgress(BlockPos blockPos, BlockState state) {
        this.progress = 0;
        this.maxProgress = 0;
        this.energyProductionLeft = -1;
        this.hasEnoughCapacityForProduction = false;
    }

    private static boolean hasRecipe(CoalEngineBlockEntity blockEntity) {
        SimpleContainer inventory = new SimpleContainer(blockEntity.itemHandler.getSlots());
        for (int i = 0; i < blockEntity.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, blockEntity.itemHandler.getStackInSlot(i));
        }
        ItemStack item = inventory.getItem(0);
        if (item.getBurnTime(null) <= 0) {
            return false;
        }
        return !item.hasCraftingRemainingItem() || item.getCount() == 1;
    }
}

