/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.List;
import me.jddev0.ep.block.ChargingStationBlock;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.UpgradableEnergyStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.ReceiveOnlyEnergyStorage;
import me.jddev0.ep.integration.curios.CuriosCompatUtils;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.screen.ChargingStationMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class ChargingStationBlockEntity
extends UpgradableEnergyStorageBlockEntity<ReceiveOnlyEnergyStorage> {
    public static final int MAX_CHARGING_DISTANCE = ModConfigs.COMMON_CHARGING_STATION_MAX_CHARGING_DISTANCE.getValue();

    public ChargingStationBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(EPBlockEntities.CHARGING_STATION_ENTITY.get(), blockPos, blockState, "charging_station", ModConfigs.COMMON_CHARGING_STATION_CAPACITY.getValue(), ModConfigs.COMMON_CHARGING_STATION_TRANSFER_RATE.getValue(), UpgradeModuleModifier.ENERGY_CAPACITY, UpgradeModuleModifier.RANGE);
    }

    @Override
    protected ReceiveOnlyEnergyStorage initEnergyStorage() {
        return new ReceiveOnlyEnergyStorage(0, this.baseEnergyCapacity, this.baseEnergyTransferRate){

            @Override
            public int getCapacity() {
                return Math.max(1, (int)Math.ceil((double)this.capacity * ChargingStationBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CAPACITY)));
            }

            @Override
            public int getMaxReceive() {
                return Math.max(1, (int)Math.ceil((double)this.maxReceive * ChargingStationBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_TRANSFER_RATE)));
            }

            @Override
            protected void onChange() {
                ChargingStationBlockEntity.this.setChanged();
                ChargingStationBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        this.syncEnergyToPlayer(player);
        return new ChargingStationMenu(id, inventory, this, this.upgradeModuleInventory);
    }

    @Nullable
    public IEnergyStorage getEnergyStorageCapability(@Nullable Direction side) {
        return this.energyStorage;
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, ChargingStationBlockEntity blockEntity) {
        int energyPerTick;
        if (level.isClientSide) {
            return;
        }
        int maxChargingDistance = (int)Math.ceil((double)MAX_CHARGING_DISTANCE * blockEntity.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.RANGE));
        List players = level.getEntities(EntityTypeTest.forClass(Player.class), AABB.of((BoundingBox)BoundingBox.fromCorners((Vec3i)new Vec3i(blockPos.getX() - maxChargingDistance, blockPos.getY() - maxChargingDistance, blockPos.getZ() - maxChargingDistance), (Vec3i)new Vec3i(blockPos.getX() + maxChargingDistance, blockPos.getY() + maxChargingDistance, blockPos.getZ() + maxChargingDistance))), EntitySelector.NO_SPECTATORS.and(entity -> entity.distanceToSqr(blockPos.getCenter()) <= (double)(maxChargingDistance * maxChargingDistance)));
        int energyPerTickLeft = energyPerTick = Math.min(((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getMaxReceive(), ((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy());
        block0: for (Player player : players) {
            if (player.isDeadOrDying()) continue;
            Inventory inventory = player.getInventory();
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                ItemStack itemStack = inventory.getItem(i);
                IEnergyStorage energyStorage = (IEnergyStorage)itemStack.getCapability(Capabilities.EnergyStorage.ITEM);
                if (energyStorage != null && energyStorage.canReceive() && (energyPerTickLeft -= energyStorage.receiveEnergy(energyPerTickLeft, false)) == 0) break block0;
            }
            List<ItemStack> curiosItemStacks = CuriosCompatUtils.getCuriosItemStacks(inventory);
            for (ItemStack itemStack : curiosItemStacks) {
                IEnergyStorage energyStorage = (IEnergyStorage)itemStack.getCapability(Capabilities.EnergyStorage.ITEM);
                if (energyStorage == null || !energyStorage.canReceive() || (energyPerTickLeft -= energyStorage.receiveEnergy(energyPerTickLeft, false)) != 0) continue;
                break block0;
            }
        }
        if (energyPerTickLeft == energyPerTick) {
            if (!level.getBlockState(blockPos).hasProperty((Property)ChargingStationBlock.CHARGING) || ((Boolean)level.getBlockState(blockPos).getValue((Property)ChargingStationBlock.CHARGING)).booleanValue()) {
                level.setBlock(blockPos, (BlockState)state.setValue((Property)ChargingStationBlock.CHARGING, (Comparable)Boolean.valueOf(false)), 3);
            }
        } else {
            if (!level.getBlockState(blockPos).hasProperty((Property)ChargingStationBlock.CHARGING) || !((Boolean)level.getBlockState(blockPos).getValue((Property)ChargingStationBlock.CHARGING)).booleanValue()) {
                level.setBlock(blockPos, (BlockState)state.setValue((Property)ChargingStationBlock.CHARGING, (Comparable)Boolean.TRUE), 3);
            }
            ((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).setEnergy(((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() - energyPerTick + energyPerTickLeft);
        }
    }
}

