/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.List;
import java.util.Optional;
import me.jddev0.ep.block.BlockPlacerBlock;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.NoWorkData;
import me.jddev0.ep.block.entity.base.WorkerMachineBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.inventory.CombinedContainerData;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.inventory.data.BooleanValueContainerData;
import me.jddev0.ep.inventory.data.ComparatorModeValueContainerData;
import me.jddev0.ep.inventory.data.EnergyValueContainerData;
import me.jddev0.ep.inventory.data.ProgressValueContainerData;
import me.jddev0.ep.inventory.data.RedstoneModeValueContainerData;
import me.jddev0.ep.machine.CheckboxUpdate;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.screen.BlockPlacerMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockPlacerBlockEntity
extends WorkerMachineBlockEntity<NoWorkData>
implements CheckboxUpdate {
    private static final List<@NotNull ResourceLocation> PLACEMENT_BLACKLIST = ModConfigs.COMMON_BLOCK_PLACER_PLACEMENT_BLACKLIST.getValue();
    private final IItemHandler itemHandlerSided;
    private boolean inverseRotation;

    public BlockPlacerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(EPBlockEntities.BLOCK_PLACER_ENTITY.get(), blockPos, blockState, "block_placer", 1, (int)ModConfigs.COMMON_BLOCK_PLACER_PLACEMENT_DURATION.getValue(), (int)ModConfigs.COMMON_BLOCK_PLACER_CAPACITY.getValue(), ModConfigs.COMMON_BLOCK_PLACER_TRANSFER_RATE.getValue(), ModConfigs.COMMON_BLOCK_PLACER_ENERGY_CONSUMPTION_PER_TICK.getValue(), UpgradeModuleModifier.SPEED, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY);
        this.itemHandlerSided = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> true, i -> false);
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                BlockPlacerBlockEntity.this.setChanged();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                if (slot == 0) {
                    return stack.getItem() instanceof BlockItem;
                }
                return super.isItemValid(slot, stack);
            }

            public void setStackInSlot(int slot, @NotNull ItemStack stack) {
                if (slot == 0) {
                    ItemStack itemStack = this.getStackInSlot(slot);
                    if (!(BlockPlacerBlockEntity.this.level == null || stack.isEmpty() || itemStack.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemStack))) {
                        BlockPlacerBlockEntity.this.resetProgress();
                    }
                }
                super.setStackInSlot(slot, stack);
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }

    @Override
    protected ContainerData initContainerData() {
        return new CombinedContainerData(new ProgressValueContainerData(() -> this.progress, value -> {
            this.progress = value;
        }), new ProgressValueContainerData(() -> this.maxProgress, value -> {
            this.maxProgress = value;
        }), new EnergyValueContainerData(() -> this.hasWork() ? this.getCurrentWorkData().map(x$0 -> this.getEnergyConsumptionFor(x$0)).orElse(-1) : -1, value -> {}), new EnergyValueContainerData(() -> this.energyConsumptionLeft, value -> {}), new BooleanValueContainerData(() -> this.hasEnoughEnergy, value -> {}), new BooleanValueContainerData(() -> this.inverseRotation, value -> {}), new RedstoneModeValueContainerData(() -> this.redstoneMode, value -> {
            this.redstoneMode = value;
        }), new ComparatorModeValueContainerData(() -> this.comparatorMode, value -> {
            this.comparatorMode = value;
        }));
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        this.syncEnergyToPlayer(player);
        return new BlockPlacerMenu(id, inventory, this, this.upgradeModuleInventory, this.data);
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        return this.itemHandlerSided;
    }

    @Nullable
    public IEnergyStorage getEnergyStorageCapability(@Nullable Direction side) {
        return this.energyStorage;
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.putBoolean("inverse_rotation", this.inverseRotation);
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.inverseRotation = nbt.getBoolean("inverse_rotation");
    }

    @Override
    protected boolean hasWork() {
        Item item;
        ItemStack itemStack = this.itemHandler.getStackInSlot(0);
        if (itemStack.isEmpty() || !((item = itemStack.getItem()) instanceof BlockItem)) {
            return false;
        }
        BlockItem blockItemStack = (BlockItem)item;
        return !PLACEMENT_BLACKLIST.contains(BuiltInRegistries.BLOCK.getKey((Object)blockItemStack.getBlock()));
    }

    @Override
    protected Optional<NoWorkData> getCurrentWorkData() {
        return Optional.of(NoWorkData.INSTANCE);
    }

    @Override
    protected void onWorkStarted(NoWorkData workData) {
    }

    @Override
    protected void onWorkCompleted(NoWorkData workData) {
        Direction direction;
        int energyConsumptionPerTick = this.getEnergyConsumptionFor(workData);
        ItemStack itemStack = this.itemHandler.getStackInSlot(0);
        if (itemStack.isEmpty()) {
            this.energyConsumptionLeft = energyConsumptionPerTick;
            this.setChanged();
            return;
        }
        BlockPos blockPosPlacement = this.getBlockPos().relative((Direction)this.getBlockState().getValue((Property)BlockPlacerBlock.FACING));
        BlockItem blockItem = (BlockItem)itemStack.getItem();
        if (this.inverseRotation) {
            direction = switch ((Direction)this.getBlockState().getValue((Property)BlockPlacerBlock.FACING)) {
                default -> throw new MatchException(null, null);
                case Direction.DOWN -> Direction.UP;
                case Direction.UP -> Direction.DOWN;
                case Direction.NORTH -> Direction.SOUTH;
                case Direction.SOUTH -> Direction.NORTH;
                case Direction.WEST -> Direction.EAST;
                case Direction.EAST -> Direction.WEST;
            };
        } else {
            direction = (Direction)this.getBlockState().getValue((Property)BlockPlacerBlock.FACING);
        }
        InteractionResult result = blockItem.place((BlockPlaceContext)new DirectionalPlaceContext(this, this.level, blockPosPlacement, direction, itemStack, direction){

            @NotNull
            public Direction getNearestLookingDirection() {
                return direction;
            }

            @NotNull
            public @NotNull Direction @NotNull [] getNearestLookingDirections() {
                Direction[] directionArray;
                switch (direction) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case DOWN: {
                        Direction[] directionArray2 = new Direction[6];
                        directionArray2[0] = Direction.DOWN;
                        directionArray2[1] = Direction.NORTH;
                        directionArray2[2] = Direction.EAST;
                        directionArray2[3] = Direction.SOUTH;
                        directionArray2[4] = Direction.WEST;
                        directionArray = directionArray2;
                        directionArray2[5] = Direction.UP;
                        break;
                    }
                    case UP: {
                        Direction[] directionArray3 = new Direction[6];
                        directionArray3[0] = Direction.UP;
                        directionArray3[1] = Direction.DOWN;
                        directionArray3[2] = Direction.NORTH;
                        directionArray3[3] = Direction.EAST;
                        directionArray3[4] = Direction.SOUTH;
                        directionArray = directionArray3;
                        directionArray3[5] = Direction.WEST;
                        break;
                    }
                    case NORTH: {
                        Direction[] directionArray4 = new Direction[6];
                        directionArray4[0] = Direction.NORTH;
                        directionArray4[1] = Direction.EAST;
                        directionArray4[2] = Direction.WEST;
                        directionArray4[3] = Direction.UP;
                        directionArray4[4] = Direction.DOWN;
                        directionArray = directionArray4;
                        directionArray4[5] = Direction.SOUTH;
                        break;
                    }
                    case SOUTH: {
                        Direction[] directionArray5 = new Direction[6];
                        directionArray5[0] = Direction.SOUTH;
                        directionArray5[1] = Direction.EAST;
                        directionArray5[2] = Direction.WEST;
                        directionArray5[3] = Direction.UP;
                        directionArray5[4] = Direction.DOWN;
                        directionArray = directionArray5;
                        directionArray5[5] = Direction.NORTH;
                        break;
                    }
                    case WEST: {
                        Direction[] directionArray6 = new Direction[6];
                        directionArray6[0] = Direction.WEST;
                        directionArray6[1] = Direction.SOUTH;
                        directionArray6[2] = Direction.UP;
                        directionArray6[3] = Direction.DOWN;
                        directionArray6[4] = Direction.NORTH;
                        directionArray = directionArray6;
                        directionArray6[5] = Direction.EAST;
                        break;
                    }
                    case EAST: {
                        Direction[] directionArray7 = new Direction[6];
                        directionArray7[0] = Direction.EAST;
                        directionArray7[1] = Direction.SOUTH;
                        directionArray7[2] = Direction.UP;
                        directionArray7[3] = Direction.DOWN;
                        directionArray7[4] = Direction.NORTH;
                        directionArray = directionArray7;
                        directionArray7[5] = Direction.WEST;
                    }
                }
                return directionArray;
            }

            public boolean replacingClickedOnBlock() {
                return false;
            }
        });
        if (result == InteractionResult.FAIL) {
            this.energyConsumptionLeft = energyConsumptionPerTick;
            this.setChanged();
            return;
        }
        this.itemHandler.setStackInSlot(0, itemStack);
        this.resetProgress();
    }

    public void setInverseRotation(boolean inverseRotation) {
        this.inverseRotation = inverseRotation;
        BlockPlacerBlockEntity.setChanged((Level)this.level, (BlockPos)this.getBlockPos(), (BlockState)this.getBlockState());
    }

    @Override
    public void setCheckbox(int checkboxId, boolean checked) {
        switch (checkboxId) {
            case 0: {
                this.setInverseRotation(checked);
            }
        }
    }
}

