/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.SelectableRecipeMachineBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.screen.AutoStonecutterMenu;
import me.jddev0.ep.util.InventoryUtils;
import me.jddev0.ep.util.RecipeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoStonecutterBlockEntity
extends SelectableRecipeMachineBlockEntity<SingleRecipeInput, StonecutterRecipe> {
    private final IItemHandler itemHandlerSided;

    public AutoStonecutterBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(EPBlockEntities.AUTO_STONECUTTER_ENTITY.get(), blockPos, blockState, "auto_stonecutter", AutoStonecutterMenu::new, 3, RecipeType.STONECUTTING, RecipeSerializer.STONECUTTER, (int)ModConfigs.COMMON_AUTO_STONECUTTER_RECIPE_DURATION.getValue(), ModConfigs.COMMON_AUTO_STONECUTTER_CAPACITY.getValue(), ModConfigs.COMMON_AUTO_STONECUTTER_TRANSFER_RATE.getValue(), ModConfigs.COMMON_AUTO_STONECUTTER_ENERGY_CONSUMPTION_PER_TICK.getValue(), UpgradeModuleModifier.SPEED, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY);
        this.itemHandlerSided = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0 || i == 1, i -> i == 2);
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                AutoStonecutterBlockEntity.this.setChanged();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return switch (slot) {
                    case 0 -> {
                        if (AutoStonecutterBlockEntity.this.level == null || RecipeUtils.isIngredientOfAny(AutoStonecutterBlockEntity.this.level, AutoStonecutterBlockEntity.this.recipeType, stack)) {
                            yield true;
                        }
                        yield false;
                    }
                    case 1 -> stack.is(ItemTags.PICKAXES);
                    case 2 -> false;
                    default -> super.isItemValid(slot, stack);
                };
            }
        };
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        return this.itemHandlerSided;
    }

    @Nullable
    public IEnergyStorage getEnergyStorageCapability(@Nullable Direction side) {
        return this.energyStorage;
    }

    @Override
    protected void craftItem(RecipeHolder<StonecutterRecipe> recipe) {
        Level level;
        if (this.level == null || !this.hasRecipe() || !((level = this.level) instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ItemStack pickaxe = this.itemHandler.getStackInSlot(1).copy();
        if (pickaxe.isEmpty() && !pickaxe.is(ItemTags.PICKAXES)) {
            return;
        }
        pickaxe.hurtAndBreak(1, serverLevel, null, item -> pickaxe.setCount(0));
        this.itemHandler.setStackInSlot(1, pickaxe);
        this.itemHandler.extractItem(0, 1, false);
        this.itemHandler.setStackInSlot(2, ((StonecutterRecipe)recipe.value()).getResultItem((HolderLookup.Provider)this.level.registryAccess()).copyWithCount(this.itemHandler.getStackInSlot(2).getCount() + ((StonecutterRecipe)recipe.value()).getResultItem((HolderLookup.Provider)this.level.registryAccess()).getCount()));
        this.resetProgress();
    }

    @Override
    protected boolean canCraftRecipe(SimpleContainer inventory, RecipeHolder<StonecutterRecipe> recipe) {
        return this.level != null && ((StonecutterRecipe)recipe.value()).matches(new SingleRecipeInput(inventory.getItem(0)), this.level) && this.itemHandler.getStackInSlot(1).is(ItemTags.PICKAXES) && InventoryUtils.canInsertItemIntoSlot((Container)inventory, 2, ((StonecutterRecipe)recipe.value()).getResultItem((HolderLookup.Provider)this.level.registryAccess()));
    }
}

