/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.Arrays;
import me.jddev0.ep.block.AssemblingMachineBlock;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.SimpleRecipeMachineBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.recipe.AssemblingMachineRecipe;
import me.jddev0.ep.recipe.ContainerRecipeInputWrapper;
import me.jddev0.ep.recipe.EPRecipes;
import me.jddev0.ep.recipe.IngredientWithCount;
import me.jddev0.ep.screen.AssemblingMachineMenu;
import me.jddev0.ep.util.InventoryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssemblingMachineBlockEntity
extends SimpleRecipeMachineBlockEntity<RecipeInput, AssemblingMachineRecipe> {
    private final IItemHandler itemHandlerSidedTopBottom;
    private final IItemHandler itemHandlerSidedFront;
    private final IItemHandler itemHandlerSidedBack;
    private final IItemHandler itemHandlerSidedLeft;
    private final IItemHandler itemHandlerSidedRight;

    public AssemblingMachineBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(EPBlockEntities.ASSEMBLING_MACHINE_ENTITY.get(), blockPos, blockState, "assembling_machine", AssemblingMachineMenu::new, 5, EPRecipes.ASSEMBLING_MACHINE_TYPE.get(), (int)ModConfigs.COMMON_ASSEMBLING_MACHINE_RECIPE_DURATION.getValue(), (int)ModConfigs.COMMON_ASSEMBLING_MACHINE_CAPACITY.getValue(), ModConfigs.COMMON_ASSEMBLING_MACHINE_TRANSFER_RATE.getValue(), ModConfigs.COMMON_ASSEMBLING_MACHINE_ENERGY_CONSUMPTION_PER_TICK.getValue(), UpgradeModuleModifier.SPEED, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY);
        this.itemHandlerSidedTopBottom = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i >= 0 && i < 4, i -> i == 4);
        this.itemHandlerSidedFront = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 3, i -> i == 4);
        this.itemHandlerSidedBack = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0, i -> i == 4);
        this.itemHandlerSidedLeft = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 1, i -> i == 4);
        this.itemHandlerSidedRight = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 2, i -> i == 4);
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return switch (slot) {
                    case 0, 1, 2, 3 -> {
                        if (AssemblingMachineBlockEntity.this.level == null || AssemblingMachineBlockEntity.this.level.getRecipeManager().getAllRecipesFor((RecipeType)AssemblingMachineRecipe.Type.INSTANCE).stream().map(RecipeHolder::value).map(AssemblingMachineRecipe::getInputs).anyMatch(inputs -> Arrays.stream(inputs).map(IngredientWithCount::input).anyMatch(ingredient -> ingredient.test(stack)))) {
                            yield true;
                        }
                        yield false;
                    }
                    case 4 -> false;
                    default -> false;
                };
            }

            public void setStackInSlot(int slot, @NotNull ItemStack stack) {
                if (slot >= 0 && slot < 4) {
                    ItemStack itemStack = this.getStackInSlot(slot);
                    if (!(AssemblingMachineBlockEntity.this.level == null || stack.isEmpty() || itemStack.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemStack))) {
                        AssemblingMachineBlockEntity.this.resetProgress();
                    }
                }
                super.setStackInSlot(slot, stack);
            }

            protected void onContentsChanged(int slot) {
                AssemblingMachineBlockEntity.this.setChanged();
            }
        };
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        Direction facing = (Direction)this.getBlockState().getValue((Property)AssemblingMachineBlock.FACING);
        if (facing == side) {
            return this.itemHandlerSidedFront;
        }
        if (facing.getOpposite() == side) {
            return this.itemHandlerSidedBack;
        }
        if (facing.getClockWise() == side) {
            return this.itemHandlerSidedLeft;
        }
        if (facing.getCounterClockWise() == side) {
            return this.itemHandlerSidedRight;
        }
        return this.itemHandlerSidedTopBottom;
    }

    @Nullable
    public IEnergyStorage getEnergyStorageCapability(@Nullable Direction side) {
        return this.energyStorage;
    }

    @Override
    protected RecipeInput getRecipeInput(Container inventory) {
        return new ContainerRecipeInputWrapper(inventory);
    }

    @Override
    protected void craftItem(RecipeHolder<AssemblingMachineRecipe> recipe) {
        if (this.level == null || !this.hasRecipe()) {
            return;
        }
        IngredientWithCount[] inputs = ((AssemblingMachineRecipe)recipe.value()).getInputs();
        boolean[] usedIndices = new boolean[4];
        for (int i = 0; i < 4; ++i) {
            usedIndices[i] = this.itemHandler.getStackInSlot(i).isEmpty();
        }
        int len = Math.min(inputs.length, 4);
        for (int i = 0; i < len; ++i) {
            IngredientWithCount input = inputs[i];
            int indexMinCount = -1;
            int minCount = Integer.MAX_VALUE;
            for (int j = 0; j < 4; ++j) {
                if (usedIndices[j]) continue;
                ItemStack item = this.itemHandler.getStackInSlot(j);
                if (indexMinCount != -1 && item.getCount() >= minCount || !input.input().test(item) || item.getCount() < input.count()) continue;
                indexMinCount = j;
                minCount = item.getCount();
            }
            if (indexMinCount == -1) {
                return;
            }
            usedIndices[indexMinCount] = true;
            this.itemHandler.extractItem(indexMinCount, input.count(), false);
        }
        this.itemHandler.setStackInSlot(4, ((AssemblingMachineRecipe)recipe.value()).getResultItem((HolderLookup.Provider)this.level.registryAccess()).copyWithCount(this.itemHandler.getStackInSlot(4).getCount() + ((AssemblingMachineRecipe)recipe.value()).getResultItem((HolderLookup.Provider)this.level.registryAccess()).getCount()));
        this.resetProgress();
    }

    @Override
    protected boolean canCraftRecipe(SimpleContainer inventory, RecipeHolder<AssemblingMachineRecipe> recipe) {
        return this.level != null && InventoryUtils.canInsertItemIntoSlot((Container)inventory, 4, ((AssemblingMachineRecipe)recipe.value()).getResultItem((HolderLookup.Provider)this.level.registryAccess()));
    }
}

