/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.Optional;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.FluidStorageMultiTankMethods;
import me.jddev0.ep.block.entity.base.WorkerFluidMachineBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.fluid.EnergizedPowerFluidStorage;
import me.jddev0.ep.inventory.CombinedContainerData;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.inventory.data.BooleanValueContainerData;
import me.jddev0.ep.inventory.data.ComparatorModeValueContainerData;
import me.jddev0.ep.inventory.data.EnergyValueContainerData;
import me.jddev0.ep.inventory.data.IntegerValueContainerData;
import me.jddev0.ep.inventory.data.ProgressValueContainerData;
import me.jddev0.ep.inventory.data.RedstoneModeValueContainerData;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.screen.AdvancedFluidPumpMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdvancedFluidPumpBlockEntity
extends WorkerFluidMachineBlockEntity<EnergizedPowerFluidStorage, BlockPos> {
    public static final int NEXT_BLOCK_COOLDOWN = ModConfigs.COMMON_ADVANCED_FLUID_PUMP_NEXT_BLOCK_COOLDOWN.getValue();
    public static final int EXTRACTION_DURATION = ModConfigs.COMMON_ADVANCED_FLUID_PUMP_EXTRACTION_DURATION.getValue();
    public static final int RANGE = ModConfigs.COMMON_ADVANCED_FLUID_PUMP_EXTRACTION_RANGE.getValue();
    public static final int DEPTH = ModConfigs.COMMON_ADVANCED_FLUID_PUMP_EXTRACTION_DEPTH.getValue();
    private int xOffset = -1;
    private int yOffset = 0;
    private int zOffset = -1;
    private boolean extractingFluid = false;
    private final IItemHandler itemHandlerSided = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> true, i -> false);

    public AdvancedFluidPumpBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(EPBlockEntities.ADVANCED_FLUID_PUMP_ENTITY.get(), blockPos, blockState, "advanced_fluid_pump", 1, 1, (int)ModConfigs.COMMON_ADVANCED_FLUID_PUMP_CAPACITY.getValue(), ModConfigs.COMMON_ADVANCED_FLUID_PUMP_TRANSFER_RATE.getValue(), (int)ModConfigs.COMMON_ADVANCED_FLUID_PUMP_CONSUMPTION_PER_TICK.getValue(), FluidStorageMultiTankMethods.INSTANCE, ModConfigs.COMMON_ADVANCED_FLUID_PUMP_FLUID_TANK_CAPACITY.getValue() * 1000, UpgradeModuleModifier.SPEED, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY, UpgradeModuleModifier.EXTRACTION_RANGE, UpgradeModuleModifier.EXTRACTION_DEPTH);
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                AdvancedFluidPumpBlockEntity.this.setChanged();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                if (slot == 0) {
                    return stack.is(Items.COBBLESTONE);
                }
                return super.isItemValid(slot, stack);
            }

            public void setStackInSlot(int slot, @NotNull ItemStack stack) {
                if (slot == 0) {
                    ItemStack itemStack = this.getStackInSlot(slot);
                    if (!(AdvancedFluidPumpBlockEntity.this.level == null || stack.isEmpty() || itemStack.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemStack))) {
                        AdvancedFluidPumpBlockEntity.this.resetProgress();
                    }
                }
                super.setStackInSlot(slot, stack);
            }
        };
    }

    @Override
    protected EnergizedPowerFluidStorage initFluidStorage() {
        return new EnergizedPowerFluidStorage(new int[]{this.baseTankCapacity, this.baseTankCapacity, this.baseTankCapacity, this.baseTankCapacity}){

            @Override
            protected void onContentsChanged() {
                AdvancedFluidPumpBlockEntity.this.setChanged();
                AdvancedFluidPumpBlockEntity.this.syncFluidToPlayers(32);
            }
        };
    }

    @Override
    protected ContainerData initContainerData() {
        return new CombinedContainerData(new ProgressValueContainerData(() -> this.progress, value -> {
            this.progress = value;
        }), new ProgressValueContainerData(() -> this.maxProgress, value -> {
            this.maxProgress = value;
        }), new EnergyValueContainerData(() -> this.hasWork() ? this.getCurrentWorkData().map(x$0 -> this.getEnergyConsumptionFor(x$0)).orElse(-1) : -1, value -> {}), new EnergyValueContainerData(() -> this.energyConsumptionLeft, value -> {}), new BooleanValueContainerData(() -> this.hasEnoughEnergy, value -> {}), new IntegerValueContainerData(() -> this.xOffset, value -> {}), new IntegerValueContainerData(() -> this.yOffset, value -> {}), new IntegerValueContainerData(() -> this.zOffset, value -> {}), new BooleanValueContainerData(() -> this.extractingFluid, value -> {}), new RedstoneModeValueContainerData(() -> this.redstoneMode, value -> {
            this.redstoneMode = value;
        }), new ComparatorModeValueContainerData(() -> this.comparatorMode, value -> {
            this.comparatorMode = value;
        }));
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        this.syncEnergyToPlayer(player);
        this.syncFluidToPlayer(player);
        return new AdvancedFluidPumpMenu(id, inventory, this, this.upgradeModuleInventory, this.data);
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        return this.itemHandlerSided;
    }

    @Nullable
    public IFluidHandler getFluidHandlerCapability(@Nullable Direction side) {
        return this.fluidStorage;
    }

    @Nullable
    public IEnergyStorage getEnergyStorageCapability(@Nullable Direction side) {
        return this.energyStorage;
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.putInt("target.xOffset", this.xOffset);
        nbt.putInt("target.yOffset", this.yOffset);
        nbt.putInt("target.zOffset", this.zOffset);
        nbt.putBoolean("recipe.extractingFluid", this.extractingFluid);
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.xOffset = nbt.getInt("target.xOffset");
        this.yOffset = nbt.getInt("target.yOffset");
        this.zOffset = nbt.getInt("target.zOffset");
        this.extractingFluid = nbt.getBoolean("recipe.extractingFluid");
    }

    @Override
    protected void onTickStart() {
        super.onTickStart();
        if (this.yOffset == 0) {
            this.goToNextOffset();
            this.setChanged();
        }
    }

    @Override
    protected boolean hasWork() {
        return this.yOffset != 0 && this.itemHandler.getStackInSlot(0).is(Items.COBBLESTONE);
    }

    @Override
    protected Optional<BlockPos> getCurrentWorkData() {
        return Optional.of(this.worldPosition.offset(this.xOffset, this.yOffset, this.zOffset));
    }

    @Override
    protected double getWorkDataDependentWorkDuration(BlockPos targetPos) {
        return this.extractingFluid ? (double)EXTRACTION_DURATION : (double)NEXT_BLOCK_COOLDOWN;
    }

    @Override
    protected void onWorkStarted(BlockPos targetPos) {
        BlockState targetState = this.level.getBlockState(targetPos);
        if (!(targetState.getBlock() instanceof BucketPickup)) {
            return;
        }
        FluidState targetFluidState = this.level.getFluidState(targetPos);
        if (targetFluidState.isEmpty()) {
            return;
        }
        if (((EnergizedPowerFluidStorage)this.fluidStorage).fill(new FluidStack(targetFluidState.getType(), 1000), IFluidHandler.FluidAction.SIMULATE) != 1000) {
            return;
        }
        this.extractingFluid = true;
    }

    @Override
    protected void onWorkCompleted(BlockPos targetPos) {
        BucketPickup targetBlock;
        ItemStack bucketItemStack;
        Block block;
        BlockState targetState = this.level.getBlockState(targetPos);
        if (this.extractingFluid && (block = targetState.getBlock()) instanceof BucketPickup && !(bucketItemStack = (targetBlock = (BucketPickup)block).pickupBlock(null, (LevelAccessor)this.level, targetPos, targetState)).isEmpty()) {
            FluidStack fluidStack;
            this.level.gameEvent(null, (Holder)GameEvent.FLUID_PICKUP, targetPos);
            IFluidHandlerItem fluidStorage = (IFluidHandlerItem)bucketItemStack.getCapability(Capabilities.FluidHandler.ITEM);
            if (fluidStorage != null && fluidStorage.getTanks() == 1 && !(fluidStack = fluidStorage.getFluidInTank(0)).isEmpty()) {
                ((EnergizedPowerFluidStorage)this.fluidStorage).fill(fluidStack.copy(), IFluidHandler.FluidAction.EXECUTE);
                BlockState newTargetState = this.level.getBlockState(targetPos);
                if (newTargetState.isAir() || newTargetState.canBeReplaced()) {
                    this.itemHandler.extractItem(0, 1, false);
                    this.level.setBlock(targetPos, Blocks.COBBLESTONE.defaultBlockState(), 3);
                }
            }
        }
        this.resetProgress();
        this.goToNextOffset();
    }

    @Override
    protected void resetProgress() {
        super.resetProgress();
        this.extractingFluid = false;
    }

    @Override
    protected void updateUpgradeModules() {
        this.xOffset = -1;
        this.yOffset = 0;
        this.zOffset = -1;
        super.updateUpgradeModules();
    }

    public void goToNextOffset() {
        int range = (int)Math.ceil((double)RANGE * this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.EXTRACTION_RANGE));
        int depth = (int)Math.ceil((double)DEPTH * this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.EXTRACTION_DEPTH));
        if (this.yOffset == 0) {
            this.yOffset = -1;
            this.xOffset = range;
            this.zOffset = 0;
        } else if (this.zOffset >= range - Math.abs(this.xOffset)) {
            if (-this.xOffset >= range) {
                --this.yOffset;
                if (-this.yOffset >= depth || this.getBlockPos().getY() + this.yOffset < this.level.getMinBuildHeight()) {
                    this.yOffset = -1;
                }
                this.xOffset = range;
                this.zOffset = 0;
                return;
            }
            --this.xOffset;
            this.zOffset = Math.abs(this.xOffset) - range;
        } else {
            ++this.zOffset;
        }
    }
}

