/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.Optional;
import me.jddev0.ep.block.AdvancedChargerBlock;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.ConfigurableUpgradableInventoryEnergyStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.ReceiveOnlyEnergyStorage;
import me.jddev0.ep.inventory.CombinedContainerData;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.inventory.data.ComparatorModeValueContainerData;
import me.jddev0.ep.inventory.data.EnergyValueContainerData;
import me.jddev0.ep.inventory.data.RedstoneModeValueContainerData;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.recipe.ChargerRecipe;
import me.jddev0.ep.recipe.ContainerRecipeInputWrapper;
import me.jddev0.ep.screen.AdvancedChargerMenu;
import me.jddev0.ep.util.RecipeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdvancedChargerBlockEntity
extends ConfigurableUpgradableInventoryEnergyStorageBlockEntity<ReceiveOnlyEnergyStorage, ItemStackHandler> {
    public static final float CHARGER_RECIPE_ENERGY_CONSUMPTION_MULTIPLIER = ModConfigs.COMMON_ADVANCED_CHARGER_CHARGER_RECIPE_ENERGY_CONSUMPTION_MULTIPLIER.getValue().floatValue();
    private final IItemHandler itemHandlerSided;
    private int[] energyConsumptionLeft;

    public AdvancedChargerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(EPBlockEntities.ADVANCED_CHARGER_ENTITY.get(), blockPos, blockState, "advanced_charger", ModConfigs.COMMON_ADVANCED_CHARGER_CAPACITY_PER_SLOT.getValue() * 3, ModConfigs.COMMON_ADVANCED_CHARGER_TRANSFER_RATE_PER_SLOT.getValue() * 3, 3, UpgradeModuleModifier.ENERGY_CAPACITY);
        this.itemHandlerSided = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> true, i -> {
            if (i < 0 || i > 2) {
                return false;
            }
            ItemStack stack = this.itemHandler.getStackInSlot(i.intValue());
            if (this.level != null && RecipeUtils.isResultOfAny(this.level, ChargerRecipe.Type.INSTANCE, stack)) {
                return true;
            }
            if (this.level == null || RecipeUtils.isIngredientOfAny(this.level, ChargerRecipe.Type.INSTANCE, stack)) {
                return false;
            }
            IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
            if (energyStorage == null || !energyStorage.canReceive()) {
                return true;
            }
            return energyStorage.receiveEnergy(((ReceiveOnlyEnergyStorage)this.energyStorage).getMaxReceive() / 3, true) == 0;
        });
        this.energyConsumptionLeft = new int[]{-1, -1, -1};
    }

    @Override
    protected ReceiveOnlyEnergyStorage initEnergyStorage() {
        return new ReceiveOnlyEnergyStorage(0, this.baseEnergyCapacity, this.baseEnergyTransferRate){

            @Override
            public int getCapacity() {
                return Math.max(1, (int)Math.ceil((double)this.capacity * AdvancedChargerBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CAPACITY)));
            }

            @Override
            public int getMaxReceive() {
                return Math.max(1, (int)Math.ceil((double)this.maxReceive * AdvancedChargerBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_TRANSFER_RATE)));
            }

            @Override
            protected void onChange() {
                AdvancedChargerBlockEntity.this.setChanged();
                AdvancedChargerBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                AdvancedChargerBlockEntity.this.setChanged();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                if (slot >= 0 && slot < 3) {
                    if (AdvancedChargerBlockEntity.this.level == null || RecipeUtils.isIngredientOfAny(AdvancedChargerBlockEntity.this.level, ChargerRecipe.Type.INSTANCE, stack)) {
                        return true;
                    }
                    IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
                    return energyStorage != null && energyStorage.canReceive();
                }
                return super.isItemValid(slot, stack);
            }

            public void setStackInSlot(int slot, @NotNull ItemStack stack) {
                if (slot >= 0 && slot < 3) {
                    ItemStack itemStack = this.getStackInSlot(slot);
                    if (!(AdvancedChargerBlockEntity.this.level == null || stack.isEmpty() || itemStack.isEmpty() || ItemStack.isSameItem((ItemStack)stack, (ItemStack)itemStack) && (ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemStack) || stack.getCapability(Capabilities.EnergyStorage.ITEM) != null && itemStack.getCapability(Capabilities.EnergyStorage.ITEM) != null))) {
                        AdvancedChargerBlockEntity.this.resetProgress(slot);
                    }
                }
                super.setStackInSlot(slot, stack);
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }

    @Override
    protected ContainerData initContainerData() {
        return new CombinedContainerData(new EnergyValueContainerData(this::getEnergyConsumptionPerTickSum, value -> {}), new EnergyValueContainerData(() -> this.energyConsumptionLeft[0], value -> {}), new EnergyValueContainerData(() -> this.energyConsumptionLeft[1], value -> {}), new EnergyValueContainerData(() -> this.energyConsumptionLeft[2], value -> {}), new RedstoneModeValueContainerData(() -> this.redstoneMode, value -> {
            this.redstoneMode = value;
        }), new ComparatorModeValueContainerData(() -> this.comparatorMode, value -> {
            this.comparatorMode = value;
        }));
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        this.syncEnergyToPlayer(player);
        return new AdvancedChargerMenu(id, inventory, this, this.upgradeModuleInventory, this.data);
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        return this.itemHandlerSided;
    }

    @Nullable
    public IEnergyStorage getEnergyStorageCapability(@Nullable Direction side) {
        return this.energyStorage;
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        for (int i = 0; i < 3; ++i) {
            nbt.put("recipe.energy_consumption_left." + i, (Tag)IntTag.valueOf((int)this.energyConsumptionLeft[i]));
        }
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        for (int i = 0; i < 3; ++i) {
            this.energyConsumptionLeft[i] = nbt.getInt("recipe.energy_consumption_left." + i);
        }
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, AdvancedChargerBlockEntity blockEntity) {
        if (level.isClientSide) {
            return;
        }
        if (!blockEntity.redstoneMode.isActive((Boolean)state.getValue((Property)AdvancedChargerBlock.POWERED))) {
            return;
        }
        int maxReceivePerSlot = (int)Math.min((double)((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getMaxReceive() / 3.0, Math.ceil((double)((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() / 3.0));
        for (int i = 0; i < 3; ++i) {
            if (blockEntity.hasRecipe(i)) {
                int energyConsumptionPerTick;
                ItemStack stack = blockEntity.itemHandler.getStackInSlot(i);
                SimpleContainer inventory = new SimpleContainer(1);
                inventory.setItem(0, blockEntity.itemHandler.getStackInSlot(i));
                Optional recipe = level.getRecipeManager().getRecipeFor((RecipeType)ChargerRecipe.Type.INSTANCE, (RecipeInput)new ContainerRecipeInputWrapper((Container)inventory), level);
                if (recipe.isPresent()) {
                    if (blockEntity.energyConsumptionLeft[i] == -1) {
                        blockEntity.energyConsumptionLeft[i] = (int)((float)((ChargerRecipe)((RecipeHolder)recipe.get()).value()).getEnergyConsumption() * CHARGER_RECIPE_ENERGY_CONSUMPTION_MULTIPLIER);
                    }
                    if (((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() == 0) {
                        AdvancedChargerBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
                        continue;
                    }
                    energyConsumptionPerTick = Math.min(blockEntity.energyConsumptionLeft[i], Math.min(maxReceivePerSlot, ((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy()));
                } else {
                    IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
                    if (energyStorage == null || !energyStorage.canReceive()) continue;
                    blockEntity.energyConsumptionLeft[i] = Math.max(0, energyStorage.getMaxEnergyStored() - energyStorage.getEnergyStored());
                    if (((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() == 0) {
                        AdvancedChargerBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
                        continue;
                    }
                    energyConsumptionPerTick = energyStorage.receiveEnergy(Math.min(maxReceivePerSlot, ((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy()), false);
                }
                if (blockEntity.energyConsumptionLeft[i] < 0 || energyConsumptionPerTick < 0) {
                    blockEntity.resetProgress(i);
                    AdvancedChargerBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
                    continue;
                }
                ((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).setEnergy(((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() - energyConsumptionPerTick);
                int n = i;
                blockEntity.energyConsumptionLeft[n] = blockEntity.energyConsumptionLeft[n] - energyConsumptionPerTick;
                if (blockEntity.energyConsumptionLeft[i] <= 0) {
                    int index = i;
                    recipe.ifPresent(chargerRecipe -> blockEntity.itemHandler.setStackInSlot(index, ((ChargerRecipe)chargerRecipe.value()).getResultItem((HolderLookup.Provider)level.registryAccess()).copyWithCount(1)));
                    blockEntity.resetProgress(i);
                }
                AdvancedChargerBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
                continue;
            }
            blockEntity.resetProgress(i);
            AdvancedChargerBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
        }
    }

    protected final int getEnergyConsumptionPerTickSum() {
        if (this.level == null) {
            return -1;
        }
        int maxReceivePerSlot = (int)Math.min((double)((ReceiveOnlyEnergyStorage)this.energyStorage).getMaxReceive() / 3.0, Math.ceil((double)((ReceiveOnlyEnergyStorage)this.energyStorage).getEnergy() / 3.0));
        int energyConsumptionSum = -1;
        for (int i = 0; i < 3; ++i) {
            int energyConsumption;
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            SimpleContainer inventory = new SimpleContainer(1);
            inventory.setItem(0, this.itemHandler.getStackInSlot(i));
            Optional recipe = this.level.getRecipeManager().getRecipeFor((RecipeType)ChargerRecipe.Type.INSTANCE, (RecipeInput)new ContainerRecipeInputWrapper((Container)inventory), this.level);
            if (recipe.isPresent()) {
                energyConsumption = Math.min(this.energyConsumptionLeft[i], Math.min(maxReceivePerSlot, ((ReceiveOnlyEnergyStorage)this.energyStorage).getEnergy()));
            } else {
                IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
                if (energyStorage == null || !energyStorage.canReceive()) continue;
                energyConsumption = energyStorage.receiveEnergy(Math.min(maxReceivePerSlot, ((ReceiveOnlyEnergyStorage)this.energyStorage).getEnergy()), true);
            }
            energyConsumptionSum = energyConsumptionSum == -1 ? energyConsumption : (energyConsumptionSum += energyConsumption);
            if (energyConsumptionSum >= 0) continue;
            energyConsumptionSum = Integer.MAX_VALUE;
        }
        return energyConsumptionSum;
    }

    private void resetProgress(int index) {
        this.energyConsumptionLeft[index] = -1;
    }

    private boolean hasRecipe(int index) {
        ItemStack stack = this.itemHandler.getStackInSlot(index);
        if (stack.getCapability(Capabilities.EnergyStorage.ITEM) != null) {
            return true;
        }
        SimpleContainer inventory = new SimpleContainer(1);
        inventory.setItem(0, this.itemHandler.getStackInSlot(index));
        Optional recipe = this.level.getRecipeManager().getRecipeFor((RecipeType)ChargerRecipe.Type.INSTANCE, (RecipeInput)new ContainerRecipeInputWrapper((Container)inventory), this.level);
        return recipe.isPresent();
    }

    @Override
    protected void updateUpgradeModules() {
        for (int i = 0; i < 3; ++i) {
            this.resetProgress(i);
        }
        super.updateUpgradeModules();
    }
}

