/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import me.jddev0.ep.block.AdvancedAutoCrafterBlock;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.ConfigurableUpgradableInventoryEnergyStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.ReceiveOnlyEnergyStorage;
import me.jddev0.ep.inventory.CombinedContainerData;
import me.jddev0.ep.inventory.InputOutputItemHandler;
import me.jddev0.ep.inventory.data.BooleanValueContainerData;
import me.jddev0.ep.inventory.data.ComparatorModeValueContainerData;
import me.jddev0.ep.inventory.data.EnergyValueContainerData;
import me.jddev0.ep.inventory.data.ProgressValueContainerData;
import me.jddev0.ep.inventory.data.RedstoneModeValueContainerData;
import me.jddev0.ep.inventory.data.ShortValueContainerData;
import me.jddev0.ep.machine.CheckboxUpdate;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.screen.AdvancedAutoCrafterMenu;
import me.jddev0.ep.util.ItemStackUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdvancedAutoCrafterBlockEntity
extends ConfigurableUpgradableInventoryEnergyStorageBlockEntity<ReceiveOnlyEnergyStorage, ItemStackHandler>
implements CheckboxUpdate {
    private static final List<@NotNull ResourceLocation> RECIPE_BLACKLIST = ModConfigs.COMMON_ADVANCED_AUTO_CRAFTER_RECIPE_BLACKLIST.getValue();
    private static final int RECIPE_DURATION = ModConfigs.COMMON_ADVANCED_AUTO_CRAFTER_RECIPE_DURATION.getValue();
    private boolean secondaryExtractMode = false;
    private boolean allowOutputOverflow = true;
    private final IItemHandler itemHandlerSided = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i >= 5, i -> this.secondaryExtractMode ? !this.isInput(this.itemHandler.getStackInSlot(i.intValue())) : this.isOutputOrCraftingRemainderOfInput(this.itemHandler.getStackInSlot(i.intValue())));
    private final SimpleContainer[] patternSlots = new SimpleContainer[]{new SimpleContainer(this, 9){

        public int getMaxStackSize() {
            return 1;
        }
    }, new SimpleContainer(this, 9){

        public int getMaxStackSize() {
            return 1;
        }
    }, new SimpleContainer(this, 9){

        public int getMaxStackSize() {
            return 1;
        }
    }};
    private final SimpleContainer[] patternResultSlots = new SimpleContainer[]{new SimpleContainer(1), new SimpleContainer(1), new SimpleContainer(1)};
    private final ContainerListener[] updatePatternListener = new ContainerListener[]{container -> this.updateRecipe(0), container -> this.updateRecipe(1), container -> this.updateRecipe(2)};
    private final boolean[] hasRecipeLoaded = new boolean[]{false, false, false};
    private final ResourceLocation[] recipeIdForSetRecipe = new ResourceLocation[]{null, null, null};
    private final RecipeHolder<CraftingRecipe>[] craftingRecipe = new RecipeHolder[]{null, null, null};
    private final CraftingContainer[] oldCopyOfRecipe = new CraftingContainer[]{null, null, null};
    private final AbstractContainerMenu dummyContainerMenu = new AbstractContainerMenu(this, null, -1){

        public ItemStack quickMoveStack(Player player, int index) {
            return null;
        }

        public boolean stillValid(Player player) {
            return false;
        }

        public void slotsChanged(Container container) {
        }
    };
    public static final int ENERGY_CONSUMPTION_PER_TICK_PER_INGREDIENT = ModConfigs.COMMON_ADVANCED_AUTO_CRAFTER_ENERGY_CONSUMPTION_PER_TICK_PER_INGREDIENT.getValue();
    private final int[] progress = new int[]{0, 0, 0};
    private final int[] maxProgress = new int[]{0, 0, 0};
    private final int[] energyConsumptionLeft = new int[]{-1, -1, -1};
    private final boolean[] hasEnoughEnergy = new boolean[]{false, false, false};
    private final boolean[] ignoreNBT = new boolean[]{false, false, false};
    private int currentRecipeIndex = 0;

    public AdvancedAutoCrafterBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(EPBlockEntities.ADVANCED_AUTO_CRAFTER_ENTITY.get(), blockPos, blockState, "advanced_auto_crafter", ModConfigs.COMMON_ADVANCED_AUTO_CRAFTER_CAPACITY.getValue(), ModConfigs.COMMON_ADVANCED_AUTO_CRAFTER_TRANSFER_RATE.getValue(), 27, UpgradeModuleModifier.SPEED, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_CAPACITY);
        for (int i2 = 0; i2 < 3; ++i2) {
            this.patternSlots[i2].addListener(this.updatePatternListener[i2]);
        }
    }

    @Override
    protected ReceiveOnlyEnergyStorage initEnergyStorage() {
        return new ReceiveOnlyEnergyStorage(0, this.baseEnergyCapacity, this.baseEnergyTransferRate){

            @Override
            public int getCapacity() {
                return Math.max(1, (int)Math.ceil((double)this.capacity * AdvancedAutoCrafterBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CAPACITY)));
            }

            @Override
            public int getMaxReceive() {
                return Math.max(1, (int)Math.ceil((double)this.maxReceive * AdvancedAutoCrafterBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_TRANSFER_RATE)));
            }

            @Override
            protected void onChange() {
                AdvancedAutoCrafterBlockEntity.this.setChanged();
                AdvancedAutoCrafterBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                AdvancedAutoCrafterBlockEntity.this.setChanged();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                if (slot < 0 || slot >= 27) {
                    return super.isItemValid(slot, stack);
                }
                return slot >= 5;
            }
        };
    }

    @Override
    protected ContainerData initContainerData() {
        return new CombinedContainerData(new ProgressValueContainerData(() -> this.progress[0], value -> {
            this.progress[0] = value;
        }), new ProgressValueContainerData(() -> this.progress[1], value -> {
            this.progress[1] = value;
        }), new ProgressValueContainerData(() -> this.progress[2], value -> {
            this.progress[2] = value;
        }), new ProgressValueContainerData(() -> this.maxProgress[0], value -> {
            this.maxProgress[0] = value;
        }), new ProgressValueContainerData(() -> this.maxProgress[1], value -> {
            this.maxProgress[1] = value;
        }), new ProgressValueContainerData(() -> this.maxProgress[2], value -> {
            this.maxProgress[2] = value;
        }), new EnergyValueContainerData(this::getEnergyConsumptionPerTickSum, value -> {}), new EnergyValueContainerData(() -> this.energyConsumptionLeft[0], value -> {}), new EnergyValueContainerData(() -> this.energyConsumptionLeft[1], value -> {}), new EnergyValueContainerData(() -> this.energyConsumptionLeft[2], value -> {}), new BooleanValueContainerData(() -> this.hasEnoughEnergy[0], value -> {}), new BooleanValueContainerData(() -> this.hasEnoughEnergy[1], value -> {}), new BooleanValueContainerData(() -> this.hasEnoughEnergy[2], value -> {}), new BooleanValueContainerData(() -> this.ignoreNBT[0], value -> {
            this.ignoreNBT[0] = value;
        }), new BooleanValueContainerData(() -> this.ignoreNBT[1], value -> {
            this.ignoreNBT[1] = value;
        }), new BooleanValueContainerData(() -> this.ignoreNBT[2], value -> {
            this.ignoreNBT[2] = value;
        }), new BooleanValueContainerData(() -> this.secondaryExtractMode, value -> {
            this.secondaryExtractMode = value;
        }), new BooleanValueContainerData(() -> this.allowOutputOverflow, value -> {
            this.allowOutputOverflow = value;
        }), new ShortValueContainerData(() -> (short)this.currentRecipeIndex, value -> {
            this.currentRecipeIndex = value.shortValue();
        }), new RedstoneModeValueContainerData(() -> this.redstoneMode, value -> {
            this.redstoneMode = value;
        }), new ComparatorModeValueContainerData(() -> this.comparatorMode, value -> {
            this.comparatorMode = value;
        }));
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        this.syncEnergyToPlayer(player);
        return new AdvancedAutoCrafterMenu(id, inventory, this, this.upgradeModuleInventory, (Container[])this.patternSlots, (Container[])this.patternResultSlots, this.data);
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        return this.itemHandlerSided;
    }

    @Nullable
    public IEnergyStorage getEnergyStorageCapability(@Nullable Direction side) {
        return this.energyStorage;
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        int i;
        super.saveAdditional(nbt, registries);
        for (i = 0; i < 3; ++i) {
            nbt.put("pattern." + i, this.savePatternContainer(i, registries));
        }
        for (i = 0; i < 3; ++i) {
            if (this.craftingRecipe[i] != null) {
                nbt.put("recipe.id." + i, (Tag)StringTag.valueOf((String)this.craftingRecipe[i].id().toString()));
            }
            nbt.put("recipe.progress." + i, (Tag)IntTag.valueOf((int)this.progress[i]));
            nbt.put("recipe.max_progress." + i, (Tag)IntTag.valueOf((int)this.maxProgress[i]));
            nbt.put("recipe.energy_consumption_left." + i, (Tag)IntTag.valueOf((int)this.energyConsumptionLeft[i]));
            nbt.putBoolean("ignore_nbt." + i, this.ignoreNBT[i]);
        }
        nbt.putBoolean("secondary_extract_mode", this.secondaryExtractMode);
        nbt.putBoolean("allow_output_overflow", this.allowOutputOverflow);
        nbt.putInt("current_recipe_index", this.currentRecipeIndex);
    }

    private Tag savePatternContainer(int index, HolderLookup.Provider registries) {
        NonNullList items = NonNullList.withSize((int)this.patternSlots[index].getContainerSize(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < this.patternSlots[index].getContainerSize(); ++i) {
            items.set(i, (Object)this.patternSlots[index].getItem(i));
        }
        return ContainerHelper.saveAllItems((CompoundTag)new CompoundTag(), (NonNullList)items, (HolderLookup.Provider)registries);
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        int i;
        super.loadAdditional(nbt, registries);
        for (i = 0; i < 3; ++i) {
            this.loadPatternContainer(i, nbt.getCompound("pattern." + i), registries);
        }
        for (i = 0; i < 3; ++i) {
            if (nbt.contains("recipe.id." + i)) {
                Tag tag = nbt.get("recipe.id." + i);
                if (!(tag instanceof StringTag)) {
                    throw new IllegalArgumentException("Tag must be of type StringTag!");
                }
                StringTag stringTag = (StringTag)tag;
                this.recipeIdForSetRecipe[i] = ResourceLocation.tryParse((String)stringTag.getAsString());
            }
            this.progress[i] = nbt.getInt("recipe.progress." + i);
            this.maxProgress[i] = nbt.getInt("recipe.max_progress." + i);
            this.energyConsumptionLeft[i] = nbt.getInt("recipe.energy_consumption_left." + i);
            this.ignoreNBT[i] = nbt.getBoolean("ignore_nbt." + i);
        }
        this.secondaryExtractMode = nbt.getBoolean("secondary_extract_mode");
        this.allowOutputOverflow = !nbt.contains("allow_output_overflow") || nbt.getBoolean("allow_output_overflow");
        this.currentRecipeIndex = nbt.getInt("current_recipe_index");
        if (this.currentRecipeIndex < 0 || this.currentRecipeIndex >= 3) {
            this.currentRecipeIndex = 0;
        }
    }

    private void loadPatternContainer(int index, CompoundTag tag, HolderLookup.Provider registries) {
        this.patternSlots[index].removeListener(this.updatePatternListener[index]);
        NonNullList items = NonNullList.withSize((int)this.patternSlots[index].getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, (NonNullList)items, (HolderLookup.Provider)registries);
        for (int i = 0; i < this.patternSlots[index].getContainerSize(); ++i) {
            this.patternSlots[index].setItem(i, (ItemStack)items.get(i));
        }
        this.patternSlots[index].addListener(this.updatePatternListener[index]);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, AdvancedAutoCrafterBlockEntity blockEntity) {
        if (level.isClientSide) {
            return;
        }
        if (!blockEntity.redstoneMode.isActive((Boolean)state.getValue((Property)AdvancedAutoCrafterBlock.POWERED))) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            if (!blockEntity.hasRecipeLoaded[i]) {
                blockEntity.updateRecipe(i);
                if (blockEntity.craftingRecipe[i] == null) {
                    blockEntity.resetProgress(i);
                }
                AdvancedAutoCrafterBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
            }
            int itemCount = 0;
            for (int j = 0; j < blockEntity.patternSlots[i].getContainerSize(); ++j) {
                if (blockEntity.patternSlots[i].getItem(j).isEmpty()) continue;
                ++itemCount;
            }
            if (itemCount == 0) continue;
            if (blockEntity.craftingRecipe[i] != null && (blockEntity.progress[i] > 0 || blockEntity.canInsertItemsIntoOutputSlots(i) && blockEntity.canExtractItemsFromInput(i))) {
                if (!blockEntity.canInsertItemsIntoOutputSlots(i) || !blockEntity.canExtractItemsFromInput(i)) continue;
                if (blockEntity.maxProgress[i] == 0) {
                    blockEntity.maxProgress[i] = Math.max(1, (int)Math.ceil((double)RECIPE_DURATION / blockEntity.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.SPEED)));
                }
                int energyConsumptionPerTick = Math.max(1, (int)Math.ceil((double)(itemCount * ENERGY_CONSUMPTION_PER_TICK_PER_INGREDIENT) * blockEntity.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CONSUMPTION)));
                if (blockEntity.progress[i] == 0) {
                    if (!blockEntity.canExtractItemsFromInput(i)) continue;
                    blockEntity.energyConsumptionLeft[i] = energyConsumptionPerTick * blockEntity.maxProgress[i];
                }
                if (blockEntity.progress[i] < 0 || blockEntity.maxProgress[i] < 0 || blockEntity.energyConsumptionLeft[i] < 0) {
                    blockEntity.resetProgress(i);
                    AdvancedAutoCrafterBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
                    continue;
                }
                if (energyConsumptionPerTick <= ((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy()) {
                    ((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).setEnergy(((ReceiveOnlyEnergyStorage)blockEntity.energyStorage).getEnergy() - energyConsumptionPerTick);
                    int n = i;
                    blockEntity.energyConsumptionLeft[n] = blockEntity.energyConsumptionLeft[n] - energyConsumptionPerTick;
                    int n2 = i;
                    blockEntity.progress[n2] = blockEntity.progress[n2] + 1;
                    if (blockEntity.progress[i] >= blockEntity.maxProgress[i]) {
                        SimpleContainer patternSlotsForRecipe = blockEntity.ignoreNBT[i] ? blockEntity.replaceCraftingPatternWithCurrentNBTItems(blockEntity.patternSlots[i]) : blockEntity.patternSlots[i];
                        TransientCraftingContainer copyOfPatternSlots = new TransientCraftingContainer(blockEntity.dummyContainerMenu, 3, 3);
                        for (int j = 0; j < patternSlotsForRecipe.getContainerSize(); ++j) {
                            copyOfPatternSlots.setItem(j, patternSlotsForRecipe.getItem(j));
                        }
                        blockEntity.extractItems(i);
                        blockEntity.craftItem(i, (CraftingContainer)copyOfPatternSlots);
                    }
                    AdvancedAutoCrafterBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
                    continue;
                }
                blockEntity.hasEnoughEnergy[i] = false;
                AdvancedAutoCrafterBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
                continue;
            }
            blockEntity.resetProgress(i);
            AdvancedAutoCrafterBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)state);
        }
    }

    protected final int getEnergyConsumptionPerTickSum() {
        int energyConsumptionSum = -1;
        for (int i = 0; i < 3; ++i) {
            int itemCount = 0;
            for (int j = 0; j < this.patternSlots[i].getContainerSize(); ++j) {
                if (this.patternSlots[i].getItem(j).isEmpty()) continue;
                ++itemCount;
            }
            if (itemCount == 0 || this.craftingRecipe[i] == null || this.progress[i] <= 0) continue;
            int energyConsumption = Math.max(1, (int)Math.ceil((double)(itemCount * ENERGY_CONSUMPTION_PER_TICK_PER_INGREDIENT) * this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CONSUMPTION)));
            energyConsumptionSum = energyConsumptionSum == -1 ? energyConsumption : (energyConsumptionSum += energyConsumption);
            if (energyConsumptionSum >= 0) continue;
            energyConsumptionSum = Integer.MAX_VALUE;
        }
        return energyConsumptionSum;
    }

    private void resetProgress(int index) {
        this.progress[index] = 0;
        this.maxProgress[index] = 0;
        this.energyConsumptionLeft[index] = -1;
        this.hasEnoughEnergy[index] = true;
    }

    public void resetProgressAndMarkAsChanged(int index) {
        this.resetProgress(index);
        AdvancedAutoCrafterBlockEntity.setChanged((Level)this.level, (BlockPos)this.getBlockPos(), (BlockState)this.getBlockState());
    }

    public void cycleRecipe() {
        SimpleContainer patternSlotsForRecipe = this.ignoreNBT[this.currentRecipeIndex] ? this.replaceCraftingPatternWithCurrentNBTItems(this.patternSlots[this.currentRecipeIndex]) : this.patternSlots[this.currentRecipeIndex];
        TransientCraftingContainer copyOfPatternSlots = new TransientCraftingContainer(this.dummyContainerMenu, 3, 3);
        for (int i = 0; i < patternSlotsForRecipe.getContainerSize(); ++i) {
            copyOfPatternSlots.setItem(i, patternSlotsForRecipe.getItem(i));
        }
        List<RecipeHolder<CraftingRecipe>> recipes = this.getRecipesFor((CraftingContainer)copyOfPatternSlots, this.level);
        if (recipes.isEmpty()) {
            this.updateRecipe(this.currentRecipeIndex);
            return;
        }
        if (this.recipeIdForSetRecipe[this.currentRecipeIndex] == null) {
            this.recipeIdForSetRecipe[this.currentRecipeIndex] = this.craftingRecipe[this.currentRecipeIndex] == null || this.craftingRecipe[this.currentRecipeIndex].id() == null ? recipes.get(0).id() : this.craftingRecipe[this.currentRecipeIndex].id();
        }
        for (int i = 0; i < recipes.size(); ++i) {
            if (!Objects.equals(recipes.get(i).id(), this.recipeIdForSetRecipe[this.currentRecipeIndex])) continue;
            this.recipeIdForSetRecipe[this.currentRecipeIndex] = recipes.get((i + 1) % recipes.size()).id();
            break;
        }
        this.updateRecipe(this.currentRecipeIndex);
    }

    public void setRecipeIdForSetRecipe(ResourceLocation recipeIdForSetRecipe) {
        this.recipeIdForSetRecipe[this.currentRecipeIndex] = recipeIdForSetRecipe;
        this.updateRecipe(this.currentRecipeIndex);
    }

    private void updateRecipe(int index) {
        if (this.level == null) {
            return;
        }
        RecipeHolder<CraftingRecipe> oldRecipe = null;
        ItemStack oldResult = null;
        if (this.hasRecipeLoaded[index] && this.craftingRecipe[index] != null && this.oldCopyOfRecipe[index] != null) {
            oldRecipe = this.craftingRecipe[index];
            oldResult = this.craftingRecipe[index].value() instanceof CustomRecipe ? ((CraftingRecipe)this.craftingRecipe[index].value()).assemble((RecipeInput)this.oldCopyOfRecipe[index].asCraftInput(), (HolderLookup.Provider)this.level.registryAccess()) : ((CraftingRecipe)this.craftingRecipe[index].value()).getResultItem((HolderLookup.Provider)this.level.registryAccess());
        }
        this.hasRecipeLoaded[index] = true;
        SimpleContainer patternSlotsForRecipe = this.ignoreNBT[index] ? this.replaceCraftingPatternWithCurrentNBTItems(this.patternSlots[index]) : this.patternSlots[index];
        TransientCraftingContainer copyOfPatternSlots = new TransientCraftingContainer(this.dummyContainerMenu, 3, 3);
        for (int i = 0; i < patternSlotsForRecipe.getContainerSize(); ++i) {
            copyOfPatternSlots.setItem(i, patternSlotsForRecipe.getItem(i));
        }
        Optional<Pair<ResourceLocation, RecipeHolder<CraftingRecipe>>> recipe = this.getRecipeFor((CraftingContainer)copyOfPatternSlots, this.level, this.recipeIdForSetRecipe[index]);
        if (recipe.isPresent()) {
            this.craftingRecipe[index] = (RecipeHolder)recipe.get().getSecond();
            if (this.recipeIdForSetRecipe[index] != null && !Objects.equals(this.craftingRecipe[index].id(), this.recipeIdForSetRecipe[index])) {
                this.recipeIdForSetRecipe[index] = this.craftingRecipe[index].id();
                this.resetProgress(index);
            }
            ItemStack resultItemStack = this.craftingRecipe[index].value() instanceof CustomRecipe ? ((CraftingRecipe)this.craftingRecipe[index].value()).assemble((RecipeInput)copyOfPatternSlots.asCraftInput(), (HolderLookup.Provider)this.level.registryAccess()) : ((CraftingRecipe)this.craftingRecipe[index].value()).getResultItem((HolderLookup.Provider)this.level.registryAccess());
            this.patternResultSlots[index].setItem(0, resultItemStack);
            if (!(oldRecipe == null || oldResult == null || this.oldCopyOfRecipe[index] == null || this.craftingRecipe[index] == oldRecipe && ItemStack.isSameItemSameComponents((ItemStack)resultItemStack, (ItemStack)oldResult))) {
                this.resetProgress(index);
            }
            this.oldCopyOfRecipe[index] = new TransientCraftingContainer(this.dummyContainerMenu, 3, 3);
            for (int i = 0; i < patternSlotsForRecipe.getContainerSize(); ++i) {
                this.oldCopyOfRecipe[index].setItem(i, copyOfPatternSlots.getItem(i).copy());
            }
        } else {
            this.recipeIdForSetRecipe[index] = null;
            this.craftingRecipe[index] = null;
            this.patternResultSlots[index].setItem(0, ItemStack.EMPTY);
            this.oldCopyOfRecipe[index] = null;
            this.resetProgress(index);
        }
    }

    private void extractItems(int index) {
        SimpleContainer patternSlotsForRecipe = this.ignoreNBT[index] ? this.replaceCraftingPatternWithCurrentNBTItems(this.patternSlots[index]) : this.patternSlots[index];
        ArrayList<ItemStack> patternItemStacks = new ArrayList<ItemStack>(9);
        for (int i = 0; i < patternSlotsForRecipe.getContainerSize(); ++i) {
            if (patternSlotsForRecipe.getItem(i).isEmpty()) continue;
            patternItemStacks.add(patternSlotsForRecipe.getItem(i));
        }
        List<ItemStack> itemStacksExtract = ItemStackUtils.combineItemStacks(patternItemStacks);
        block1: for (ItemStack itemStack : itemStacksExtract) {
            for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                ItemStack ret;
                ItemStack testItemStack = this.itemHandler.getStackInSlot(i);
                if (!ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)testItemStack) || (ret = this.itemHandler.extractItem(i, itemStack.getCount(), false)).isEmpty()) continue;
                int amount = ret.getCount();
                if (amount == itemStack.getCount()) continue block1;
                itemStack.shrink(amount);
            }
        }
    }

    private void craftItem(int index, CraftingContainer copyOfPatternSlots) {
        if (this.craftingRecipe[index] == null) {
            this.resetProgress(index);
            return;
        }
        ArrayList<ItemStack> outputItemStacks = new ArrayList<ItemStack>(10);
        ItemStack resultItemStack = this.craftingRecipe[index].value() instanceof CustomRecipe ? ((CraftingRecipe)this.craftingRecipe[index].value()).assemble((RecipeInput)copyOfPatternSlots.asCraftInput(), (HolderLookup.Provider)this.level.registryAccess()) : ((CraftingRecipe)this.craftingRecipe[index].value()).getResultItem((HolderLookup.Provider)this.level.registryAccess());
        outputItemStacks.add(resultItemStack);
        for (ItemStack remainingItem : ((CraftingRecipe)this.craftingRecipe[index].value()).getRemainingItems((RecipeInput)copyOfPatternSlots.asCraftInput())) {
            if (remainingItem.isEmpty()) continue;
            outputItemStacks.add(remainingItem);
        }
        List<ItemStack> itemStacksInsert = ItemStackUtils.combineItemStacks(outputItemStacks);
        int outputSlotCount = this.allowOutputOverflow ? this.itemHandler.getSlots() : 5;
        ArrayList<Integer> emptyIndices = new ArrayList<Integer>(outputSlotCount);
        block1: for (ItemStack itemStack : itemStacksInsert) {
            for (int i = 0; i < outputSlotCount; ++i) {
                int amount;
                ItemStack testItemStack = this.itemHandler.getStackInSlot(i);
                if (emptyIndices.contains(i)) continue;
                if (testItemStack.isEmpty()) {
                    emptyIndices.add(i);
                    continue;
                }
                if (!ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)testItemStack) || (amount = Math.min(itemStack.getCount(), testItemStack.getMaxStackSize() - testItemStack.getCount())) <= 0) continue;
                this.itemHandler.setStackInSlot(i, this.itemHandler.getStackInSlot(i).copyWithCount(testItemStack.getCount() + amount));
                itemStack.setCount(itemStack.getCount() - amount);
                if (itemStack.isEmpty()) continue block1;
            }
            if (emptyIndices.isEmpty()) continue;
            this.itemHandler.setStackInSlot(((Integer)emptyIndices.remove(0)).intValue(), itemStack);
        }
        if (this.ignoreNBT[index]) {
            this.updateRecipe(index);
        }
        this.resetProgress(index);
    }

    private boolean canExtractItemsFromInput(int index) {
        if (this.craftingRecipe[index] == null) {
            return false;
        }
        SimpleContainer patternSlotsForRecipe = this.ignoreNBT[index] ? this.replaceCraftingPatternWithCurrentNBTItems(this.patternSlots[index]) : this.patternSlots[index];
        ArrayList<ItemStack> patternItemStacks = new ArrayList<ItemStack>(9);
        for (int i = 0; i < patternSlotsForRecipe.getContainerSize(); ++i) {
            if (patternSlotsForRecipe.getItem(i).isEmpty()) continue;
            patternItemStacks.add(patternSlotsForRecipe.getItem(i));
        }
        List<ItemStack> itemStacks = ItemStackUtils.combineItemStacks(patternItemStacks);
        ArrayList<Integer> checkedIndices = new ArrayList<Integer>(27);
        for (int i = itemStacks.size() - 1; i >= 0; --i) {
            block6: {
                ItemStack itemStack = itemStacks.get(i);
                for (int j = 0; j < this.itemHandler.getSlots(); ++j) {
                    if (checkedIndices.contains(j)) continue;
                    ItemStack testItemStack = this.itemHandler.getStackInSlot(j);
                    if (testItemStack.isEmpty()) {
                        checkedIndices.add(j);
                        continue;
                    }
                    if (!ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)testItemStack)) continue;
                    int amount = Math.min(itemStack.getCount(), testItemStack.getCount());
                    checkedIndices.add(j);
                    if (amount != itemStack.getCount()) {
                        itemStack.shrink(amount);
                        continue;
                    }
                    break block6;
                }
                return false;
            }
            itemStacks.remove(i);
        }
        return itemStacks.isEmpty();
    }

    private boolean canInsertItemsIntoOutputSlots(int index) {
        ItemStack resultItemStack;
        if (this.craftingRecipe[index] == null) {
            return false;
        }
        SimpleContainer patternSlotsForRecipe = this.ignoreNBT[index] ? this.replaceCraftingPatternWithCurrentNBTItems(this.patternSlots[index]) : this.patternSlots[index];
        TransientCraftingContainer copyOfPatternSlots = new TransientCraftingContainer(this.dummyContainerMenu, 3, 3);
        for (int i = 0; i < patternSlotsForRecipe.getContainerSize(); ++i) {
            copyOfPatternSlots.setItem(i, patternSlotsForRecipe.getItem(i));
        }
        ArrayList<ItemStack> outputItemStacks = new ArrayList<ItemStack>(10);
        ItemStack itemStack = resultItemStack = this.craftingRecipe[index].value() instanceof CustomRecipe ? ((CraftingRecipe)this.craftingRecipe[index].value()).assemble((RecipeInput)copyOfPatternSlots.asCraftInput(), (HolderLookup.Provider)this.level.registryAccess()) : ((CraftingRecipe)this.craftingRecipe[index].value()).getResultItem((HolderLookup.Provider)this.level.registryAccess());
        if (!resultItemStack.isEmpty()) {
            outputItemStacks.add(resultItemStack);
        }
        for (ItemStack remainingItem : ((CraftingRecipe)this.craftingRecipe[index].value()).getRemainingItems((RecipeInput)copyOfPatternSlots.asCraftInput())) {
            if (remainingItem.isEmpty()) continue;
            outputItemStacks.add(remainingItem);
        }
        List<ItemStack> itemStacks = ItemStackUtils.combineItemStacks(outputItemStacks);
        int outputSlotCount = this.allowOutputOverflow ? this.itemHandler.getSlots() : 5;
        ArrayList<Integer> checkedIndices = new ArrayList<Integer>(outputSlotCount);
        ArrayList<Integer> emptyIndices = new ArrayList<Integer>(outputSlotCount);
        block2: for (int i = itemStacks.size() - 1; i >= 0; --i) {
            ItemStack itemStack2 = itemStacks.get(i);
            for (int j = 0; j < outputSlotCount; ++j) {
                if (checkedIndices.contains(j) || emptyIndices.contains(j)) continue;
                ItemStack testItemStack = this.itemHandler.getStackInSlot(j);
                if (testItemStack.isEmpty()) {
                    emptyIndices.add(j);
                    continue;
                }
                if (!ItemStack.isSameItemSameComponents((ItemStack)itemStack2, (ItemStack)testItemStack)) continue;
                int amount = Math.min(itemStack2.getCount(), testItemStack.getMaxStackSize() - testItemStack.getCount());
                if (amount + testItemStack.getCount() == testItemStack.getMaxStackSize()) {
                    checkedIndices.add(j);
                }
                if (amount == itemStack2.getCount()) {
                    itemStacks.remove(i);
                    continue block2;
                }
                itemStack2.shrink(amount);
            }
            if (emptyIndices.isEmpty()) {
                return false;
            }
            int emptyIndex = (Integer)emptyIndices.remove(0);
            if (itemStack2.getCount() == itemStack2.getMaxStackSize()) {
                checkedIndices.add(emptyIndex);
            }
            itemStacks.remove(i);
        }
        return itemStacks.isEmpty();
    }

    private boolean isOutputOrCraftingRemainderOfInput(ItemStack itemStack) {
        for (int i = 0; i < 3; ++i) {
            ItemStack resultItemStack;
            if (this.craftingRecipe[i] == null) continue;
            SimpleContainer patternSlotsForRecipe = this.ignoreNBT[i] ? this.replaceCraftingPatternWithCurrentNBTItems(this.patternSlots[i]) : this.patternSlots[i];
            TransientCraftingContainer copyOfPatternSlots = new TransientCraftingContainer(this.dummyContainerMenu, 3, 3);
            for (int j = 0; j < patternSlotsForRecipe.getContainerSize(); ++j) {
                copyOfPatternSlots.setItem(j, patternSlotsForRecipe.getItem(j));
            }
            ItemStack itemStack2 = resultItemStack = this.craftingRecipe[i].value() instanceof CustomRecipe ? ((CraftingRecipe)this.craftingRecipe[i].value()).assemble((RecipeInput)copyOfPatternSlots.asCraftInput(), (HolderLookup.Provider)this.level.registryAccess()) : ((CraftingRecipe)this.craftingRecipe[i].value()).getResultItem((HolderLookup.Provider)this.level.registryAccess());
            if (ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)resultItemStack)) {
                return true;
            }
            for (ItemStack remainingItem : ((CraftingRecipe)this.craftingRecipe[i].value()).getRemainingItems((RecipeInput)copyOfPatternSlots.asCraftInput())) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)remainingItem)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isInput(ItemStack itemStack) {
        for (int i = 0; i < 3; ++i) {
            if (this.craftingRecipe[i] == null) continue;
            for (int j = 0; j < this.patternSlots[i].getContainerSize(); ++j) {
                if (!(this.ignoreNBT[i] ? ItemStack.isSameItem((ItemStack)itemStack, (ItemStack)this.patternSlots[i].getItem(j)) : ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)this.patternSlots[i].getItem(j)))) continue;
                return true;
            }
        }
        return false;
    }

    private SimpleContainer replaceCraftingPatternWithCurrentNBTItems(SimpleContainer container) {
        SimpleContainer copyOfContainer = new SimpleContainer(container.getContainerSize());
        for (int i = 0; i < container.getContainerSize(); ++i) {
            copyOfContainer.setItem(i, container.getItem(i).copy());
        }
        HashMap<Integer, Integer> usedItemCounts = new HashMap<Integer, Integer>();
        block1: for (int i = 0; i < copyOfContainer.getContainerSize(); ++i) {
            int usedCount;
            ItemStack testItemStack;
            int j;
            ItemStack itemStack = copyOfContainer.getItem(i);
            if (itemStack.isEmpty()) continue;
            for (j = 0; j < this.itemHandler.getSlots(); ++j) {
                testItemStack = this.itemHandler.getStackInSlot(j).copy();
                usedCount = usedItemCounts.getOrDefault(j, 0);
                testItemStack.setCount(testItemStack.getCount() - usedCount);
                if (testItemStack.getCount() <= 0 || !ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)testItemStack)) continue;
                usedItemCounts.put(j, usedCount + 1);
                continue block1;
            }
            for (j = 0; j < this.itemHandler.getSlots(); ++j) {
                testItemStack = this.itemHandler.getStackInSlot(j).copy();
                usedCount = usedItemCounts.getOrDefault(j, 0);
                testItemStack.setCount(testItemStack.getCount() - usedCount);
                if (testItemStack.getCount() <= 0 || !ItemStack.isSameItem((ItemStack)itemStack, (ItemStack)testItemStack)) continue;
                usedItemCounts.put(j, usedCount + 1);
                copyOfContainer.setItem(i, testItemStack.copyWithCount(1));
                continue block1;
            }
            return copyOfContainer;
        }
        return copyOfContainer;
    }

    private List<RecipeHolder<CraftingRecipe>> getRecipesFor(CraftingContainer patternSlots, Level level) {
        return level.getRecipeManager().getAllRecipesFor(RecipeType.CRAFTING).stream().filter(recipe -> !RECIPE_BLACKLIST.contains(recipe.id())).filter(recipe -> ((CraftingRecipe)recipe.value()).matches((RecipeInput)patternSlots.asCraftInput(), level)).sorted(Comparator.comparing(recipe -> ((CraftingRecipe)recipe.value()).getResultItem((HolderLookup.Provider)level.registryAccess()).getDescriptionId())).toList();
    }

    private Optional<Pair<ResourceLocation, RecipeHolder<CraftingRecipe>>> getRecipeFor(CraftingContainer patternSlots, Level level, ResourceLocation recipeId) {
        List<RecipeHolder<CraftingRecipe>> recipes = this.getRecipesFor(patternSlots, level);
        Optional<RecipeHolder> recipe = recipes.stream().filter(r -> r.id().equals((Object)recipeId)).findFirst();
        return recipe.or(() -> recipes.stream().findFirst()).map(r -> Pair.of((Object)r.id(), (Object)r));
    }

    @Override
    protected void updateUpgradeModules() {
        for (int i = 0; i < 3; ++i) {
            this.resetProgress(i);
        }
        super.updateUpgradeModules();
    }

    public int getCurrentRecipeIndex() {
        return this.currentRecipeIndex;
    }

    public void setCurrentRecipeIndex(int currentRecipeIndex) {
        if (currentRecipeIndex < 0 || currentRecipeIndex >= 3) {
            currentRecipeIndex = 0;
        }
        this.currentRecipeIndex = currentRecipeIndex;
        AdvancedAutoCrafterBlockEntity.setChanged((Level)this.level, (BlockPos)this.getBlockPos(), (BlockState)this.getBlockState());
    }

    public void setIgnoreNBT(boolean ignoreNBT) {
        this.ignoreNBT[this.currentRecipeIndex] = ignoreNBT;
        this.updateRecipe(this.currentRecipeIndex);
        AdvancedAutoCrafterBlockEntity.setChanged((Level)this.level, (BlockPos)this.getBlockPos(), (BlockState)this.getBlockState());
    }

    public void setSecondaryExtractMode(boolean secondaryExtractMode) {
        this.secondaryExtractMode = secondaryExtractMode;
        AdvancedAutoCrafterBlockEntity.setChanged((Level)this.level, (BlockPos)this.getBlockPos(), (BlockState)this.getBlockState());
    }

    public void setAllowOutputOverflow(boolean allowOutputOverflow) {
        this.allowOutputOverflow = allowOutputOverflow;
        AdvancedAutoCrafterBlockEntity.setChanged((Level)this.level, (BlockPos)this.getBlockPos(), (BlockState)this.getBlockState());
    }

    @Override
    public void setCheckbox(int checkboxId, boolean checked) {
        switch (checkboxId) {
            case 0: {
                this.setIgnoreNBT(checked);
                break;
            }
            case 1: {
                this.setSecondaryExtractMode(checked);
                break;
            }
            case 2: {
                this.setAllowOutputOverflow(checked);
            }
        }
    }
}

