/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import me.jddev0.ep.block.entity.TransformerBlockEntity;
import me.jddev0.ep.machine.tier.TransformerTier;
import me.jddev0.ep.machine.tier.TransformerType;
import me.jddev0.ep.util.EnergyUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class TransformerBlock
extends BaseEntityBlock {
    public static final MapCodec<TransformerBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TransformerBlock.propertiesCodec(), (App)ExtraCodecs.NON_EMPTY_STRING.xmap(TransformerTier::valueOf, Enum::toString).fieldOf("tier").forGetter(TransformerBlock::getTier), (App)ExtraCodecs.NON_EMPTY_STRING.xmap(TransformerType::valueOf, Enum::toString).fieldOf("transformer_type").forGetter(TransformerBlock::getTransformerType)).apply((Applicative)instance, TransformerBlock::new));
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    private final TransformerTier tier;
    private final TransformerType type;

    protected TransformerBlock(BlockBehaviour.Properties props, TransformerTier tier, TransformerType type) {
        super(props);
        this.tier = tier;
        this.type = type;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public TransformerTier getTier() {
        return this.tier;
    }

    public TransformerType getTransformerType() {
        return this.type;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState state) {
        return new TransformerBlockEntity(blockPos, state, this.tier, this.type);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos blockPos, Player player, BlockHitResult hit) {
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (!(blockEntity instanceof TransformerBlockEntity) || ((TransformerBlockEntity)blockEntity).getTier() != this.tier || ((TransformerBlockEntity)blockEntity).getTransformerType() != this.type) {
            throw new IllegalStateException("Container is invalid");
        }
        player.openMenu((MenuProvider)((TransformerBlockEntity)blockEntity), blockPos);
        return InteractionResult.SUCCESS;
    }

    public void neighborChanged(BlockState selfState, Level level, BlockPos selfPos, Block fromBlock, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(selfState, level, selfPos, fromBlock, fromPos, isMoving);
        if (level.isClientSide()) {
            return;
        }
        boolean isPowered = level.hasNeighborSignal(selfPos);
        if (isPowered != (Boolean)selfState.getValue((Property)POWERED)) {
            level.setBlock(selfPos, (BlockState)selfState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(isPowered)), 3);
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getNearestLookingDirection().getOpposite())).setValue((Property)POWERED, (Comparable)Boolean.valueOf(context.getLevel().hasNeighborSignal(context.getClickedPos())));
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{POWERED, FACING});
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return TransformerBlock.createTickerHelper(type, this.tier.getEntityTypeFromTierAndType(this.type), TransformerBlockEntity::tick);
    }

    public static class Item
    extends BlockItem {
        private final TransformerTier tier;
        private final TransformerType type;

        public Item(Block block, Item.Properties props, TransformerTier tier, TransformerType type) {
            super(block, props);
            this.tier = tier;
            this.type = type;
        }

        public TransformerTier getTier() {
            return this.tier;
        }

        public TransformerType getTransformerType() {
            return this.type;
        }

        public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
            if (Screen.hasShiftDown()) {
                components.add((Component)Component.translatable((String)"tooltip.energizedpower.transfer_rate.txt", (Object[])new Object[]{EnergyUtils.getEnergyWithPrefix(this.tier.getMaxEnergyTransferFromTier())}).withStyle(ChatFormatting.GRAY));
                components.add((Component)Component.empty());
                components.add((Component)Component.translatable((String)"tooltip.energizedpower.transformer.txt.shift.1").withStyle(ChatFormatting.GRAY));
                components.add((Component)Component.translatable((String)"tooltip.energizedpower.transformer.txt.shift.2").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
                components.add((Component)Component.translatable((String)"tooltip.energizedpower.transformer.txt.shift.3").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            } else {
                components.add((Component)Component.translatable((String)"tooltip.energizedpower.shift_details.txt").withStyle(ChatFormatting.YELLOW));
            }
        }
    }
}

