/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import me.jddev0.ep.block.EPBlockStateProperties;
import me.jddev0.ep.block.WrenchConfigurable;
import me.jddev0.ep.block.entity.FluidPipeBlockEntity;
import me.jddev0.ep.machine.tier.FluidPipeTier;
import me.jddev0.ep.util.FluidUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidPipeBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock,
WrenchConfigurable {
    public static final MapCodec<FluidPipeBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.NON_EMPTY_STRING.xmap(FluidPipeTier::valueOf, Enum::toString).fieldOf("tier").forGetter(FluidPipeBlock::getTier)).apply((Applicative)instance, FluidPipeBlock::new));
    public static final EnumProperty<EPBlockStateProperties.PipeConnection> UP = EPBlockStateProperties.PIPE_CONNECTION_UP;
    public static final EnumProperty<EPBlockStateProperties.PipeConnection> DOWN = EPBlockStateProperties.PIPE_CONNECTION_DOWN;
    public static final EnumProperty<EPBlockStateProperties.PipeConnection> NORTH = EPBlockStateProperties.PIPE_CONNECTION_NORTH;
    public static final EnumProperty<EPBlockStateProperties.PipeConnection> SOUTH = EPBlockStateProperties.PIPE_CONNECTION_SOUTH;
    public static final EnumProperty<EPBlockStateProperties.PipeConnection> EAST = EPBlockStateProperties.PIPE_CONNECTION_EAST;
    public static final EnumProperty<EPBlockStateProperties.PipeConnection> WEST = EPBlockStateProperties.PIPE_CONNECTION_WEST;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape SHAPE_CORE = Block.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    private static final VoxelShape SHAPE_UP = Block.box((double)4.0, (double)12.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape SHAPE_DOWN = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0);
    private static final VoxelShape SHAPE_NORTH = Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)4.0);
    private static final VoxelShape SHAPE_SOUTH = Block.box((double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0, (double)16.0);
    private static final VoxelShape SHAPE_EAST = Block.box((double)12.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
    private static final VoxelShape SHAPE_WEST = Block.box((double)0.0, (double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0);
    private final FluidPipeTier tier;

    @NotNull
    public static EnumProperty<EPBlockStateProperties.PipeConnection> getPipeConnectionPropertyFromDirection(@NotNull Direction dir) {
        return switch (dir) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> UP;
            case Direction.DOWN -> DOWN;
            case Direction.NORTH -> NORTH;
            case Direction.SOUTH -> SOUTH;
            case Direction.EAST -> EAST;
            case Direction.WEST -> WEST;
        };
    }

    public FluidPipeBlock(FluidPipeTier tier) {
        super(tier.getProperties());
        this.tier = tier;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(UP, (Comparable)((Object)EPBlockStateProperties.PipeConnection.NOT_CONNECTED))).setValue(DOWN, (Comparable)((Object)EPBlockStateProperties.PipeConnection.NOT_CONNECTED))).setValue(NORTH, (Comparable)((Object)EPBlockStateProperties.PipeConnection.NOT_CONNECTED))).setValue(SOUTH, (Comparable)((Object)EPBlockStateProperties.PipeConnection.NOT_CONNECTED))).setValue(EAST, (Comparable)((Object)EPBlockStateProperties.PipeConnection.NOT_CONNECTED))).setValue(WEST, (Comparable)((Object)EPBlockStateProperties.PipeConnection.NOT_CONNECTED))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public FluidPipeTier getTier() {
        return this.tier;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState state) {
        return new FluidPipeBlockEntity(blockPos, state, this.tier);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Override
    @NotNull
    public InteractionResult onUseWrench(UseOnContext useOnContext, Direction selectedFace, boolean nextPreviousValue) {
        Level level = useOnContext.getLevel();
        BlockPos blockPos = useOnContext.getClickedPos();
        if (level.isClientSide || !(level.getBlockEntity(blockPos) instanceof FluidPipeBlockEntity)) {
            return InteractionResult.SUCCESS;
        }
        BlockState state = level.getBlockState(blockPos);
        BlockPos testPos = blockPos.relative(selectedFace);
        Player player = useOnContext.getPlayer();
        BlockEntity testBlockEntity = level.getBlockEntity(testPos);
        if (testBlockEntity instanceof FluidPipeBlockEntity) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"tooltip.energizedpower.fluid_pipe.wrench_configuration.face_change_not_possible", (Object[])new Object[]{Component.translatable((String)("tooltip.energizedpower.direction." + selectedFace.getSerializedName())).withStyle(ChatFormatting.WHITE)}).withStyle(ChatFormatting.RED)));
            }
            return InteractionResult.SUCCESS;
        }
        IFluidHandler fluidStorage = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, testPos, level.getBlockState(testPos), testBlockEntity, (Object)selectedFace.getOpposite());
        if (fluidStorage == null) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"tooltip.energizedpower.fluid_pipe.wrench_configuration.face_change_not_possible", (Object[])new Object[]{Component.translatable((String)("tooltip.energizedpower.direction." + selectedFace.getSerializedName())).withStyle(ChatFormatting.WHITE)}).withStyle(ChatFormatting.RED)));
            }
            return InteractionResult.SUCCESS;
        }
        if (fluidStorage.getTanks() == 0) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"tooltip.energizedpower.fluid_pipe.wrench_configuration.face_change_not_possible", (Object[])new Object[]{Component.translatable((String)("tooltip.energizedpower.direction." + selectedFace.getSerializedName())).withStyle(ChatFormatting.WHITE)}).withStyle(ChatFormatting.RED)));
            }
            return InteractionResult.SUCCESS;
        }
        EnumProperty<EPBlockStateProperties.PipeConnection> pipeConnectionProperty = FluidPipeBlock.getPipeConnectionPropertyFromDirection(selectedFace);
        int diff = nextPreviousValue ? -1 : 1;
        EPBlockStateProperties.PipeConnection pipeConnection = (EPBlockStateProperties.PipeConnection)((Object)state.getValue(pipeConnectionProperty));
        pipeConnection = EPBlockStateProperties.PipeConnection.values()[(pipeConnection.ordinal() + diff + EPBlockStateProperties.PipeConnection.values().length) % EPBlockStateProperties.PipeConnection.values().length];
        level.setBlock(blockPos, (BlockState)state.setValue(pipeConnectionProperty, (Comparable)((Object)pipeConnection)), 3);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"tooltip.energizedpower.fluid_pipe.wrench_configuration.face_changed", (Object[])new Object[]{Component.translatable((String)("tooltip.energizedpower.direction." + selectedFace.getSerializedName())).withStyle(ChatFormatting.WHITE), Component.translatable((String)pipeConnection.getTranslationKey()).withStyle(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.BOLD})}).withStyle(ChatFormatting.GREEN)));
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext blockPlaceContext) {
        Level level = blockPlaceContext.getLevel();
        BlockPos selfPos = blockPlaceContext.getClickedPos();
        FluidState fluidState = level.getFluidState(selfPos);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(UP, (Comparable)((Object)this.shouldConnectTo(level, selfPos, this.defaultBlockState(), Direction.UP)))).setValue(DOWN, (Comparable)((Object)this.shouldConnectTo(level, selfPos, this.defaultBlockState(), Direction.DOWN)))).setValue(NORTH, (Comparable)((Object)this.shouldConnectTo(level, selfPos, this.defaultBlockState(), Direction.NORTH)))).setValue(SOUTH, (Comparable)((Object)this.shouldConnectTo(level, selfPos, this.defaultBlockState(), Direction.SOUTH)))).setValue(EAST, (Comparable)((Object)this.shouldConnectTo(level, selfPos, this.defaultBlockState(), Direction.EAST)))).setValue(WEST, (Comparable)((Object)this.shouldConnectTo(level, selfPos, this.defaultBlockState(), Direction.WEST)))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)state.getValue(WEST)))))).setValue(SOUTH, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)state.getValue(EAST)))))).setValue(EAST, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)state.getValue(NORTH)))))).setValue(WEST, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)state.getValue(SOUTH)))));
            }
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)state.getValue(SOUTH)))))).setValue(SOUTH, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)state.getValue(NORTH)))))).setValue(EAST, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)state.getValue(WEST)))))).setValue(WEST, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)state.getValue(EAST)))));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)state.getValue(EAST)))))).setValue(SOUTH, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)state.getValue(WEST)))))).setValue(EAST, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)state.getValue(SOUTH)))))).setValue(WEST, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)state.getValue(NORTH)))));
            }
        }
        return state;
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.setValue(NORTH, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)state.getValue(SOUTH)))))).setValue(SOUTH, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)state.getValue(NORTH)))));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.setValue(EAST, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)state.getValue(WEST)))))).setValue(WEST, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)state.getValue(EAST)))));
            }
        }
        return state;
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        VoxelShape shape = SHAPE_CORE;
        if (((EPBlockStateProperties.PipeConnection)((Object)blockState.getValue(UP))).isConnected()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)SHAPE_UP);
        }
        if (((EPBlockStateProperties.PipeConnection)((Object)blockState.getValue(DOWN))).isConnected()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)SHAPE_DOWN);
        }
        if (((EPBlockStateProperties.PipeConnection)((Object)blockState.getValue(NORTH))).isConnected()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)SHAPE_NORTH);
        }
        if (((EPBlockStateProperties.PipeConnection)((Object)blockState.getValue(SOUTH))).isConnected()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)SHAPE_SOUTH);
        }
        if (((EPBlockStateProperties.PipeConnection)((Object)blockState.getValue(EAST))).isConnected()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)SHAPE_EAST);
        }
        if (((EPBlockStateProperties.PipeConnection)((Object)blockState.getValue(WEST))).isConnected()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)SHAPE_WEST);
        }
        return shape;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos selfPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(selfPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, facing, facingState, level, selfPos, facingPos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{UP}).add(new Property[]{DOWN}).add(new Property[]{NORTH}).add(new Property[]{SOUTH}).add(new Property[]{EAST}).add(new Property[]{WEST}).add(new Property[]{WATERLOGGED});
    }

    public void neighborChanged(BlockState selfState, Level level, BlockPos selfPos, Block fromBlock, BlockPos fromPos, boolean isMoving) {
        BlockState newState;
        int dz;
        int dy;
        super.neighborChanged(selfState, level, selfPos, fromBlock, fromPos, isMoving);
        if (level.isClientSide()) {
            return;
        }
        FluidState fluidState = level.getFluidState(selfPos);
        int dx = fromPos.getX() - selfPos.getX();
        Direction dir = Direction.fromDelta((int)dx, (int)(dy = fromPos.getY() - selfPos.getY()), (int)(dz = fromPos.getZ() - selfPos.getZ()));
        if (dir == null) {
            newState = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(UP, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)selfState.getValue(UP)))))).setValue(DOWN, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)selfState.getValue(DOWN)))))).setValue(NORTH, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)selfState.getValue(NORTH)))))).setValue(SOUTH, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)selfState.getValue(SOUTH)))))).setValue(EAST, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)selfState.getValue(EAST)))))).setValue(WEST, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)selfState.getValue(WEST)))))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
        } else {
            EnumProperty<EPBlockStateProperties.PipeConnection> pipeConnectionProperty = FluidPipeBlock.getPipeConnectionPropertyFromDirection(dir);
            newState = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(UP, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)selfState.getValue(UP)))))).setValue(DOWN, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)selfState.getValue(DOWN)))))).setValue(NORTH, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)selfState.getValue(NORTH)))))).setValue(SOUTH, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)selfState.getValue(SOUTH)))))).setValue(EAST, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)selfState.getValue(EAST)))))).setValue(WEST, (Comparable)((Object)((EPBlockStateProperties.PipeConnection)((Object)selfState.getValue(WEST)))))).setValue(pipeConnectionProperty, (Comparable)((Object)this.shouldConnectTo(level, selfPos, selfState, dir)))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
        }
        level.setBlockAndUpdate(selfPos, newState);
        BlockEntity blockEntity = level.getBlockEntity(selfPos);
        if (blockEntity == null || !(blockEntity instanceof FluidPipeBlockEntity)) {
            return;
        }
        FluidPipeBlockEntity.updateConnections(level, selfPos, newState, (FluidPipeBlockEntity)blockEntity);
    }

    private EPBlockStateProperties.PipeConnection shouldConnectTo(Level level, BlockPos selfPos, BlockState selfState, Direction direction) {
        IFluidHandler fluidStorage;
        FluidPipeBlockEntity fluidPipeBlockEntity;
        BlockPos toPos = selfPos.relative(direction);
        BlockEntity blockEntity = level.getBlockEntity(toPos);
        if (blockEntity instanceof FluidPipeBlockEntity && (fluidPipeBlockEntity = (FluidPipeBlockEntity)blockEntity).getTier() != this.getTier()) {
            return EPBlockStateProperties.PipeConnection.NOT_CONNECTED;
        }
        EPBlockStateProperties.PipeConnection currentConnectionState = (EPBlockStateProperties.PipeConnection)((Object)selfState.getValue(FluidPipeBlock.getPipeConnectionPropertyFromDirection(direction)));
        if (currentConnectionState == EPBlockStateProperties.PipeConnection.NOT_CONNECTED) {
            currentConnectionState = EPBlockStateProperties.PipeConnection.CONNECTED;
        }
        return (fluidStorage = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, toPos, level.getBlockState(toPos), blockEntity, (Object)direction.getOpposite())) == null ? EPBlockStateProperties.PipeConnection.NOT_CONNECTED : currentConnectionState;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return FluidPipeBlock.createTickerHelper(type, this.tier.getEntityTypeFromTier(), FluidPipeBlockEntity::tick);
    }

    public static class Item
    extends BlockItem {
        private final FluidPipeTier tier;

        public Item(Block block, Item.Properties props, FluidPipeTier tier) {
            super(block, props);
            this.tier = tier;
        }

        public FluidPipeTier getTier() {
            return this.tier;
        }

        public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
            if (Screen.hasShiftDown()) {
                components.add((Component)Component.translatable((String)"tooltip.energizedpower.wrench_configurable").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
                components.add((Component)Component.translatable((String)"tooltip.energizedpower.fluid_pipe.max_extraction", (Object[])new Object[]{FluidUtils.getFluidAmountWithPrefix(this.tier.getTransferRate())}).withStyle(ChatFormatting.GRAY));
            } else {
                components.add((Component)Component.translatable((String)"tooltip.energizedpower.shift_details.txt").withStyle(ChatFormatting.YELLOW));
            }
        }
    }
}

