/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import me.jddev0.ep.block.entity.CableBlockEntity;
import me.jddev0.ep.machine.tier.CableTier;
import me.jddev0.ep.util.EnergyUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class CableBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<CableBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.NON_EMPTY_STRING.xmap(CableTier::valueOf, Enum::toString).fieldOf("tier").forGetter(CableBlock::getTier)).apply((Applicative)instance, CableBlock::new));
    public static final BooleanProperty UP = BlockStateProperties.UP;
    public static final BooleanProperty DOWN = BlockStateProperties.DOWN;
    public static final BooleanProperty NORTH = BlockStateProperties.NORTH;
    public static final BooleanProperty SOUTH = BlockStateProperties.SOUTH;
    public static final BooleanProperty EAST = BlockStateProperties.EAST;
    public static final BooleanProperty WEST = BlockStateProperties.WEST;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape SHAPE_CORE = Block.box((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape SHAPE_UP = Block.box((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape SHAPE_DOWN = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);
    private static final VoxelShape SHAPE_NORTH = Block.box((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)6.0);
    private static final VoxelShape SHAPE_SOUTH = Block.box((double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0, (double)16.0);
    private static final VoxelShape SHAPE_EAST = Block.box((double)10.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    private static final VoxelShape SHAPE_WEST = Block.box((double)0.0, (double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0);
    private final CableTier tier;

    public CableBlock(CableTier tier) {
        super(tier.getProperties());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.tier = tier;
    }

    public CableTier getTier() {
        return this.tier;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext blockPlaceContext) {
        Level level = blockPlaceContext.getLevel();
        BlockPos selfPos = blockPlaceContext.getClickedPos();
        FluidState fluidState = level.getFluidState(selfPos);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)UP, (Comparable)Boolean.valueOf(this.shouldConnectTo(level, selfPos, Direction.UP)))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(this.shouldConnectTo(level, selfPos, Direction.DOWN)))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(this.shouldConnectTo(level, selfPos, Direction.NORTH)))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(this.shouldConnectTo(level, selfPos, Direction.SOUTH)))).setValue((Property)EAST, (Comparable)Boolean.valueOf(this.shouldConnectTo(level, selfPos, Direction.EAST)))).setValue((Property)WEST, (Comparable)Boolean.valueOf(this.shouldConnectTo(level, selfPos, Direction.WEST)))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)EAST)))).setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)NORTH)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)SOUTH)));
            }
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)NORTH)))).setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)EAST)));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)EAST)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)NORTH)));
            }
        }
        return state;
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)NORTH)));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)EAST)));
            }
        }
        return state;
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        VoxelShape shape = SHAPE_CORE;
        if (((Boolean)blockState.getValue((Property)UP)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)SHAPE_UP);
        }
        if (((Boolean)blockState.getValue((Property)DOWN)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)SHAPE_DOWN);
        }
        if (((Boolean)blockState.getValue((Property)NORTH)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)SHAPE_NORTH);
        }
        if (((Boolean)blockState.getValue((Property)SOUTH)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)SHAPE_SOUTH);
        }
        if (((Boolean)blockState.getValue((Property)EAST)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)SHAPE_EAST);
        }
        if (((Boolean)blockState.getValue((Property)WEST)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)SHAPE_WEST);
        }
        return shape;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos selfPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(selfPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, facing, facingState, level, selfPos, facingPos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{UP}).add(new Property[]{DOWN}).add(new Property[]{NORTH}).add(new Property[]{SOUTH}).add(new Property[]{EAST}).add(new Property[]{WEST}).add(new Property[]{WATERLOGGED});
    }

    public void neighborChanged(BlockState selfState, Level level, BlockPos selfPos, Block fromBlock, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(selfState, level, selfPos, fromBlock, fromPos, isMoving);
        if (level.isClientSide()) {
            return;
        }
        FluidState fluidState = level.getFluidState(selfPos);
        BlockState newState = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)UP, (Comparable)Boolean.valueOf(this.shouldConnectTo(level, selfPos, Direction.UP)))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(this.shouldConnectTo(level, selfPos, Direction.DOWN)))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(this.shouldConnectTo(level, selfPos, Direction.NORTH)))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(this.shouldConnectTo(level, selfPos, Direction.SOUTH)))).setValue((Property)EAST, (Comparable)Boolean.valueOf(this.shouldConnectTo(level, selfPos, Direction.EAST)))).setValue((Property)WEST, (Comparable)Boolean.valueOf(this.shouldConnectTo(level, selfPos, Direction.WEST)))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
        level.setBlockAndUpdate(selfPos, newState);
        BlockEntity blockEntity = level.getBlockEntity(selfPos);
        if (!(blockEntity instanceof CableBlockEntity)) {
            return;
        }
        CableBlockEntity.updateConnections(level, selfPos, newState, (CableBlockEntity)blockEntity);
    }

    private boolean shouldConnectTo(Level level, BlockPos selfPos, Direction direction) {
        CableBlockEntity cableBlockEntity;
        BlockPos toPos = selfPos.relative(direction);
        BlockEntity blockEntity = level.getBlockEntity(toPos);
        if (blockEntity instanceof CableBlockEntity && (cableBlockEntity = (CableBlockEntity)blockEntity).getTier() != this.getTier()) {
            return false;
        }
        IEnergyStorage energyStorage = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, toPos, level.getBlockState(toPos), blockEntity, (Object)direction.getOpposite());
        return energyStorage != null;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState state) {
        return new CableBlockEntity(blockPos, state, this.tier);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return CableBlock.createTickerHelper(type, this.tier.getEntityTypeFromTier(), CableBlockEntity::tick);
    }

    public static enum EnergyExtractionMode {
        PUSH,
        PULL,
        BOTH;


        public boolean isPush() {
            return this == PUSH || this == BOTH;
        }

        public boolean isPull() {
            return this == PULL || this == BOTH;
        }
    }

    public static class Item
    extends BlockItem {
        private final CableTier tier;

        public Item(Block block, Item.Properties props, CableTier tier) {
            super(block, props);
            this.tier = tier;
        }

        public CableTier getTier() {
            return this.tier;
        }

        public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
            if (Screen.hasShiftDown()) {
                components.add((Component)Component.translatable((String)"tooltip.energizedpower.cable.txt.shift.1", (Object[])new Object[]{EnergyUtils.getEnergyWithPrefix(this.tier.getMaxTransfer())}).withStyle(ChatFormatting.GRAY));
                components.add((Component)Component.translatable((String)"tooltip.energizedpower.cable.txt.shift.2").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            } else {
                components.add((Component)Component.translatable((String)"tooltip.energizedpower.shift_details.txt").withStyle(ChatFormatting.YELLOW));
            }
        }
    }
}

