/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils;

import com.darkere.crashutils.ClearItemTask;
import com.darkere.crashutils.ClientEvents;
import com.darkere.crashutils.CrashUtilCommands.EntityCommands.EntitiesCommands;
import com.darkere.crashutils.CrashUtilCommands.HelpCommand;
import com.darkere.crashutils.CrashUtilCommands.InventoryCommands.InventoryCommands;
import com.darkere.crashutils.CrashUtilCommands.ItemClearCommand;
import com.darkere.crashutils.CrashUtilCommands.LoadedChunksCommand;
import com.darkere.crashutils.CrashUtilCommands.MemoryCommand;
import com.darkere.crashutils.CrashUtilCommands.PlayerCommands.ActivityCommand;
import com.darkere.crashutils.CrashUtilCommands.PlayerCommands.TeleportCommand;
import com.darkere.crashutils.CrashUtilCommands.PlayerCommands.UnstuckCommand;
import com.darkere.crashutils.CrashUtilCommands.TileEntityCommands.TileEntitiesCommands;
import com.darkere.crashutils.DataStructures.PlayerActivityHistory;
import com.darkere.crashutils.MemoryChecker;
import com.darkere.crashutils.Network.Network;
import com.darkere.crashutils.ServerConfig;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="crashutilities")
public class CrashUtils {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "crashutilities";
    public static final ServerConfig SERVER_CONFIG = new ServerConfig();
    public static boolean curiosLoaded = false;
    Timer chunkcleaner;
    public static boolean sparkLoaded = false;
    public static List<Consumer<ServerLevel>> runnables = new CopyOnWriteArrayList<Consumer<ServerLevel>>();
    public static List<Runnable> runnablesClient = new CopyOnWriteArrayList<Runnable>();
    public static boolean skipNext = false;
    public static boolean skipNextClient = false;
    public static boolean isServer = false;

    public static ResourceLocation ResourceLocation(String Path2) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)Path2);
    }

    public CrashUtils(IEventBus ModEventBus, ModContainer modContainer) {
        ModEventBus.addListener(this::configReload);
        ModEventBus.addListener(Network::register);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            NeoForge.EVENT_BUS.register((Object)new ClientEvents());
            ModEventBus.addListener(ClientEvents::registerKeybindings);
        }
        NeoForge.EVENT_BUS.register((Object)this);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_CONFIG.getSpec());
        curiosLoaded = ModList.get().isLoaded("curios");
        sparkLoaded = ModList.get().isLoaded("spark");
    }

    public void configReload(ModConfigEvent.Reloading event) {
        ServerLevel world;
        MinecraftServer server;
        if (isServer) {
            ClearItemTask.restart();
            MemoryChecker.restart();
        }
        if ((server = ServerLifecycleHooks.getCurrentServer()) != null && (world = server.getLevel(Level.OVERWORLD)) != null) {
            this.setupFtbChunksUnloading(world);
        }
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        CommandNode<CommandSourceStack> entitiesCommands = EntitiesCommands.register();
        CommandNode<CommandSourceStack> tileEntitiesCommands = TileEntitiesCommands.register();
        CommandNode<CommandSourceStack> inventoryCommands = InventoryCommands.register();
        LiteralCommandNode cmd = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)MODID).requires(x -> x.hasPermission(2))).then(TeleportCommand.register())).then(UnstuckCommand.register())).then(MemoryCommand.register())).then(ItemClearCommand.register())).then(HelpCommand.register())).then(LoadedChunksCommand.register())).then(ActivityCommand.register())).then(entitiesCommands)).then(Commands.literal((String)"entities").redirect(entitiesCommands))).then(Commands.literal((String)"entity").redirect(entitiesCommands))).then(tileEntitiesCommands)).then(Commands.literal((String)"te").redirect(tileEntitiesCommands))).then(Commands.literal((String)"tileentities").redirect(tileEntitiesCommands))).then(Commands.literal((String)"tileentity").redirect(tileEntitiesCommands))).then(Commands.literal((String)"be").redirect(tileEntitiesCommands))).then(Commands.literal((String)"blockentities").redirect(tileEntitiesCommands))).then(inventoryCommands)).then(Commands.literal((String)"inventory").redirect(inventoryCommands)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"cu").requires(x -> x.hasPermission(2))).redirect((CommandNode)cmd));
    }

    @SubscribeEvent
    public void ServerStarted(ServerStartedEvent event) {
        isServer = true;
        ClearItemTask.start();
        MemoryChecker.start();
        this.setupFtbChunksUnloading(event.getServer().getLevel(Level.OVERWORLD));
    }

    private void setupFtbChunksUnloading(final ServerLevel world) {
        if (SERVER_CONFIG.shouldChunksExpire()) {
            this.chunkcleaner = new Timer(true);
            this.chunkcleaner.scheduleAtFixedRate(new TimerTask(this){

                @Override
                public void run() {
                    PlayerActivityHistory history = new PlayerActivityHistory(world);
                    LOGGER.info("Unloading chunks for players that have not been online in: " + SERVER_CONFIG.getExpireTimeInDays() + " Days");
                    LOGGER.info(history.getPlayersInChunkClearTime().size() + " Player(s) affected ");
                    for (String player : history.getPlayersInChunkClearTime()) {
                        LOGGER.info("Unloading " + player + "'s Chunks");
                        world.getServer().getCommands().performPrefixedCommand(world.getServer().createCommandSourceStack(), "ftbchunks unload_all " + player);
                    }
                }
            }, 5L, 3600000L);
        }
    }

    public static void runNextTick(Consumer<ServerLevel> run) {
        runnables.add(run);
    }

    public static void runInTwoTicks(Consumer<ServerLevel> run) {
        runnables.add(run);
        skipNext = true;
    }

    public static void runNextTickClient(Runnable run) {
        runnablesClient.add(run);
    }

    public static void runInTwoTicksClient(Runnable run) {
        runnablesClient.add(run);
        skipNextClient = true;
    }

    @SubscribeEvent
    public void onWorldTick(ServerTickEvent.Post event) {
        if (!runnables.isEmpty()) {
            if (skipNext) {
                skipNext = false;
                return;
            }
            ServerLevel level = event.getServer().getLevel(Level.OVERWORLD);
            runnables.forEach(c -> c.accept(level));
            runnables.clear();
        }
    }

    @SubscribeEvent
    public void onWorldTick(ClientTickEvent.Post event) {
        if (!runnables.isEmpty()) {
            if (skipNext) {
                skipNext = false;
                return;
            }
            runnablesClient.forEach(Runnable::run);
            runnablesClient.clear();
        }
    }
}

