/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block.teleporter;

import com.mojang.serialization.MapCodec;
import java.util.function.BiFunction;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.silentchaos512.gems.block.IGemBlock;
import net.silentchaos512.gems.block.teleporter.AbstractTeleporterBlock;
import net.silentchaos512.gems.util.Gems;

public class GemTeleporterBlock
extends AbstractTeleporterBlock
implements IGemBlock {
    protected final Gems gem;
    private final MapCodec<? extends GemTeleporterBlock> codec;

    public GemTeleporterBlock(Gems gem, BlockBehaviour.Properties properties) {
        this(gem, properties, GemTeleporterBlock::new);
    }

    public GemTeleporterBlock(Gems gem, BlockBehaviour.Properties properties, BiFunction<Gems, BlockBehaviour.Properties, ? extends GemTeleporterBlock> constructor) {
        super(properties, (BlockBehaviour.Properties p) -> new GemTeleporterBlock(gem, (BlockBehaviour.Properties)p));
        this.gem = gem;
        this.codec = GemTeleporterBlock.simpleCodec(p -> (GemTeleporterBlock)constructor.apply(gem, (BlockBehaviour.Properties)p));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public Gems getGem() {
        return this.gem;
    }

    @Override
    public MutableComponent getGemBlockName() {
        return Component.translatable((String)"block.silentgems.gem_teleporter", (Object[])new Object[]{this.gem.getDisplayName()});
    }

    @Override
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return this.codec;
    }
}

