/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.blazing.blocks;

import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.container.ItemInventory;
import mcjty.lib.api.power.ItemEnergy;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.setup.Registration;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.rftoolsbase.modules.various.VariousModule;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolspower.compat.RFToolsPowerTOPDriver;
import mcjty.rftoolspower.modules.blazing.BlazingConfiguration;
import mcjty.rftoolspower.modules.blazing.BlazingModule;
import mcjty.rftoolspower.modules.blazing.items.BlazingRod;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.Lazy;
import org.apache.commons.lang3.tuple.Pair;

public class BlazingInfuserTileEntity
extends TickingTileEntity {
    private static final int SLOT_INPUT = 0;
    private static final int SLOT_OUTPUT = 1;
    private static final int SLOT_CATALYST = 2;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(3).slot(SlotDefinition.specific((Item[])new Item[]{(Item)BlazingModule.BLAZING_ROD.get()}).in(), 0, 46, 7).slot(SlotDefinition.specific((Item[])new Item[]{(Item)BlazingModule.BLAZING_ROD.get()}).out(), 1, 100, 7).slot(SlotDefinition.specific(stack -> BlazingInfuserTileEntity.getCatalystImprovement(stack) != null).in(), 2, 46, 25).playerSlots(10, 70));
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)BlazingConfiguration.INFUSER_MAXENERGY.get()).intValue(), (long)((Integer)BlazingConfiguration.INFUSER_ENERGY_INPUT_PERTICK.get()).intValue());
    @Cap(type=CapType.ENERGY)
    private static final Function<BlazingInfuserTileEntity, GenericEnergyStorage> ENERGY_CAP = tile -> tile.energyStorage;
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).slotLimit(1).itemValid((slot, stack) -> switch (slot) {
        case 0, 1 -> {
            if (stack.getItem() == BlazingModule.BLAZING_ROD.get()) {
                yield true;
            }
            yield false;
        }
        case 2 -> {
            if (BlazingInfuserTileEntity.getCatalystImprovement(stack) != null) {
                yield true;
            }
            yield false;
        }
        default -> false;
    }).build();
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private static final Function<BlazingInfuserTileEntity, GenericItemHandler> ITEM_CAP = tile -> tile.items;
    @Cap(type=CapType.CONTAINER)
    private static final Function<BlazingInfuserTileEntity, MenuProvider> SCREEN_CAP = be -> new DefaultContainerProvider("Blazing Infuser").containerSupplier(DefaultContainerProvider.container(BlazingModule.CONTAINER_BLAZING_INFUSER, CONTAINER_FACTORY, (GenericTileEntity)be)).itemHandler(() -> be.items).energyHandler(() -> be.energyStorage).setupSync((GenericTileEntity)be);
    private int counter = 10;

    public BlazingInfuserTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlazingModule.BLAZING_INFUSER.be().get(), pos, state);
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().properties(BlockBehaviour.Properties.of().strength(2.0f).sound(SoundType.METAL)).topDriver((TOPDriver)RFToolsPowerTOPDriver.DRIVER).manualEntry(ManualHelper.create((String)"rftoolsbase:powergeneration/blazinginfuser")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolspower.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}).tileEntitySupplier(BlazingInfuserTileEntity::new));
    }

    protected void tickServer() {
        --this.counter;
        if (this.counter < 0) {
            this.counter = 10;
            ItemStack stack = this.items.getStackInSlot(0);
            if (stack.getItem() == BlazingModule.BLAZING_ROD.get()) {
                int steps = BlazingRod.getInfusionStepsLeft(stack);
                if (steps <= 0) {
                    if (this.items.getStackInSlot(1).isEmpty()) {
                        this.items.setStackInSlot(1, stack);
                        this.items.setStackInSlot(0, ItemStack.EMPTY);
                    }
                } else {
                    ItemStack catalyst = this.items.getStackInSlot(2);
                    if (!catalyst.isEmpty() && this.energyStorage.getEnergy() >= (long)((Integer)BlazingConfiguration.INFUSER_USE_PER_TICK.get()).intValue()) {
                        this.energyStorage.consumeEnergy((long)((Integer)BlazingConfiguration.INFUSER_USE_PER_TICK.get()).intValue());
                        BlazingRod.setInfusionStepsLeft(stack, --steps);
                        this.items.extractItem(2, 1, false);
                        this.infuse(stack, catalyst);
                        if (steps <= 0 && this.items.getStackInSlot(1).isEmpty()) {
                            this.items.setStackInSlot(1, stack);
                            this.items.setStackInSlot(0, ItemStack.EMPTY);
                        }
                    }
                }
            }
        }
        this.markDirtyQuick();
    }

    @Nullable
    private static Pair<Float, Float> getCatalystImprovement(ItemStack stack) {
        if (stack.getItem() == Items.REDSTONE) {
            return Pair.of((Object)Float.valueOf(40.0f), (Object)Float.valueOf(0.0f));
        }
        if (stack.getItem() == Items.GLOWSTONE_DUST) {
            return Pair.of((Object)Float.valueOf(10.0f), (Object)Float.valueOf(30.0f));
        }
        if (stack.getItem() == Items.QUARTZ) {
            return Pair.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(40.0f));
        }
        if (stack.getItem() == VariousModule.DIMENSIONALSHARD.get()) {
            return Pair.of((Object)Float.valueOf(60.0f), (Object)Float.valueOf(60.0f));
        }
        if (stack.getItem() == Items.NETHER_STAR) {
            return Pair.of((Object)Float.valueOf(120.0f), (Object)Float.valueOf(120.0f));
        }
        if (stack.getItem() == Items.GHAST_TEAR) {
            return Pair.of((Object)Float.valueOf(80.0f), (Object)Float.valueOf(80.0f));
        }
        return null;
    }

    private void infuse(ItemStack stack, ItemStack catalyst) {
        Pair<Float, Float> pair = BlazingInfuserTileEntity.getCatalystImprovement(catalyst);
        if (pair != null) {
            this.improveQuality(stack, ((Float)pair.getLeft()).floatValue());
            this.improveDuration(stack, ((Float)pair.getRight()).floatValue());
        }
    }

    private void improveDuration(ItemStack stack, float factor) {
        float duration = BlazingRod.getPowerDuration(stack);
        duration += duration * factor / 6400.0f;
        BlazingRod.setPowerDuration(stack, duration);
    }

    private void improveQuality(ItemStack stack, float factor) {
        float quality = BlazingRod.getPowerQuality(stack);
        quality += quality * factor / 6400.0f;
        BlazingRod.setPowerQuality(stack, quality);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.energyStorage.load(tag, "energy", provider);
        this.items.load(tag, "items", provider);
    }

    public void saveAdditional(@Nonnull CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        this.energyStorage.save(tag, "energy", provider);
        this.items.save(tag, "items", provider);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.energyStorage.applyImplicitComponents((ItemEnergy)input.get((Supplier)Registration.ITEM_ENERGY));
        this.items.applyImplicitComponents((ItemInventory)input.get((Supplier)Registration.ITEM_INVENTORY));
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        this.energyStorage.collectImplicitComponents(builder);
        this.items.collectImplicitComponents(builder);
    }
}

