/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.blazing;

import java.util.ArrayList;
import java.util.function.Supplier;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RBlock;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.datagen.DataGen;
import mcjty.lib.datagen.Dob;
import mcjty.lib.modules.IModule;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolsbase.modules.various.VariousModule;
import mcjty.rftoolspower.RFToolsPower;
import mcjty.rftoolspower.modules.blazing.BlazingConfiguration;
import mcjty.rftoolspower.modules.blazing.blocks.BlazingAgitatorTileEntity;
import mcjty.rftoolspower.modules.blazing.blocks.BlazingGeneratorTileEntity;
import mcjty.rftoolspower.modules.blazing.blocks.BlazingInfuserTileEntity;
import mcjty.rftoolspower.modules.blazing.client.BlazingAgitatorRenderer;
import mcjty.rftoolspower.modules.blazing.client.GuiBlazingAgitator;
import mcjty.rftoolspower.modules.blazing.client.GuiBlazingGenerator;
import mcjty.rftoolspower.modules.blazing.client.GuiBlazingInfuser;
import mcjty.rftoolspower.modules.blazing.data.AgitatorData;
import mcjty.rftoolspower.modules.blazing.data.BlazingRodData;
import mcjty.rftoolspower.modules.blazing.items.BlazingRod;
import mcjty.rftoolspower.setup.Config;
import mcjty.rftoolspower.setup.Registration;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;

public class BlazingModule
implements IModule {
    public static final RBlock<BaseBlock, BlockItem, BlazingGeneratorTileEntity> BLAZING_GENERATOR = Registration.RBLOCKS.registerBlock("blazing_generator", BlazingGeneratorTileEntity.class, BlazingGeneratorTileEntity::createBlock, block -> new BlockItem((Block)block.get(), Registration.createStandardProperties()), BlazingGeneratorTileEntity::new);
    public static final Supplier<MenuType<GenericContainer>> CONTAINER_BLAZING_GENERATOR = Registration.CONTAINERS.register("blazing_generator", GenericContainer::createContainerType);
    public static final RBlock<BaseBlock, BlockItem, BlazingAgitatorTileEntity> BLAZING_AGITATOR = Registration.RBLOCKS.registerBlock("blazing_agitator", BlazingAgitatorTileEntity.class, BlazingAgitatorTileEntity::createBlock, block -> new BlockItem((Block)block.get(), Registration.createStandardProperties()), BlazingAgitatorTileEntity::new);
    public static final Supplier<MenuType<GenericContainer>> CONTAINER_BLAZING_AGITATOR = Registration.CONTAINERS.register("blazing_agitator", GenericContainer::createContainerType);
    public static final RBlock<BaseBlock, BlockItem, BlazingInfuserTileEntity> BLAZING_INFUSER = Registration.RBLOCKS.registerBlock("blazing_infuser", BlazingInfuserTileEntity.class, BlazingInfuserTileEntity::createBlock, block -> new BlockItem((Block)block.get(), Registration.createStandardProperties()), BlazingInfuserTileEntity::new);
    public static final Supplier<MenuType<GenericContainer>> CONTAINER_BLAZING_INFUSER = Registration.CONTAINERS.register("blazing_infuser", GenericContainer::createContainerType);
    public static final DeferredItem<BlazingRod> BLAZING_ROD = Registration.ITEMS.register("blazing_rod", RFToolsPower.tab(BlazingRod::new));
    public static final Supplier<AttachmentType<AgitatorData>> AGITATOR_DATA = Registration.ATTACHMENT_TYPES.register("agitator_data", () -> AttachmentType.builder(() -> new AgitatorData(new ArrayList<Boolean>())).serialize(AgitatorData.CODEC).build());
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<AgitatorData>> ITEM_AGITATOR_DATA = Registration.COMPONENTS.registerComponentType("agitator_data", builder -> builder.persistent(AgitatorData.CODEC).networkSynchronized(AgitatorData.STREAM_CODEC));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<BlazingRodData>> ITEM_BLAZING_ROD_DATA = Registration.COMPONENTS.registerComponentType("blazing_rod_data", builder -> builder.persistent(BlazingRodData.CODEC).networkSynchronized(BlazingRodData.STREAM_CODEC));

    public BlazingModule(IEventBus bus) {
        bus.addListener(this::registerScreens);
    }

    public void init(FMLCommonSetupEvent event) {
    }

    public void initClient(FMLClientSetupEvent event) {
        BlazingAgitatorRenderer.register();
    }

    public void registerScreens(RegisterMenuScreensEvent event) {
        GuiBlazingAgitator.register(event);
        GuiBlazingGenerator.register(event);
        GuiBlazingInfuser.register(event);
    }

    public void initConfig(IEventBus bus) {
        BlazingConfiguration.setup(Config.SERVER_BUILDER, Config.CLIENT_BUILDER);
    }

    public void initDatagen(DataGen dataGen, HolderLookup.Provider provider) {
        dataGen.add(new Dob.Builder[]{Dob.blockBuilder(BLAZING_AGITATOR).ironPickaxeTags().standardLoot(new DataComponentType[]{(DataComponentType)ITEM_AGITATOR_DATA.get(), (DataComponentType)mcjty.lib.setup.Registration.ITEM_INFUSABLE.get()}).blockState(p -> p.simpleBlock((Block)BLAZING_AGITATOR.block().get(), (ModelFile)p.models().slab("blazing_agitator", p.modLoc("block/blazing/blazing_agitator_side"), ResourceLocation.fromNamespaceAndPath((String)"rftoolsbase", (String)"block/base/machinebottom"), ResourceLocation.fromNamespaceAndPath((String)"rftoolsbase", (String)"block/base/machinetop")))).shaped(builder -> builder.define(Character.valueOf('F'), (ItemLike)VariousModule.MACHINE_FRAME.get()).define(Character.valueOf('X'), Tags.Items.RODS_BLAZE).unlockedBy("frame", DataGen.has((ItemLike)((ItemLike)VariousModule.MACHINE_FRAME.get()))), new String[]{"XXX", "GFG", "iii"}), Dob.blockBuilder(BLAZING_GENERATOR).ironPickaxeTags().standardLoot(new DataComponentType[]{(DataComponentType)mcjty.lib.setup.Registration.ITEM_INFUSABLE.get()}).blockState(p -> {
            ModelFile modelIdle = p.frontBasedModel("blazing_generator_idle", p.modLoc("block/blazing/blazing_generator_idle"));
            ModelFile modelBusy = p.frontBasedModel("blazing_generator_busy", p.modLoc("block/blazing/blazing_generator_busy"));
            VariantBlockStateBuilder builder = p.getVariantBuilder((Block)BLAZING_GENERATOR.block().get());
            for (Direction direction : OrientationTools.DIRECTION_VALUES) {
                p.applyRotation(builder.partialState().with((Property)BlockStateProperties.FACING, (Comparable)direction).with((Property)BlazingGeneratorTileEntity.WORKING, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(modelIdle), direction);
                p.applyRotation(builder.partialState().with((Property)BlockStateProperties.FACING, (Comparable)direction).with((Property)BlazingGeneratorTileEntity.WORKING, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(modelBusy), direction);
            }
        }).shaped(builder -> builder.define(Character.valueOf('F'), (ItemLike)VariousModule.MACHINE_FRAME.get()).define(Character.valueOf('X'), Tags.Items.RODS_BLAZE).define(Character.valueOf('Y'), (ItemLike)VariousModule.INFUSED_DIAMOND.get()).unlockedBy("frame", DataGen.has((ItemLike)((ItemLike)VariousModule.MACHINE_FRAME.get()))), new String[]{"XYX", "RFR", "XYX"}), Dob.blockBuilder(BLAZING_INFUSER).ironPickaxeTags().standardLoot(new DataComponentType[0]).blockState(p -> p.orientedBlock((Block)BLAZING_INFUSER.block().get(), p.frontBasedModel("blazing_infuser", p.modLoc("block/blazing/blazing_infuser")))).shaped(builder -> builder.define(Character.valueOf('F'), (ItemLike)VariousModule.MACHINE_FRAME.get()).define(Character.valueOf('s'), (ItemLike)VariousModule.DIMENSIONALSHARD.get()).define(Character.valueOf('X'), Tags.Items.RODS_BLAZE).unlockedBy("frame", DataGen.has((ItemLike)((ItemLike)VariousModule.MACHINE_FRAME.get()))), new String[]{"iXi", "sFs", "iXi"})});
    }
}

