/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalcustomization.modify;

import com.blakebr0.mysticalagriculture.api.MysticalAgricultureAPI;
import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.api.crop.CropRecipes;
import com.blakebr0.mysticalagriculture.api.crop.CropTier;
import com.blakebr0.mysticalagriculture.api.crop.CropType;
import com.blakebr0.mysticalagriculture.api.lib.LazyIngredient;
import com.blakebr0.mysticalcustomization.loader.CropLoader;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.function.Supplier;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.neoforged.neoforge.registries.DeferredHolder;

public final class CropModifier {
    public static void modify(Crop crop, JsonObject json) throws JsonSyntaxException, ResourceLocationException {
        if (json.has("name")) {
            String name = GsonHelper.getAsString((JsonObject)json, (String)"name");
            crop.setDisplayName((Component)Component.literal((String)name));
        }
        if (json.has("tier")) {
            String tierId = GsonHelper.getAsString((JsonObject)json, (String)"tier");
            CropTier tier = MysticalAgricultureAPI.getCropRegistry().getTierById(ResourceLocation.parse((String)tierId));
            if (tier == null) {
                throw new JsonSyntaxException("Invalid crop tier provided: " + tierId);
            }
            crop.setTier(tier);
        }
        if (json.has("type")) {
            String typeId = GsonHelper.getAsString((JsonObject)json, (String)"type");
            CropType type = MysticalAgricultureAPI.getCropRegistry().getTypeById(ResourceLocation.parse((String)typeId));
            if (type == null) {
                throw new JsonSyntaxException("Invalid crop type provided: " + typeId);
            }
            crop.setType(type);
        }
        if (json.has("ingredient")) {
            LazyIngredient material;
            JsonObject ingredient = GsonHelper.getAsJsonObject((JsonObject)json, (String)"ingredient");
            if (ingredient.has("tag")) {
                String tag = GsonHelper.getAsString((JsonObject)ingredient, (String)"tag");
                material = LazyIngredient.tag((String)tag);
            } else if (ingredient.has("item")) {
                String item = GsonHelper.getAsString((JsonObject)ingredient, (String)"item");
                if (ingredient.has("components")) {
                    DataComponentMap components = (DataComponentMap)((Pair)DataComponentMap.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)ingredient.get("components")).getOrThrow(JsonSyntaxException::new)).getFirst();
                    material = LazyIngredient.item((String)item, (DataComponentMap)components);
                } else {
                    material = LazyIngredient.item((String)item);
                }
            } else {
                throw new JsonSyntaxException("Ingredient must have either 'item' or 'tag' property");
            }
            crop.setCraftingMaterial(material);
        }
        if (json.has("baseSecondaryChance")) {
            double chance = GsonHelper.getAsDouble((JsonObject)json, (String)"baseSecondaryChance");
            crop.setBaseSecondaryChance(chance);
        }
        if (json.has("respectsEffectiveFarmland")) {
            boolean respects = GsonHelper.getAsBoolean((JsonObject)json, (String)"respectsEffectiveFarmland");
            crop.setRespectsEffectiveFarmland(respects);
        }
        if (json.has("enabled")) {
            boolean enabled = GsonHelper.getAsBoolean((JsonObject)json, (String)"enabled");
            crop.setEnabled(enabled);
        }
        if (json.has("crux")) {
            if (json.get("crux").isJsonNull()) {
                CropLoader.CRUX_MAP.put(crop, null);
            } else {
                String crux = GsonHelper.getAsString((JsonObject)json, (String)"crux");
                CropLoader.CRUX_MAP.put(crop, ResourceLocation.parse((String)crux));
            }
        }
        if (json.has("glint")) {
            boolean glint = GsonHelper.getAsBoolean((JsonObject)json, (String)"glint");
            crop.setHasEffect(glint);
        }
        if (json.has("biomes")) {
            JsonArray biomes = GsonHelper.getAsJsonArray((JsonObject)json, (String)"biomes");
            biomes.forEach(biome -> crop.addRequiredBiome(ResourceLocation.parse((String)biome.getAsString())));
        }
        if (json.has("essence")) {
            String essence = GsonHelper.getAsString((JsonObject)json, (String)"essence");
            DeferredHolder item = DeferredHolder.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)essence));
            crop.setEssenceItem((Supplier)item);
        }
        if (json.has("recipes")) {
            JsonObject recipes = GsonHelper.getAsJsonObject((JsonObject)json, (String)"recipes");
            CropRecipes config = crop.getRecipeConfig();
            if (recipes.has("crafting")) {
                boolean enabled = GsonHelper.getAsBoolean((JsonObject)recipes, (String)"crafting");
                config.setSeedCraftingRecipeEnabled(enabled);
            }
            if (recipes.has("infusion")) {
                boolean enabled = GsonHelper.getAsBoolean((JsonObject)recipes, (String)"infusion");
                config.setSeedInfusionRecipeEnabled(enabled);
            }
            if (recipes.has("reprocessor")) {
                boolean enabled = GsonHelper.getAsBoolean((JsonObject)recipes, (String)"reprocessor");
                config.setSeedReprocessorRecipeEnabled(enabled);
            }
        }
    }
}

