/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.geore.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.shynieke.geore.registry.GeOreRecipes;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;

public class TagFurnaceRecipe
extends SmeltingRecipe {
    protected final Ingredient resultIngredient;

    public TagFurnaceRecipe(CookingBookCategory category, String groupIn, Ingredient ingredientIn, Ingredient resultIn, float experienceIn, int cookTimeIn) {
        super(groupIn, category, ingredientIn, ItemStack.EMPTY, experienceIn, cookTimeIn);
        this.resultIngredient = resultIn;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public Ingredient getResultIngredient() {
        return this.resultIngredient;
    }

    public ItemStack assemble(SingleRecipeInput input, HolderLookup.Provider registryAccess) {
        return this.getResultItem(registryAccess).copy();
    }

    public ItemStack getResultItem(HolderLookup.Provider registryAccess) {
        return this.resultIngredient.getItems()[0];
    }

    public RecipeSerializer<?> getSerializer() {
        return GeOreRecipes.TAG_FURNACE_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<TagFurnaceRecipe> {
        public static final MapCodec<TagFurnaceRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CookingBookCategory.CODEC.fieldOf("category").orElse((Object)CookingBookCategory.MISC).forGetter(recipe -> ((TagFurnaceRecipe)recipe).category), (App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> ((TagFurnaceRecipe)recipe).group), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> ((TagFurnaceRecipe)recipe).ingredient), (App)Ingredient.CODEC_NONEMPTY.fieldOf("result").forGetter(recipe -> recipe.resultIngredient), (App)Codec.FLOAT.fieldOf("experience").orElse((Object)Float.valueOf(0.0f)).forGetter(recipe -> Float.valueOf(((TagFurnaceRecipe)recipe).experience)), (App)Codec.INT.fieldOf("cookingtime").orElse((Object)200).forGetter(recipe -> ((TagFurnaceRecipe)recipe).cookingTime)).apply((Applicative)instance, TagFurnaceRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, TagFurnaceRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<TagFurnaceRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, TagFurnaceRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static TagFurnaceRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            String s = buffer.readUtf();
            CookingBookCategory cookingbookcategory = (CookingBookCategory)buffer.readEnum(CookingBookCategory.class);
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            Ingredient result = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            float f = buffer.readFloat();
            int i = buffer.readVarInt();
            return new TagFurnaceRecipe(cookingbookcategory, s, ingredient, result, f, i);
        }

        public static void toNetwork(RegistryFriendlyByteBuf buffer, TagFurnaceRecipe recipe) {
            buffer.writeUtf(recipe.getGroup());
            buffer.writeEnum((Enum)recipe.category());
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.getIngredient());
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.getResultIngredient());
            buffer.writeFloat(recipe.getExperience());
            buffer.writeVarInt(recipe.getCookingTime());
        }
    }
}

