/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.geore.datagen.server;

import com.shynieke.geore.Reference;
import com.shynieke.geore.datagen.builder.TagSmeltingRecipeBuilder;
import com.shynieke.geore.registry.GeOreBlockReg;
import com.shynieke.geore.registry.GeOreRegistry;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.NotCondition;
import net.neoforged.neoforge.common.conditions.TagEmptyCondition;
import org.jetbrains.annotations.NotNull;

public class GeOreRecipeProvider
extends RecipeProvider {
    public GeOreRecipeProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, lookupProvider);
    }

    protected void buildRecipes(@NotNull RecipeOutput output, @NotNull HolderLookup.Provider holderLookup) {
        this.generateRecipes(GeOreRegistry.COAL_GEORE, output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Blocks.TORCH, (int)2).pattern("X").pattern("#").define(Character.valueOf('#'), Tags.Items.RODS_WOODEN).define(Character.valueOf('X'), (ItemLike)GeOreRegistry.COAL_GEORE.getShard().get()).unlockedBy("has_coal_geore_shard", GeOreRecipeProvider.has((ItemLike)((ItemLike)GeOreRegistry.COAL_GEORE.getShard().get()))).save(output, "geore:torch_from_coal_shard");
        this.generateRecipe(GeOreRegistry.COPPER_GEORE, 0.7f, (ItemLike)Items.COPPER_INGOT, output);
        this.generateRecipe(GeOreRegistry.DIAMOND_GEORE, 1.0f, (ItemLike)Items.DIAMOND, output);
        this.generateRecipe(GeOreRegistry.EMERALD_GEORE, 1.0f, (ItemLike)Items.EMERALD, output);
        this.generateRecipe(GeOreRegistry.GOLD_GEORE, 1.0f, (ItemLike)Items.GOLD_INGOT, output);
        this.generateRecipe(GeOreRegistry.IRON_GEORE, 0.7f, (ItemLike)Items.IRON_INGOT, output);
        this.generateRecipe(GeOreRegistry.LAPIS_GEORE, 0.2f, (ItemLike)Items.LAPIS_LAZULI, output);
        this.generateRecipe(GeOreRegistry.QUARTZ_GEORE, 0.2f, (ItemLike)Items.QUARTZ, output);
        this.generateRecipe(GeOreRegistry.REDSTONE_GEORE, 0.7f, (ItemLike)Items.REDSTONE, output);
        this.generateRecipes(GeOreRegistry.ANCIENT_DEBRIS_GEORE, output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.ANCIENT_DEBRIS).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)GeOreRegistry.ANCIENT_DEBRIS_GEORE.getShard().get()).unlockedBy("has_ancient_debris_geore_shard", GeOreRecipeProvider.has((ItemLike)((ItemLike)GeOreRegistry.ANCIENT_DEBRIS_GEORE.getShard().get()))).save(output, "geore:ancient_debris_from_ancient_debris_shard");
        this.generateTagRecipe(GeOreRegistry.RUBY_GEORE, 0.7f, this.getCommonTag("gems/ruby"), output);
        this.generateTagRecipe(GeOreRegistry.SAPPHIRE_GEORE, 0.7f, this.getCommonTag("gems/sapphire"), output);
        this.generateTagRecipe(GeOreRegistry.TOPAZ_GEORE, 0.7f, this.getCommonTag("gems/topaz"), output);
        this.generateTagRecipe(GeOreRegistry.ZINC_GEORE, 0.7f, this.getCommonTag("ingots/zinc"), output);
        this.generateTagRecipe(GeOreRegistry.URANINITE_GEORE, 0.7f, this.getCommonTag("raw_materials/uraninite"), output);
        this.generateTagRecipe(GeOreRegistry.BLACK_QUARTZ_GEORE, 0.7f, this.getCommonTag("gems/black_quartz"), output);
        this.generateTagRecipe(GeOreRegistry.MONAZITE_GEORE, 0.7f, this.getCommonTag("dusts/monazite"), output);
        this.generateTagRecipe(GeOreRegistry.ALUMINUM_GEORE, 0.7f, this.getCommonTag("ingots/aluminum"), output);
        this.generateTagRecipe(GeOreRegistry.LEAD_GEORE, 0.7f, this.getCommonTag("ingots/lead"), output);
        this.generateTagRecipe(GeOreRegistry.NICKEL_GEORE, 0.7f, this.getCommonTag("ingots/nickel"), output);
        this.generateTagRecipe(GeOreRegistry.OSMIUM_GEORE, 0.7f, this.getCommonTag("ingots/osmium"), output);
        this.generateTagRecipe(GeOreRegistry.PLATINUM_GEORE, 0.7f, this.getCommonTag("ingots/platinum"), output);
        this.generateTagRecipe(GeOreRegistry.SILVER_GEORE, 0.7f, this.getCommonTag("ingots/silver"), output);
        this.generateTagRecipe(GeOreRegistry.TIN_GEORE, 0.7f, this.getCommonTag("ingots/tin"), output);
        this.generateTagRecipe(GeOreRegistry.TUNGSTEN_GEORE, 0.7f, this.getCommonTag("ingots/tungsten"), output);
        this.generateTagRecipe(GeOreRegistry.URANIUM_GEORE, 0.7f, this.getCommonTag("ingots/uranium"), output);
        this.generateHarderTagRecipe(GeOreRegistry.ALLTHEMODIUM_GEORE, 0.7f, this.getCommonTag("nuggets/allthemodium"), output);
        this.generateHarderTagRecipe(GeOreRegistry.VIBRANIUM_GEORE, 0.7f, this.getCommonTag("nuggets/vibranium"), output);
        this.generateHarderTagRecipe(GeOreRegistry.UNOBTAINIUM_GEORE, 0.7f, this.getCommonTag("nuggets/unobtainium"), output);
    }

    private void generateRecipe(GeOreBlockReg reg, float xp, ItemLike result, RecipeOutput output) {
        this.generateRecipes(reg, output);
        this.smeltToOre(reg, xp, result, output);
    }

    private void generateTagRecipe(GeOreBlockReg reg, float xp, TagKey<Item> result, RecipeOutput output) {
        this.generateRecipes(reg, output);
        this.smeltToOre(reg, xp, result, output);
    }

    private TagKey<Item> getCommonTag(String path) {
        return ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)path));
    }

    private void generateRecipes(GeOreBlockReg blockReg, RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)blockReg.getBlock().get())).pattern("SS").pattern("SS").define(Character.valueOf('S'), (ItemLike)blockReg.getShard().get()).unlockedBy("has_" + blockReg.getName() + "geore_shard", GeOreRecipeProvider.has((ItemLike)((ItemLike)blockReg.getShard().get()))).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)blockReg.getSpyglass().get())).pattern(" # ").pattern(" X ").pattern(" X ").define(Character.valueOf('#'), (ItemLike)blockReg.getShard().get()).define(Character.valueOf('X'), (ItemLike)Items.COPPER_INGOT).unlockedBy("has_" + blockReg.getName() + "geore_shard", GeOreRecipeProvider.has((ItemLike)((ItemLike)blockReg.getShard().get()))).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)blockReg.getTintedGlass().get()), (int)2).define(Character.valueOf('G'), (ItemLike)Blocks.GLASS).define(Character.valueOf('S'), (ItemLike)blockReg.getShard().get()).pattern(" S ").pattern("SGS").pattern(" S ").unlockedBy("has_shard", GeOreRecipeProvider.has((ItemLike)((ItemLike)blockReg.getShard().get()))).save(output);
    }

    private void generateHarderTagRecipe(GeOreBlockReg blockReg, float xp, TagKey<Item> oreTag, RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)blockReg.getBlock().get())).pattern("SS").pattern("SS").define(Character.valueOf('S'), (ItemLike)blockReg.getShard().get()).unlockedBy("has_" + blockReg.getName() + "geore_shard", GeOreRecipeProvider.has((ItemLike)((ItemLike)blockReg.getShard().get()))).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)blockReg.getSpyglass().get())).pattern(" # ").pattern(" X ").pattern(" X ").define(Character.valueOf('#'), (ItemLike)blockReg.getShard().get()).define(Character.valueOf('X'), (ItemLike)Items.COPPER_INGOT).unlockedBy("has_" + blockReg.getName() + "geore_shard", GeOreRecipeProvider.has((ItemLike)((ItemLike)blockReg.getShard().get()))).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)blockReg.getTintedGlass().get()), (int)2).define(Character.valueOf('G'), (ItemLike)Blocks.GLASS).define(Character.valueOf('S'), (ItemLike)blockReg.getShard().get()).pattern(" S ").pattern("SGS").pattern(" S ").unlockedBy("has_shard", GeOreRecipeProvider.has((ItemLike)((ItemLike)blockReg.getShard().get()))).save(output);
        RecipeOutput tagOutput = output.withConditions(new ICondition[]{new NotCondition((ICondition)new TagEmptyCondition(oreTag.location()))});
        Ingredient outputIngredient = Ingredient.of(oreTag);
        TagSmeltingRecipeBuilder.smelting(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)blockReg.getBlock().get()}), RecipeCategory.MISC, outputIngredient, xp, 200).group("geore").unlockedBy("has_" + blockReg.getName() + "geore_shard", GeOreRecipeProvider.has((ItemLike)((ItemLike)blockReg.getShard().get()))).save(tagOutput, Reference.modLoc(blockReg.getName() + "_from_smelting_" + blockReg.getShard().getId().getPath()));
        TagSmeltingRecipeBuilder.blasting(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)blockReg.getBlock().get()}), RecipeCategory.MISC, outputIngredient, xp, 100).group("geore").unlockedBy("has_" + blockReg.getName() + "geore_shard", GeOreRecipeProvider.has((ItemLike)((ItemLike)blockReg.getShard().get()))).save(tagOutput, Reference.modLoc(blockReg.getName() + "_from_blasting_" + blockReg.getShard().getId().getPath()));
    }

    private void smeltToOre(GeOreBlockReg blockReg, float xp, ItemLike item, RecipeOutput output) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)blockReg.getShard().get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)item, (float)xp, (int)200).group("geore").unlockedBy("has_" + blockReg.getName() + "geore_shard", GeOreRecipeProvider.has((ItemLike)((ItemLike)blockReg.getShard().get()))).save(output, Reference.modLoc(BuiltInRegistries.ITEM.getKey((Object)item.asItem()).getPath() + "_from_smelting_" + blockReg.getShard().getId().getPath()));
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)blockReg.getShard().get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)item, (float)xp, (int)100).group("geore").unlockedBy("has_" + blockReg.getName() + "geore_shard", GeOreRecipeProvider.has((ItemLike)((ItemLike)blockReg.getShard().get()))).save(output, Reference.modLoc(BuiltInRegistries.ITEM.getKey((Object)item.asItem()).getPath() + "_from_blasting_" + blockReg.getShard().getId().getPath()));
    }

    private void smeltToOre(GeOreBlockReg blockReg, float xp, TagKey<Item> oreTag, RecipeOutput output) {
        RecipeOutput tagOutput = output.withConditions(new ICondition[]{new NotCondition((ICondition)new TagEmptyCondition(oreTag.location()))});
        Ingredient outputIngredient = Ingredient.of(oreTag);
        TagSmeltingRecipeBuilder.smelting(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)blockReg.getShard().get()}), RecipeCategory.MISC, outputIngredient, xp, 200).group("geore").unlockedBy("has_" + blockReg.getName() + "geore_shard", GeOreRecipeProvider.has((ItemLike)((ItemLike)blockReg.getShard().get()))).save(tagOutput, Reference.modLoc(blockReg.getName() + "_from_smelting_" + blockReg.getShard().getId().getPath()));
        TagSmeltingRecipeBuilder.blasting(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)blockReg.getShard().get()}), RecipeCategory.MISC, outputIngredient, xp, 100).group("geore").unlockedBy("has_" + blockReg.getName() + "geore_shard", GeOreRecipeProvider.has((ItemLike)((ItemLike)blockReg.getShard().get()))).save(tagOutput, Reference.modLoc(blockReg.getName() + "_from_blasting_" + blockReg.getShard().getId().getPath()));
    }
}

