/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.geore.datagen.server;

import com.shynieke.geore.registry.GeOreBlockReg;
import com.shynieke.geore.registry.GeOreRegistry;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.NotNull;

public class GeOreLootProvider
extends LootTableProvider {
    public GeOreLootProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(GeOreBlockTables::new, LootContextParamSets.BLOCK)), lookupProvider);
    }

    protected void validate(@NotNull WritableRegistry<LootTable> writableregistry, @NotNull ValidationContext validationcontext, @NotNull ProblemReporter.Collector problemreporter$collector) {
        super.validate(writableregistry, validationcontext, problemreporter$collector);
    }

    public static class GeOreBlockTables
    extends BlockLootSubProvider {
        private final HolderLookup.RegistryLookup<Enchantment> enchantmentLookup;

        protected GeOreBlockTables(HolderLookup.Provider lookupProvider) {
            super(Set.of(), FeatureFlags.REGISTRY.allFlags(), lookupProvider);
            this.enchantmentLookup = lookupProvider.lookupOrThrow(Registries.ENCHANTMENT);
        }

        protected void generate() {
            block12: for (GeOreBlockReg reg : GeOreRegistry.getGeOres()) {
                switch (reg.getName()) {
                    case "ancient_debris": {
                        this.addHarderGeOreTables(GeOreRegistry.ANCIENT_DEBRIS_GEORE);
                        continue block12;
                    }
                    case "allthemodium": {
                        this.addHarderGeOreTables(GeOreRegistry.ALLTHEMODIUM_GEORE);
                        continue block12;
                    }
                    case "vibranium": {
                        this.addHarderGeOreTables(GeOreRegistry.VIBRANIUM_GEORE);
                        continue block12;
                    }
                    case "unobtainium": {
                        this.addHarderGeOreTables(GeOreRegistry.UNOBTAINIUM_GEORE);
                        continue block12;
                    }
                }
                this.addGeOreTables(reg);
            }
        }

        protected void addGeOreTables(GeOreBlockReg blockReg) {
            this.dropSelf((Block)blockReg.getBlock().get());
            this.add((Block)blockReg.getCluster().get(), block -> this.createSilkTouchDispatchTable((Block)block, (LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)blockReg.getShard().get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)4.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)this.enchantmentLookup.getOrThrow(Enchantments.FORTUNE))).when(MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(ItemTags.CLUSTER_MAX_HARVESTABLES)))).otherwise((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)blockReg.getShard().get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f)))))));
            this.dropWhenSilkTouch((Block)blockReg.getSmallBud().get());
            this.dropWhenSilkTouch((Block)blockReg.getMediumBud().get());
            this.dropWhenSilkTouch((Block)blockReg.getLargeBud().get());
            this.add((Block)blockReg.getBudding().get(), GeOreBlockTables.noDrop());
            this.dropSelf((Block)blockReg.getTintedGlass().get());
        }

        private void addHarderGeOreTables(GeOreBlockReg blockReg) {
            this.dropSelf((Block)blockReg.getBlock().get());
            this.add((Block)blockReg.getCluster().get(), block -> this.createSilkTouchDispatchTable((Block)block, (LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)blockReg.getShard().get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f)))));
            this.dropWhenSilkTouch((Block)blockReg.getSmallBud().get());
            this.dropWhenSilkTouch((Block)blockReg.getMediumBud().get());
            this.dropWhenSilkTouch((Block)blockReg.getLargeBud().get());
            this.add((Block)blockReg.getBudding().get(), GeOreBlockTables.noDrop());
            this.dropSelf((Block)blockReg.getTintedGlass().get());
        }

        @NotNull
        protected Iterable<Block> getKnownBlocks() {
            return GeOreRegistry.BLOCKS.getEntries().stream().map(holder -> (Block)holder.get())::iterator;
        }
    }
}

