/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.geore.datagen.client;

import com.shynieke.geore.Reference;
import com.shynieke.geore.item.GeoreSpyglassItem;
import com.shynieke.geore.registry.GeOreBlockReg;
import com.shynieke.geore.registry.GeOreRegistry;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.loaders.SeparateTransformsModelBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;

public class GeOreItemModelProvider
extends ItemModelProvider {
    public GeOreItemModelProvider(PackOutput packOutput, ExistingFileHelper helper) {
        super(packOutput, "geore", helper);
    }

    protected void registerModels() {
        for (GeOreBlockReg reg : GeOreRegistry.getGeOres()) {
            this.generateGeoreModels(reg);
        }
    }

    protected void generateGeoreModels(GeOreBlockReg blockReg) {
        this.singleTexture(blockReg.getShard().getId().getPath(), ResourceLocation.withDefaultNamespace((String)"item/generated"), "layer0", Reference.modLoc("item/" + blockReg.getShard().getId().getPath()));
        this.withExistingParent(blockReg.getBlock().getId().getPath(), Reference.modLoc("block/" + blockReg.getBlock().getId().getPath()));
        this.withExistingParent(blockReg.getBudding().getId().getPath(), Reference.modLoc("block/" + blockReg.getBudding().getId().getPath()));
        this.withExistingParent(blockReg.getTintedGlass().getId().getPath(), Reference.modLoc("block/" + blockReg.getTintedGlass().getId().getPath()));
        this.makeCluster(blockReg.getCluster());
        this.makeSmallBud(blockReg.getSmallBud());
        this.makeMediumBud(blockReg.getMediumBud());
        this.makeLargeBud(blockReg.getLargeBud());
        this.makeSpyglass(blockReg.getSpyglass());
    }

    private void makeSpyglass(DeferredHolder<Item, GeoreSpyglassItem> spyglass) {
        String path = spyglass.getId().getPath();
        ModelBuilder spyglass_gui = ((ItemModelBuilder)this.withExistingParent(path + "_gui", this.mcLoc("spyglass"))).texture("layer0", this.modLoc("item/" + path));
        ModelBuilder spyglass_hand = ((ItemModelBuilder)this.withExistingParent(path + "_in_hand", this.mcLoc("spyglass_in_hand"))).texture("spyglass", this.modLoc("item/" + path + "_model"));
        ((SeparateTransformsModelBuilder)((ItemModelBuilder)this.withExistingParent(path, "neoforge:item/default")).customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)spyglass_hand))).perspective(ItemDisplayContext.GUI, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)spyglass_gui))).perspective(ItemDisplayContext.GROUND, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)spyglass_gui))).perspective(ItemDisplayContext.FIXED, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)spyglass_gui)));
    }

    private void makeCluster(DeferredHolder<Block, AmethystClusterBlock> deferredHolder) {
        String path = deferredHolder.getId().getPath();
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.mcLoc("item/generated")))).texture("layer0", this.modLoc("block/" + path))).transforms().transform(ItemDisplayContext.HEAD).translation(0.0f, 14.0f, -5.0f).end();
    }

    private void makeSmallBud(DeferredHolder<Block, AmethystClusterBlock> deferredHolder) {
        String path = deferredHolder.getId().getPath();
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.mcLoc("item/amethyst_bud")))).texture("layer0", this.modLoc("block/" + path))).transforms().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(0.0f, -90.0f, 25.0f).translation(0.0f, 6.0f, 0.0f).scale(0.68f, 0.68f, 0.68f).end().transform(ItemDisplayContext.FIXED).translation(0.0f, 7.0f, 0.0f).end();
    }

    private void makeMediumBud(DeferredHolder<Block, AmethystClusterBlock> deferredHolder) {
        String path = deferredHolder.getId().getPath();
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.mcLoc("item/amethyst_bud")))).texture("layer0", this.modLoc("block/" + path))).transforms().transform(ItemDisplayContext.FIXED).translation(0.0f, 6.0f, 0.0f).end();
    }

    private void makeLargeBud(DeferredHolder<Block, AmethystClusterBlock> deferredHolder) {
        String path = deferredHolder.getId().getPath();
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.mcLoc("item/amethyst_bud")))).texture("layer0", this.modLoc("block/" + path))).transforms().transform(ItemDisplayContext.FIXED).translation(0.0f, 4.0f, 0.0f).end();
    }
}

