/*
 * Decompiled with CFR 0.152.
 */
package nl.teamdiopside.seamless.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashSet;
import java.util.Objects;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import nl.teamdiopside.seamless.OutlineFinder;
import nl.teamdiopside.seamless.Seamless;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public abstract class LevelRendererMixin
implements ResourceManagerReloadListener,
AutoCloseable {
    @Unique
    private VoxelShape seamless$lastShape = Shapes.block();
    @Unique
    private BlockPos seamless$lastPos = BlockPos.ZERO;
    @Unique
    private BlockState seamless$lastState = Blocks.AIR.defaultBlockState();
    @Shadow
    @Nullable
    private ClientLevel level;

    @Inject(method={"renderHitOutline(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;Lnet/minecraft/world/entity/Entity;DDDLnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderHitOutline(PoseStack poseStack, VertexConsumer vertexConsumer, Entity entity, double i, double b, double c, BlockPos blockPos, BlockState blockState, CallbackInfo ci) {
        VoxelShape shape;
        if (Seamless.modIds.contains("diagonalfences") && blockState.is(BlockTags.FENCES) || Seamless.modIds.contains("diagonalwindows") && (blockState.is(Blocks.IRON_BARS) || blockState.is(LevelRendererMixin.getTag("forge:glass_panes")) || blockState.is(LevelRendererMixin.getTag("c:glass_panes"))) || Seamless.modIds.contains("diagonalwalls") && blockState.is(BlockTags.WALLS)) {
            return;
        }
        if (Seamless.fastEnabled) {
            if (Objects.equals(this.seamless$lastState, blockState) && Objects.equals(this.seamless$lastPos, blockPos)) {
                shape = this.seamless$lastShape;
            } else {
                OutlineFinder.Recursion recursion = OutlineFinder.findAndAddShapes((Level)this.level, blockState, blockPos, new HashSet<BlockPos>(), blockPos, entity);
                this.seamless$lastShape = shape = recursion.voxelShape().optimize();
                this.seamless$lastPos = blockPos;
                this.seamless$lastState = blockState;
            }
        } else {
            OutlineFinder.Recursion recursion = OutlineFinder.findAndAddShapes((Level)this.level, blockState, blockPos, new HashSet<BlockPos>(), blockPos, entity);
            shape = recursion.voxelShape().optimize();
        }
        LevelRenderer.renderShape((PoseStack)poseStack, (VertexConsumer)vertexConsumer, (VoxelShape)shape, (double)((double)blockPos.getX() - i), (double)((double)blockPos.getY() - b), (double)((double)blockPos.getZ() - c), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
        ci.cancel();
    }

    @NotNull
    private static TagKey<Block> getTag(String string) {
        return TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)string));
    }
}

