/*
 * Decompiled with CFR 0.152.
 */
package nl.teamdiopside.seamless;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import nl.teamdiopside.seamless.Reload;
import nl.teamdiopside.seamless.Seamless;

public class OutlineFinder {
    public static Recursion findAndAddShapes(Level level, BlockState state, BlockPos pos, Set<BlockPos> connectedPositions, BlockPos originalPos, Entity entity) {
        connectedPositions.add(pos);
        BlockPos relativePos = pos.subtract((Vec3i)originalPos);
        VoxelShape shape = state.getShape((BlockGetter)level, pos, CollisionContext.of((Entity)entity)).move((double)relativePos.getX(), (double)relativePos.getY(), (double)relativePos.getZ());
        if (connectedPositions.size() > 1500) {
            return new Recursion(shape, connectedPositions);
        }
        for (Reload.OutlineRule outlineRule : Reload.RULES) {
            ResourceLocation location = outlineRule.location();
            if (OutlineFinder.blockDoesntMatch(outlineRule.blocks(), state.getBlock(), null, location)) continue;
            boolean blockstatesMatch = true;
            for (Map.Entry<String, Set<String>> entry : outlineRule.blockstates().entrySet()) {
                if (!OutlineFinder.propertyDoesntMatch(state, entry.getKey(), entry.getValue(), null, location)) continue;
                blockstatesMatch = false;
            }
            if (!blockstatesMatch) continue;
            for (Direction direction : OutlineFinder.getDirections(outlineRule.directions(), location, state)) {
                BlockPos checkingPos = pos.relative(direction);
                BlockState checkingState = level.getBlockState(checkingPos);
                if (connectedPositions.contains(checkingPos) || OutlineFinder.blockDoesntMatch(outlineRule.connectingBlocks(), checkingState.getBlock(), state.getBlock(), location)) continue;
                boolean connectingBlockstatesMatch = true;
                for (Map.Entry<String, Set<String>> entry : outlineRule.connectingBlockstates().entrySet()) {
                    if (!OutlineFinder.propertyDoesntMatch(checkingState, entry.getKey(), entry.getValue(), state, location)) continue;
                    connectingBlockstatesMatch = false;
                    break;
                }
                if (!connectingBlockstatesMatch) continue;
                Recursion recursion = OutlineFinder.findAndAddShapes(level, checkingState, checkingPos, connectedPositions, originalPos, entity);
                shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)recursion.voxelShape(), (BooleanOp)BooleanOp.OR);
                connectedPositions = recursion.connectedPositions();
            }
        }
        return new Recursion(shape, connectedPositions);
    }

    public static boolean blockDoesntMatch(Set<String> set, Block checkingBlock, Block originalBlock, ResourceLocation location) {
        HashSet<Block> goodBlocks = new HashSet<Block>();
        HashSet<Block> nonoBlocks = new HashSet<Block>();
        for (String string : set) {
            if (originalBlock != null) {
                if (string.equals("/same")) {
                    goodBlocks.add(originalBlock);
                } else if (string.equals("/!same")) {
                    nonoBlocks.add(originalBlock);
                }
            }
            if (string.startsWith("!")) {
                nonoBlocks.addAll(OutlineFinder.getBlocks(string.substring(1), location));
                continue;
            }
            goodBlocks.addAll(OutlineFinder.getBlocks(string, location));
        }
        return !goodBlocks.contains(checkingBlock) || nonoBlocks.contains(checkingBlock);
    }

    public static Set<Block> getBlocks(String string, ResourceLocation location) {
        HashSet<Block> blocks = new HashSet<Block>();
        if (string.startsWith("#")) {
            TagKey blockTagKey = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)string.replace("#", "")));
            BuiltInRegistries.BLOCK.getOrCreateTag(blockTagKey).stream().forEach(blockHolder -> blocks.add((Block)blockHolder.value()));
        } else {
            if (!Seamless.modIds.contains(string.replace("#", "").split(":")[0])) {
                return blocks;
            }
            Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)string));
            if (block == Blocks.AIR && !string.split(":")[1].equals("air")) {
                OutlineFinder.initialError("Block \"" + string + "\" from " + String.valueOf(location) + " does not exist!");
            } else {
                blocks.add(block);
            }
        }
        return blocks;
    }

    public static boolean propertyDoesntMatch(BlockState checkingState, String propertyName, Set<String> values, BlockState originalState, ResourceLocation location) {
        Property checkingProperty = checkingState.getBlock().getStateDefinition().getProperty(propertyName);
        if (checkingProperty == null) {
            OutlineFinder.initialError("Blockstate property \"" + propertyName + "\" from " + String.valueOf(location) + " does not exist for " + String.valueOf(checkingState.getBlock().getName()));
            return true;
        }
        String valueName = checkingState.getValue(checkingProperty).toString();
        Comparable comparable = checkingState.getValue(checkingProperty);
        if (comparable instanceof StringRepresentable) {
            StringRepresentable representable = (StringRepresentable)comparable;
            valueName = representable.getSerializedName();
        }
        HashSet<String> goodValues = new HashSet<String>(Set.copyOf(values));
        HashSet nonoValues = new HashSet();
        boolean useNono = false;
        if (originalState != null) {
            for (String value : values) {
                Property originalProperty;
                if (!value.startsWith("/same") && !value.startsWith("/!same")) continue;
                String addToPropertyString = value.contains("+") ? value.split("\\+")[1] : "0";
                int addToProperty = 0;
                if (!addToPropertyString.equals("opposite")) {
                    try {
                        addToProperty = Integer.parseInt(addToPropertyString);
                    }
                    catch (NumberFormatException e) {
                        throw new NumberFormatException("Blockstate \"" + value + "\" from " + String.valueOf(location) + " does not exist because \"" + addToPropertyString + "\" is not an integer");
                    }
                }
                if ((originalProperty = originalState.getBlock().getStateDefinition().getProperty(propertyName)) == null) {
                    OutlineFinder.initialError("Blockstate property \"" + propertyName + "\" from " + String.valueOf(location) + " does not exist for " + String.valueOf(originalState.getBlock().getName()));
                    continue;
                }
                HashSet<String> toAdd = new HashSet<String>();
                if (originalProperty instanceof DirectionProperty) {
                    DirectionProperty directionProperty = (DirectionProperty)originalProperty;
                    Direction direction = (Direction)originalState.getValue((Property)directionProperty);
                    for (int i = 0; i < addToProperty; ++i) {
                        direction = direction.getClockWise();
                    }
                    if (addToPropertyString.equals("opposite")) {
                        direction = direction.getOpposite();
                    }
                    toAdd.add(direction.getName());
                } else if (originalProperty == BlockStateProperties.AXIS) {
                    toAdd.add(Direction.fromAxisAndDirection((Direction.Axis)((Direction.Axis)originalState.getValue((Property)BlockStateProperties.AXIS)), (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE).toString());
                    toAdd.add(Direction.fromAxisAndDirection((Direction.Axis)((Direction.Axis)originalState.getValue((Property)BlockStateProperties.AXIS)), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE).toString());
                } else if (originalProperty == BlockStateProperties.HORIZONTAL_AXIS) {
                    toAdd.add(Direction.fromAxisAndDirection((Direction.Axis)((Direction.Axis)originalState.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS)), (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE).toString());
                    toAdd.add(Direction.fromAxisAndDirection((Direction.Axis)((Direction.Axis)originalState.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS)), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE).toString());
                } else if (originalProperty instanceof IntegerProperty) {
                    IntegerProperty integerProperty = (IntegerProperty)originalProperty;
                    toAdd.add(String.valueOf((Integer)originalState.getValue((Property)integerProperty) + addToProperty));
                } else {
                    toAdd.add(String.valueOf(originalState.getValue(originalProperty)));
                }
                if (value.startsWith("/same")) {
                    goodValues.addAll(toAdd);
                    continue;
                }
                if (!value.startsWith("/!same")) continue;
                useNono = true;
                nonoValues.addAll(toAdd);
            }
        }
        boolean propertiesMatch = propertyName.equals(checkingProperty.getName());
        boolean valuesMatch = goodValues.contains(valueName) || !nonoValues.contains(valueName) && useNono;
        return !propertiesMatch || !valuesMatch;
    }

    public static Set<Direction> getDirections(Set<String> set, ResourceLocation location, BlockState state) {
        HashSet<Direction> directions = new HashSet<Direction>();
        for (String string : set) {
            if (string.startsWith("/state:")) {
                Property property;
                String propertyString = string.split(":")[1].split("\\+")[0];
                String addToPropertyString = string.contains("+") ? string.split("\\+")[1] : "0";
                int addToProperty = 0;
                if (!addToPropertyString.equals("opposite")) {
                    try {
                        addToProperty = Integer.parseInt(addToPropertyString);
                    }
                    catch (NumberFormatException e) {
                        OutlineFinder.initialError("Direction \"" + string + "\" from " + String.valueOf(location) + " does not exist because \"" + addToPropertyString + "\" is not an integer");
                    }
                }
                if ((property = state.getBlock().getStateDefinition().getProperty(propertyString)) == null) {
                    OutlineFinder.initialError("Blockstate property \"" + propertyString + "\" from " + String.valueOf(location) + " does not exist for " + String.valueOf(state.getBlock().getName()));
                    continue;
                }
                if (property instanceof DirectionProperty) {
                    DirectionProperty directionProperty = (DirectionProperty)property;
                    Direction direction = (Direction)state.getValue((Property)directionProperty);
                    for (int i = 0; i < addToProperty; ++i) {
                        direction = direction.getClockWise();
                    }
                    if (addToPropertyString.equals("opposite")) {
                        direction = direction.getOpposite();
                    }
                    directions.add(direction);
                    continue;
                }
                if (property == BlockStateProperties.AXIS) {
                    directions.add(Direction.fromAxisAndDirection((Direction.Axis)((Direction.Axis)state.getValue((Property)BlockStateProperties.AXIS)), (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE));
                    directions.add(Direction.fromAxisAndDirection((Direction.Axis)((Direction.Axis)state.getValue((Property)BlockStateProperties.AXIS)), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE));
                    continue;
                }
                if (property == BlockStateProperties.HORIZONTAL_AXIS) {
                    directions.add(Direction.fromAxisAndDirection((Direction.Axis)((Direction.Axis)state.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS)), (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE));
                    directions.add(Direction.fromAxisAndDirection((Direction.Axis)((Direction.Axis)state.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS)), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE));
                    continue;
                }
                OutlineFinder.initialError("Property \"" + propertyString + "\" from " + String.valueOf(location) + "\" is not a direction property");
                continue;
            }
            Direction direction = Direction.byName((String)string);
            if (direction != null) {
                directions.add(direction);
                continue;
            }
            OutlineFinder.initialError("Direction \"" + string + "\" from " + String.valueOf(location) + " does not exist!");
        }
        return directions;
    }

    public static void initialError(String string) {
        if (!Seamless.errors.contains(string)) {
            Seamless.LOGGER.error(string);
            Seamless.errors.add(string);
        }
    }

    public record Recursion(VoxelShape voxelShape, Set<BlockPos> connectedPositions) {
    }
}

