/*
 * Decompiled with CFR 0.152.
 */
package meranha.mekaweapons.items;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.List;
import meranha.mekaweapons.MekaWeapons;
import meranha.mekaweapons.MekaWeaponsUtils;
import meranha.mekaweapons.items.modules.WeaponsModules;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class MekaArrowEntity
extends AbstractArrow {
    private IntOpenHashSet piercingIgnoreEntityIds;
    private List<Entity> piercedAndKilledEntities;

    public MekaArrowEntity(EntityType<? extends MekaArrowEntity> entityType, Level level, ItemStack itemStack) {
        super(entityType, level);
    }

    public MekaArrowEntity(Level level, AbstractArrow arrow, ItemStack projectileStack, ItemStack weaponStack, int damage) {
        super((EntityType)MekaWeapons.MEKA_ARROW.get(), arrow.getX(), arrow.getY(), arrow.getZ(), level, projectileStack, null);
        this.setPickup(!MekaWeaponsUtils.isModuleEnabled(weaponStack, WeaponsModules.ARROWENERGY_UNIT));
        this.setNoGravity(MekaWeaponsUtils.isModuleEnabled(weaponStack, WeaponsModules.GRAVITYDAMPENER_UNIT));
        this.setBaseDamage(damage);
        this.setOwner(arrow.getOwner());
    }

    public MekaArrowEntity(EntityType<MekaArrowEntity> entityType, Level level) {
        this(entityType, level, new ItemStack((ItemLike)Items.ARROW));
    }

    public void tick() {
        super.tick();
        if (this.tickCount > 100 && !this.inGround) {
            this.setNoGravity(false);
        }
    }

    public void onHitEntity(EntityHitResult result) {
        Entity entity = result.getEntity();
        double baseDamage = this.getBaseDamage();
        Entity player = this.getOwner();
        DamageSource damagesource = this.damageSources().arrow((AbstractArrow)this, (Entity)(player != null ? player : this));
        Level level = this.level();
        if (this.getWeaponItem() != null && level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            baseDamage = EnchantmentHelper.modifyDamage((ServerLevel)serverlevel, (ItemStack)this.getWeaponItem(), (Entity)entity, (DamageSource)damagesource, (float)((float)baseDamage));
        }
        if (this.getPierceLevel() > 0) {
            if (this.piercingIgnoreEntityIds == null) {
                this.piercingIgnoreEntityIds = new IntOpenHashSet(5);
            }
            if (this.piercedAndKilledEntities == null) {
                this.piercedAndKilledEntities = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.piercingIgnoreEntityIds.size() >= this.getPierceLevel() + 1) {
                this.discard();
                return;
            }
            this.piercingIgnoreEntityIds.add(entity.getId());
        }
        if (player instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)player;
            livingEntity.setLastHurtMob(entity);
        }
        boolean isEnderman = entity.getType() == EntityType.ENDERMAN;
        int i = entity.getRemainingFireTicks();
        if (this.isOnFire() && !isEnderman) {
            entity.igniteForSeconds(5.0f);
        }
        if (entity.hurt(damagesource, (float)baseDamage)) {
            if (isEnderman) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                if (!level.isClientSide && this.getPierceLevel() <= 0) {
                    livingentity.setArrowCount(livingentity.getArrowCount() + 1);
                }
                this.doKnockback(livingentity, damagesource);
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverLevel, (Entity)livingentity, (DamageSource)damagesource, (ItemStack)this.getWeaponItem());
                }
                this.doPostHurtEffects(livingentity);
                if (livingentity != player && livingentity instanceof Player && player instanceof ServerPlayer && !this.isSilent()) {
                    ((ServerPlayer)player).connection.send((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.ARROW_HIT_PLAYER, 0.0f));
                }
                if (!entity.isAlive() && this.piercedAndKilledEntities != null) {
                    this.piercedAndKilledEntities.add((Entity)livingentity);
                }
                if (!level.isClientSide && player instanceof ServerPlayer) {
                    ServerPlayer serverplayer = (ServerPlayer)player;
                    if (this.piercedAndKilledEntities != null && this.shotFromCrossbow()) {
                        CriteriaTriggers.KILLED_BY_CROSSBOW.trigger(serverplayer, this.piercedAndKilledEntities);
                    } else if (!entity.isAlive() && this.shotFromCrossbow()) {
                        CriteriaTriggers.KILLED_BY_CROSSBOW.trigger(serverplayer, List.of(entity));
                    }
                }
            }
            this.playSound(this.getHitGroundSoundEvent(), 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
            if (this.getPierceLevel() <= 0) {
                this.discard();
            }
        } else {
            entity.setRemainingFireTicks(i);
            this.deflect(ProjectileDeflection.REVERSE, entity, this.getOwner(), false);
            this.setDeltaMovement(this.getDeltaMovement().scale(0.2));
            if (!this.level().isClientSide && this.getDeltaMovement().lengthSqr() < 1.0E-7) {
                if (this.pickup == AbstractArrow.Pickup.ALLOWED) {
                    this.spawnAtLocation(this.getPickupItem(), 0.1f);
                }
                this.discard();
            }
        }
    }

    public void setPickup(boolean pickup) {
        this.pickup = pickup ? AbstractArrow.Pickup.ALLOWED : AbstractArrow.Pickup.CREATIVE_ONLY;
    }

    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }
}

