/*
 * Decompiled with CFR 0.152.
 */
package meranha.mekaweapons.items;

import java.util.List;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.event.MekanismTeleportEvent;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleHelper;
import mekanism.api.math.MathUtils;
import mekanism.api.text.EnumColor;
import mekanism.client.key.MekKeyHandler;
import mekanism.client.key.MekanismKeyHandler;
import mekanism.common.MekanismLang;
import mekanism.common.content.gear.IRadialModuleContainerItem;
import mekanism.common.content.gear.ModuleHelper;
import mekanism.common.content.gear.mekatool.ModuleTeleportationUnit;
import mekanism.common.item.ItemEnergized;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_client.PacketPortalFX;
import mekanism.common.registries.MekanismModules;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import meranha.mekaweapons.MekaWeapons;
import meranha.mekaweapons.MekaWeaponsUtils;
import meranha.mekaweapons.items.modules.WeaponsModules;
import net.minecraft.client.KeyMapping;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.ItemAttributeModifierEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

public class ItemMekaTana
extends ItemEnergized
implements IRadialModuleContainerItem {
    private static final ResourceLocation RADIAL_ID = MekaWeapons.rl("meka_tana");

    public ItemMekaTana(@NotNull Item.Properties properties) {
        super(IModuleHelper.INSTANCE.applyModuleContainerProperties(properties.rarity(Rarity.EPIC).setNoRepair().stacksTo(1)));
    }

    public void onDestroyed(@NotNull ItemEntity item, @NotNull DamageSource damageSource) {
        ModuleHelper.INSTANCE.dropModuleContainerContents(item, damageSource);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        if (MekKeyHandler.isKeyPressed((KeyMapping)MekanismKeyHandler.detailsKey)) {
            this.addModuleDetails(stack, tooltip);
            return;
        }
        StorageUtils.addStoredEnergy((ItemStack)stack, tooltip, (boolean)true);
        tooltip.add((Component)MekanismLang.HOLD_FOR_MODULES.translateColored(EnumColor.GRAY, new Object[]{EnumColor.INDIGO, MekanismKeyHandler.detailsKey.getTranslatedKeyMessage()}));
    }

    public boolean canPerformAction(@NotNull ItemStack stack, @NotNull ItemAbility itemAbility) {
        if (this.isModuleEnabled(stack, (Holder)WeaponsModules.SWEEPING_UNIT)) {
            return ItemAbilities.DEFAULT_SWORD_ACTIONS.contains(itemAbility);
        }
        return false;
    }

    public boolean hurtEnemy(@NotNull ItemStack stack, @NotNull LivingEntity target, @NotNull LivingEntity attacker) {
        Player player;
        if (attacker instanceof Player && !(player = (Player)attacker).isCreative()) {
            long energyNeeded = MekaWeaponsUtils.getEnergyNeeded(stack);
            IEnergyContainer energyContainer = StorageUtils.getEnergyContainer((ItemStack)stack, (int)0);
            if (energyContainer != null) {
                energyContainer.extract(energyNeeded, Action.EXECUTE, AutomationType.MANUAL);
            }
        }
        return true;
    }

    public void adjustAttributes(@NotNull ItemAttributeModifierEvent event) {
        long totalDamage = MekaWeaponsUtils.getTotalDamage(event.getItemStack());
        event.addModifier(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, (double)totalDamage, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        event.addModifier(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, MekaWeapons.general.mekaTanaAttackSpeed.get(), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        super.adjustAttributes(event);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player player, @NotNull InteractionHand hand) {
        double targetZ;
        double targetY;
        ItemStack stack = player.getItemInHand(hand);
        if (world.isClientSide()) {
            return InteractionResultHolder.pass((Object)stack);
        }
        IModule module = this.getEnabledModule(stack, (DeferredHolder)MekanismModules.TELEPORTATION_UNIT);
        BlockHitResult result = MekanismUtils.rayTrace((Player)player, (double)MekaWeapons.general.mekaTanaMaxTeleportReach.get());
        if (module == null || ((ModuleTeleportationUnit)module.getCustomInstance()).requiresBlockTarget() && result.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)stack);
        }
        BlockPos pos = result.getBlockPos();
        double distance = player.distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        BlockState state1 = world.getBlockState(pos.above());
        BlockState state2 = world.getBlockState(pos.above(2));
        if (!state1.isAir() && !MekanismUtils.isLiquidBlock((Block)state1.getBlock()) || !state2.isAir() && !MekanismUtils.isLiquidBlock((Block)state2.getBlock()) || distance < 5.0) {
            return InteractionResultHolder.pass((Object)stack);
        }
        IEnergyContainer energyContainer = StorageUtils.getEnergyContainer((ItemStack)stack, (int)0);
        long energyNeeded = MathUtils.ceilToLong((double)((double)MekaWeapons.general.mekaTanaTeleportUsage.get() * (distance / 10.0)));
        if (energyContainer == null || energyContainer.getEnergy() < energyNeeded) {
            return InteractionResultHolder.fail((Object)stack);
        }
        double targetX = (double)pos.getX() + 0.5;
        MekanismTeleportEvent.MekaTool event = new MekanismTeleportEvent.MekaTool(player, targetX, targetY = (double)pos.getY() + 1.5, targetZ = (double)pos.getZ() + 0.5, stack, result);
        if (((MekanismTeleportEvent.MekaTool)NeoForge.EVENT_BUS.post((Event)event)).isCanceled()) {
            return InteractionResultHolder.fail((Object)stack);
        }
        energyContainer.extract(energyNeeded, Action.EXECUTE, AutomationType.MANUAL);
        if (player.isPassenger()) {
            player.dismountTo(targetX, targetY, targetZ);
        } else {
            player.teleportTo(targetX, targetY, targetZ);
        }
        player.resetFallDistance();
        PacketUtils.sendToAllTracking((CustomPacketPayload)new PacketPortalFX(pos.above()), (Level)world, (BlockPos)pos);
        world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_TELEPORT, SoundSource.PLAYERS);
        return InteractionResultHolder.success((Object)stack);
    }

    public boolean isBarVisible(@NotNull ItemStack stack) {
        return true;
    }

    public int getBarColor(@NotNull ItemStack stack) {
        return MekaWeaponsUtils.getBarCustomColor(stack);
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return MekaWeapons.general.mekaTanaEnchantments.get();
    }

    public boolean isBookEnchantable(@NotNull ItemStack stack, @NotNull ItemStack book) {
        return MekaWeapons.general.mekaTanaEnchantments.get();
    }

    public boolean isFoil(@NotNull ItemStack stack) {
        return false;
    }

    public ResourceLocation getRadialIdentifier() {
        return RADIAL_ID;
    }
}

