/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.nbt.validators.numeric;

import com.mojang.serialization.Codec;
import com.teamresourceful.resourcefullib.common.codecs.CodecExtras;
import com.teamresourceful.resourcefullib.common.nbt.validators.numeric.NumericValidator;
import java.lang.runtime.SwitchBootstraps;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;

public record ExactNumericValidator(Number number) implements NumericValidator
{
    public static final String ID = "number:exact";
    public static final Codec<ExactNumericValidator> CODEC = CodecExtras.NUMBER.xmap(ExactNumericValidator::new, ExactNumericValidator::number).fieldOf("number").codec();

    @Override
    public String id() {
        return ID;
    }

    @Override
    public boolean test(NumericTag tag) {
        NumericTag numericTag = tag;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ByteTag.class, ShortTag.class, IntTag.class, LongTag.class, FloatTag.class, DoubleTag.class}, (Object)numericTag, n)) {
            case 0 -> {
                ByteTag byteTag = (ByteTag)numericTag;
                if (byteTag.getAsByte() == this.number.byteValue()) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                ShortTag shortTag = (ShortTag)numericTag;
                if (shortTag.getAsShort() == this.number.shortValue()) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                IntTag intTag = (IntTag)numericTag;
                if (intTag.getAsInt() == this.number.intValue()) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                LongTag longTag = (LongTag)numericTag;
                if (longTag.getAsLong() == this.number.longValue()) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                FloatTag floatTag = (FloatTag)numericTag;
                if (floatTag.getAsFloat() == this.number.floatValue()) {
                    yield true;
                }
                yield false;
            }
            case 5 -> {
                DoubleTag doubleTag = (DoubleTag)numericTag;
                if (doubleTag.getAsDouble() == this.number.doubleValue()) {
                    yield true;
                }
                yield false;
            }
            case -1 -> false;
            default -> tag.getAsNumber().equals(this.number);
        };
    }
}

