/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser.network.client;

import fuzs.enchantinginfuser.world.inventory.InfuserMenu;
import fuzs.puzzleslib.api.network.v3.ServerMessageListener;
import fuzs.puzzleslib.api.network.v3.ServerboundMessage;
import java.util.function.IntUnaryOperator;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.enchantment.Enchantment;

public record ServerboundEnchantmentLevelMessage(int containerId, Holder<Enchantment> enchantment, Operation operation) implements ServerboundMessage<ServerboundEnchantmentLevelMessage>
{
    public ServerMessageListener<ServerboundEnchantmentLevelMessage> getHandler() {
        return new ServerMessageListener<ServerboundEnchantmentLevelMessage>(this){

            public void handle(ServerboundEnchantmentLevelMessage message, MinecraftServer server, ServerGamePacketListenerImpl handler, ServerPlayer player, ServerLevel level) {
                AbstractContainerMenu abstractContainerMenu;
                if (player.containerMenu.containerId == message.containerId && (abstractContainerMenu = player.containerMenu) instanceof InfuserMenu) {
                    InfuserMenu menu = (InfuserMenu)abstractContainerMenu;
                    menu.clickEnchantmentLevelButton(message.enchantment, message.operation);
                }
            }
        };
    }

    public static enum Operation implements IntUnaryOperator
    {
        ADD(enchantmentLevel -> enchantmentLevel + 1),
        REMOVE(enchantmentLevel -> enchantmentLevel - 1),
        ADD_ALL(Integer.MAX_VALUE),
        REMOVE_ALL(Integer.MIN_VALUE);

        private final IntUnaryOperator operator;

        private Operation(int value) {
            this(operand -> value);
        }

        private Operation(IntUnaryOperator operator) {
            this.operator = operator;
        }

        @Override
        public int applyAsInt(int enchantmentLevel) {
            return this.operator.applyAsInt(enchantmentLevel);
        }

        public static Operation remove() {
            return Screen.hasShiftDown() ? REMOVE_ALL : REMOVE;
        }

        public static Operation add() {
            return Screen.hasShiftDown() ? ADD_ALL : ADD;
        }
    }
}

