/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.core.gui.widget.premade.ButtonWidget;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class WormholeColoredButton
extends ButtonWidget {
    private final ResourceLocation RED_BUTTONS = ResourceLocation.fromNamespaceAndPath((String)"wormhole", (String)"textures/gui/red_buttons.png");
    private final ResourceLocation GREEN_BUTTONS = ResourceLocation.fromNamespaceAndPath((String)"wormhole", (String)"textures/gui/green_buttons.png");
    private int color;
    private boolean visible = true;

    public WormholeColoredButton(int x, int y, int width, int height, Component text, Runnable onPress) {
        super(x, y, width, height, text, onPress);
    }

    public void setColorWhite() {
        this.color = 0;
    }

    public void setColorRed() {
        this.color = 1;
    }

    public void setColorGreen() {
        this.color = 2;
    }

    public void setInvisible() {
        this.visible = false;
    }

    public void setVisible() {
        this.visible = true;
    }

    public void render(WidgetRenderContext context, int mouseX, int mouseY) {
        if (this.visible) {
            if (this.color == 0) {
                super.render(context, mouseX, mouseY);
            } else {
                ResourceLocation texture = this.color == 1 ? this.RED_BUTTONS : this.GREEN_BUTTONS;
                WormholeColoredButton.drawButtonBackground(context.poseStack(), this.x, this.y, this.width, this.height, (float)(this.isActive() ? (this.isFocused() ? 5 : 0) : 10) / 15.0f, texture);
                ScreenUtils.drawCenteredStringWithShadow((PoseStack)context.poseStack(), (Font)ClientUtils.getFontRenderer(), (Component)this.getText(), (float)((float)this.x + (float)this.width / 2.0f), (float)((float)this.y + (float)this.height / 2.0f - 5.0f), (int)(this.isActive() ? -1 : Integer.MAX_VALUE));
            }
        }
    }

    public void onPress() {
        if (this.visible) {
            super.onPress();
        }
    }

    public static void drawButtonBackground(PoseStack poseStack, float x, float y, float width, float height, float yOffset, ResourceLocation texture) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        ScreenUtils.bindTexture((ResourceLocation)texture);
        ScreenUtils.drawTexture((PoseStack)poseStack, (float)x, (float)y, (float)2.0f, (float)2.0f, (float)0.0f, (float)yOffset, (float)0.4f, (float)0.13333334f);
        ScreenUtils.drawTexture((PoseStack)poseStack, (float)(x + width - 2.0f), (float)y, (float)2.0f, (float)2.0f, (float)0.6f, (float)yOffset, (float)0.4f, (float)0.13333334f);
        ScreenUtils.drawTexture((PoseStack)poseStack, (float)(x + width - 2.0f), (float)(y + height - 2.0f), (float)2.0f, (float)2.0f, (float)0.6f, (float)(yOffset + 0.2f), (float)0.4f, (float)0.13333334f);
        ScreenUtils.drawTexture((PoseStack)poseStack, (float)x, (float)(y + height - 2.0f), (float)2.0f, (float)2.0f, (float)0.0f, (float)(yOffset + 0.2f), (float)0.4f, (float)0.13333334f);
        ScreenUtils.drawTexture((PoseStack)poseStack, (float)(x + 2.0f), (float)y, (float)(width - 4.0f), (float)2.0f, (float)0.4f, (float)yOffset, (float)0.2f, (float)0.13333334f);
        ScreenUtils.drawTexture((PoseStack)poseStack, (float)(x + 2.0f), (float)(y + height - 2.0f), (float)(width - 4.0f), (float)2.0f, (float)0.4f, (float)(yOffset + 0.2f), (float)0.2f, (float)0.13333334f);
        ScreenUtils.drawTexture((PoseStack)poseStack, (float)x, (float)(y + 2.0f), (float)2.0f, (float)(height - 4.0f), (float)0.0f, (float)(yOffset + 0.13333334f), (float)0.4f, (float)0.06666667f);
        ScreenUtils.drawTexture((PoseStack)poseStack, (float)(x + width - 2.0f), (float)(y + 2.0f), (float)2.0f, (float)(height - 4.0f), (float)0.6f, (float)(yOffset + 0.13333334f), (float)0.4f, (float)0.06666667f);
        ScreenUtils.drawTexture((PoseStack)poseStack, (float)(x + 2.0f), (float)(y + 2.0f), (float)(width - 4.0f), (float)(height - 4.0f), (float)0.4f, (float)(yOffset + 0.13333334f), (float)0.2f, (float)0.06666667f);
    }
}

