/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.EnergyFormat;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.core.gui.widget.premade.AbstractButtonWidget;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class EnergyBarWidget
extends AbstractButtonWidget {
    private static final ResourceLocation BARS = ResourceLocation.fromNamespaceAndPath((String)"wormhole", (String)"textures/gui/energy_bars.png");
    private final Supplier<Integer> energy;
    private final Supplier<Integer> capacity;

    public EnergyBarWidget(int x, int y, int width, int height, Supplier<Integer> energy, Supplier<Integer> capacity) {
        super(x, y, width, height, () -> EnergyFormat.cycleEnergyType((!Screen.hasShiftDown() ? 1 : 0) != 0));
        this.energy = energy;
        this.capacity = capacity;
    }

    public void render(WidgetRenderContext context, int mouseX, int mouseY) {
        float percentage;
        ScreenUtils.bindTexture((ResourceLocation)BARS);
        ScreenUtils.drawTexture((PoseStack)context.poseStack(), (float)this.x, (float)this.y, (float)this.width, (float)this.height, (float)(this.isFocused() ? 0.09090909f : 0.0f), (float)0.0f, (float)0.09090909f, (float)1.0f);
        int energy = this.energy.get();
        int capacity = this.capacity.get();
        float f = percentage = capacity == 0 ? 1.0f : Math.max(Math.min((float)energy / (float)capacity, 1.0f), 0.0f);
        if (percentage != 0.0f) {
            ScreenUtils.drawTexture((PoseStack)context.poseStack(), (float)this.x, (float)((float)this.y + (float)this.height * (1.0f - percentage)), (float)this.width, (float)((float)this.height * percentage), (float)0.27272728f, (float)(1.0f - percentage), (float)0.09090909f, (float)percentage);
        }
    }

    protected void getTooltips(Consumer<Component> tooltips) {
        int energy = this.energy.get();
        int capacity = this.capacity.get();
        tooltips.accept((Component)TextComponents.string((String)EnergyFormat.formatCapacityWithUnit((int)energy, (int)capacity)).get());
    }

    public Component getNarrationMessage() {
        return TextComponents.string((String)EnergyFormat.formatCapacityWithUnit((int)this.energy.get(), (int)this.capacity.get())).get();
    }
}

