/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.core.gui.widget.premade.AbstractButtonWidget;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ArrowButton
extends AbstractButtonWidget {
    private final ResourceLocation BUTTONS = ResourceLocation.fromNamespaceAndPath((String)"wormhole", (String)"textures/gui/arrow_buttons.png");
    private final boolean up;
    public boolean active = true;

    public ArrowButton(int x, int y, boolean up, Runnable onPress) {
        super(x, y, 10, 5, onPress);
        this.up = up;
    }

    public ArrowButton(int x, int y, int width, int height, boolean up, Runnable onPress) {
        super(x, y, width, height, onPress);
        this.up = up;
    }

    protected void getTooltips(Consumer<Component> tooltips) {
        tooltips.accept((Component)TextComponents.translation((String)("wormhole.gui.arrow_button." + (this.up ? "up" : "down"))).get());
    }

    public Component getNarrationMessage() {
        return TextComponents.translation((String)("wormhole.gui.arrow_button." + (this.up ? "up" : "down"))).get();
    }

    public void render(WidgetRenderContext context, int mouseX, int mouseY) {
        ScreenUtils.bindTexture((ResourceLocation)this.BUTTONS);
        float x = (float)(this.active ? (this.isFocused() ? 15 : 0) : 30) / 45.0f;
        float y = (float)(this.up ? 0 : 8) / 16.0f;
        ScreenUtils.drawTexture((PoseStack)context.poseStack(), (float)this.x, (float)this.y, (float)this.width, (float)this.height, (float)x, (float)y, (float)0.33333334f, (float)0.5f);
    }
}

