/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.portal.screen;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.render.RenderUtils;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Quaternionf;

public class ScreenBlockRenderer {
    public static void drawBlock(PoseStack poseStack, Block block, double x, double y, double scale, float yaw, float pitch) {
        BlockState state = block.defaultBlockState();
        poseStack.pushPose();
        poseStack.translate(x, y, 350.0);
        poseStack.scale(1.0f, -1.0f, 1.0f);
        poseStack.scale((float)scale, (float)scale, (float)scale);
        MultiBufferSource.BufferSource bufferSource = RenderUtils.getMainBufferSource();
        Lighting.setupForFlatItems();
        poseStack.mulPose(new Quaternionf().setAngleAxis((double)(pitch / 180.0f) * Math.PI, 1.0, 0.0, 0.0));
        poseStack.mulPose(new Quaternionf().setAngleAxis((double)(yaw / 180.0f) * Math.PI, 0.0, 1.0, 0.0));
        BakedModel model = ClientUtils.getBlockRenderer().getBlockModel(state);
        ModelData modelData = ModelData.EMPTY;
        poseStack.translate(-0.5, -0.5, -0.5);
        for (RenderType renderType : model.getRenderTypes(state, RandomSource.create((long)42L), modelData)) {
            ScreenBlockRenderer.renderModel(model, state, poseStack, bufferSource.getBuffer(renderType), modelData, renderType);
        }
        bufferSource.endBatch();
        poseStack.popPose();
        RenderSystem.enableDepthTest();
        Lighting.setupFor3DItems();
    }

    private static void renderModel(BakedModel model, BlockState state, PoseStack poseStack, VertexConsumer buffer, ModelData modelData, RenderType renderType) {
        RandomSource random = RandomSource.create();
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            ScreenBlockRenderer.renderQuads(poseStack, buffer, model.getQuads(state, direction, random, modelData, renderType));
        }
        random.setSeed(42L);
        ScreenBlockRenderer.renderQuads(poseStack, buffer, model.getQuads(state, null, random, modelData, renderType));
    }

    private static void renderQuads(PoseStack poseStack, VertexConsumer buffer, List<BakedQuad> quads) {
        PoseStack.Pose matrix = poseStack.last();
        for (BakedQuad bakedquad : quads) {
            buffer.putBulkData(matrix, bakedquad, 1.0f, 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.NO_OVERLAY, false);
        }
    }
}

