/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.portal.screen;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.wormhole.PortalBlock;
import com.supermartijn642.wormhole.energycell.EnergyCellBlock;
import com.supermartijn642.wormhole.portal.PortalShape;
import com.supermartijn642.wormhole.targetcell.TargetCellBlock;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class PortalRendererHelper {
    private static final int ROTATE_TIME = 20000;

    public static void drawPortal(PoseStack poseStack, PortalShape shape, float x, float y, float width, float height) {
        Level level = ClientUtils.getWorld();
        float scale = Math.min(width, height) / ((float)shape.span + 1.0f);
        Vector3f center = new Vector3f((float)(shape.maxCorner.getX() + shape.minCorner.getX()) / 2.0f, (float)(shape.maxCorner.getY() + shape.minCorner.getY()) / 2.0f, (float)(shape.maxCorner.getZ() + shape.minCorner.getZ()) / 2.0f);
        poseStack.pushPose();
        poseStack.translate(x + width / 2.0f, y + height / 2.0f, 350.0f);
        poseStack.scale(scale, -scale, scale);
        MultiBufferSource.BufferSource bufferSource = RenderUtils.getMainBufferSource();
        RenderSystem.setShaderLights((Vector3f)new Vector3f(0.0f, 1.0f, 0.0f), (Vector3f)new Vector3f(0.0f, 0.0f, 1.0f));
        poseStack.mulPose(new Quaternionf().setAngleAxis(0.7853981633974483, 1.0, 0.0, 0.0));
        poseStack.mulPose(new Quaternionf().setAngleAxis((double)(System.currentTimeMillis() % 20000L) / 20000.0 * Math.PI, 0.0, 1.0, 0.0));
        poseStack.translate(-center.x(), -center.y(), -center.z());
        for (BlockPos pos : shape.frame) {
            PortalRendererHelper.renderBlock(level, pos, poseStack, (MultiBufferSource)bufferSource, true);
        }
        for (BlockPos pos : shape.area) {
            if (level.isEmptyBlock(pos)) continue;
            PortalRendererHelper.renderBlock(level, pos, poseStack, (MultiBufferSource)bufferSource, level.getBlockState(pos).getBlock() instanceof PortalBlock);
            PortalRendererHelper.renderBlockEntity(level, pos, poseStack, (MultiBufferSource)bufferSource);
        }
        bufferSource.endBatch();
        poseStack.popPose();
        RenderSystem.enableDepthTest();
        Lighting.setupFor3DItems();
    }

    private static void renderBlock(Level level, BlockPos pos, PoseStack poseStack, MultiBufferSource bufferSource, boolean valid) {
        BlockState state = level.getBlockState(pos);
        if (!(state.getBlock() instanceof EnergyCellBlock) && !(state.getBlock() instanceof TargetCellBlock) && state.getRenderShape() != RenderShape.MODEL) {
            return;
        }
        BlockEntity entity = level.getBlockEntity(pos);
        BakedModel model = ClientUtils.getBlockRenderer().getBlockModel(state);
        ModelData modelData = entity == null ? ModelData.EMPTY : entity.getModelData();
        modelData = model.getModelData((BlockAndTintGetter)level, pos, state, modelData);
        poseStack.pushPose();
        poseStack.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
        PortalRendererHelper.translateAndRenderModel(state, poseStack, bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY, model, modelData, valid);
        poseStack.popPose();
    }

    private static void translateAndRenderModel(BlockState state, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay, BakedModel model, ModelData modelData, boolean valid) {
        poseStack.pushPose();
        poseStack.translate(-0.5, -0.5, -0.5);
        for (RenderType renderType : model.getRenderTypes(state, RandomSource.create((long)42L), modelData)) {
            PortalRendererHelper.renderModel(model, state, combinedLight, combinedOverlay, poseStack, bufferSource.getBuffer(renderType), modelData, renderType, valid);
        }
        poseStack.popPose();
    }

    private static void renderModel(BakedModel model, BlockState state, int combinedLight, int combinedOverlay, PoseStack poseStack, VertexConsumer buffer, ModelData modelData, RenderType renderType, boolean valid) {
        RandomSource random = RandomSource.create();
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            PortalRendererHelper.renderQuads(poseStack, buffer, model.getQuads(state, direction, random, modelData, renderType), combinedLight, combinedOverlay, valid);
        }
        random.setSeed(42L);
        PortalRendererHelper.renderQuads(poseStack, buffer, model.getQuads(state, null, random, modelData, renderType), combinedLight, combinedOverlay, valid);
    }

    private static void renderQuads(PoseStack poseStack, VertexConsumer buffer, List<BakedQuad> quads, int combinedLight, int combinedOverlay, boolean valid) {
        PoseStack.Pose matrix = poseStack.last();
        for (BakedQuad bakedquad : quads) {
            buffer.putBulkData(matrix, bakedquad, 1.0f, valid ? 1.0f : 0.5f, valid ? 1.0f : 0.5f, valid ? 1.0f : 0.8f, combinedLight, combinedOverlay, false);
        }
    }

    private static void renderBlockEntity(Level level, BlockPos pos, PoseStack poseStack, MultiBufferSource bufferSource) {
        BlockEntityRenderer entityRenderer;
        BlockEntity entity = level.getBlockEntity(pos);
        if (entity != null && (entityRenderer = ClientUtils.getMinecraft().getBlockEntityRenderDispatcher().getRenderer(entity)) != null) {
            poseStack.pushPose();
            poseStack.translate((double)pos.getX() - 0.5, (double)pos.getY() - 0.5, (double)pos.getZ() - 0.5);
            entityRenderer.render(entity, ClientUtils.getPartialTicks(), poseStack, bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
        }
    }
}

