/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.portal.packets;

import com.supermartijn642.core.network.PacketContext;
import com.supermartijn642.wormhole.packet.PortalGroupPacket;
import com.supermartijn642.wormhole.portal.PortalGroup;
import com.supermartijn642.wormhole.portal.PortalTarget;
import com.supermartijn642.wormhole.targetdevice.TargetDeviceItem;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public class PortalAddTargetPacket
extends PortalGroupPacket {
    private InteractionHand hand;
    private int index;

    public PortalAddTargetPacket(PortalGroup group, InteractionHand hand, int index) {
        super(group);
        this.hand = hand;
        this.index = index;
    }

    public PortalAddTargetPacket() {
    }

    public void write(FriendlyByteBuf buffer) {
        super.write(buffer);
        buffer.writeEnum((Enum)this.hand);
        buffer.writeInt(this.index);
    }

    public void read(FriendlyByteBuf buffer) {
        super.read(buffer);
        this.hand = (InteractionHand)buffer.readEnum(InteractionHand.class);
        this.index = buffer.readInt();
    }

    @Override
    protected void handle(PortalGroup group, PacketContext context) {
        ItemStack stack = context.getSendingPlayer().getItemInHand(this.hand);
        if (stack.isEmpty() || !(stack.getItem() instanceof TargetDeviceItem)) {
            return;
        }
        List<PortalTarget> targets = TargetDeviceItem.getTargets(stack);
        if (this.index >= 0 && this.index < targets.size()) {
            group.addTarget(targets.get(this.index));
        }
    }
}

