/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.packet;

import com.supermartijn642.core.network.BlockPosBasePacket;
import com.supermartijn642.core.network.PacketContext;
import com.supermartijn642.wormhole.PortalGroupCapability;
import com.supermartijn642.wormhole.portal.PortalGroup;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public abstract class PortalGroupPacket
extends BlockPosBasePacket {
    public PortalGroupPacket(PortalGroup group) {
        this.pos = group.shape.frame.get(0);
    }

    public PortalGroupPacket() {
    }

    protected void handle(BlockPos pos, PacketContext context) {
        Player player = context.getSendingPlayer();
        if (player == null || player.position().distanceToSqr((double)this.pos.getX(), (double)this.pos.getY(), (double)this.pos.getZ()) > 10000.0) {
            return;
        }
        Level level = context.getWorld();
        if (level == null) {
            return;
        }
        PortalGroupCapability groups = PortalGroupCapability.get(level);
        if (groups == null) {
            return;
        }
        PortalGroup group = groups.getGroup(this.pos);
        if (group == null) {
            return;
        }
        this.handle(group, context);
    }

    protected abstract void handle(PortalGroup var1, PacketContext var2);
}

